/*
 * This file is part of RDC-ANALYTIC.
 *
 * RDC-ANALYTIC Protein Backbone Structure Determination Software Version 1.0
 * Copyright (C) 2001-2012 Bruce Donald Lab, Duke University
 *
 * RDC-ANALYTIC is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * RDC-ANALYTIC is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see:
 *     <http://www.gnu.org/licenses/>.
 *
 * There are additional restrictions imposed on the use and distribution of this
 * open-source code, including: (A) this header must be included in any
 * modification or extension of the code; (B) you are required to cite our
 * papers in any publications that use this code. The citation for the various
 * different modules of our software, together with a complete list of
 * requirements and restrictions are found in the document license.pdf enclosed
 * with this distribution.
 *
 * Contact Info:
 *     Bruce R. Donald
 *     Duke University
 *     Department of Computer Science
 *     Levine Science Research Center (LSRC)
 *     Durham, NC 27708-0129
 *     USA
 *     email: www.cs.duke.edu/brd/
 *
 * <signature of Bruce Donald>, August 04, 2012
 * Bruce R. Donald, Professor of Computer Science and Biochemistry
 */

/**
 * @version       1.0.1, August 04, 2012
 * @author        Chittaranjan Tripathy (2007-2012)
 * @email         chittu@cs.duke.edu
 * @organization  Duke University
 */

/**
 * Package specification
 */
package analytic;

/**
 * Import statement(s)
 */
import java.io.*;
import java.util.*;

/**
 * Description of the class
 */
public class myProteinSequence {
    private Map<Integer, String> __seq_data = null;

    public myProteinSequence(String seqFileName) {
        if (seqFileName != null) {
            __seq_data = parseSequenceFile(seqFileName);
        }
    }

    @Override public String toString() {
        return __seq_data.toString();
    }
    
    public String getResidueType(int resNum) {
        return __seq_data.get(resNum);
    }

    private static Map<Integer, String> parseSequenceFile(String seqFileName) {
        Map<Integer, String> mySeq = new TreeMap<Integer, String>();

        try {
            Scanner scanner = new Scanner(new File(seqFileName));
            scanner.useDelimiter(System.getProperty("line.separator"));
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                line = line.trim();
                //System.out.println(line);
                if (line.length() != 0) {
                    String[] words = line.split("\\s+");
                    if ( words.length >= 2) {
                        int residueNumber = Integer.parseInt(words[0]);
                        String residueName = words[1].trim().toUpperCase();
                        mySeq.put(residueNumber, residueName);
                    }
                }
            }
            scanner.close();
        } catch (FileNotFoundException e) {
            System.out.println("Error: Input file " + seqFileName + " not found");
            e.printStackTrace();
        } 

        return mySeq;
    }

    @Deprecated private static Vector<myPair<Integer, String>> parseSequenceFileVectorFormat(String seqFileName) {
        Vector<myPair<Integer, String>> mySeq = new Vector<myPair<Integer, String>>();

        try {
            Scanner scanner = new Scanner(new File(seqFileName));
            scanner.useDelimiter(System.getProperty("line.separator"));
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                line = line.trim();
                //System.out.println(line);
                if (line.length() != 0) {
                    String[] words = line.split("\\s+");
                    if ( words.length >= 2) {
                        int residueNumber = Integer.parseInt(words[0]);
                        String residueName = words[1].trim().toUpperCase();
                        mySeq.add(new myPair<Integer, String>(residueNumber, residueName));
                    }
                }
            }
            scanner.close();
        } catch (FileNotFoundException e) {
            System.out.println("Error: Input file " + seqFileName + " not found");
            e.printStackTrace();
        }

        return mySeq;
    }

}
