/*
 * This file is part of RDC-ANALYTIC.
 *
 * RDC-ANALYTIC Protein Backbone Structure Determination Software Version 1.0
 * Copyright (C) 2001-2012 Bruce Donald Lab, Duke University
 *
 * RDC-ANALYTIC is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * RDC-ANALYTIC is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see:
 *     <http://www.gnu.org/licenses/>.
 *
 * There are additional restrictions imposed on the use and distribution of this
 * open-source code, including: (A) this header must be included in any
 * modification or extension of the code; (B) you are required to cite our
 * papers in any publications that use this code. The citation for the various
 * different modules of our software, together with a complete list of
 * requirements and restrictions are found in the document license.pdf enclosed
 * with this distribution.
 *
 * Contact Info:
 *     Bruce R. Donald
 *     Duke University
 *     Department of Computer Science
 *     Levine Science Research Center (LSRC)
 *     Durham, NC 27708-0129
 *     USA
 *     email: www.cs.duke.edu/brd/
 *
 * <signature of Bruce Donald>, August 04, 2012
 * Bruce R. Donald, Professor of Computer Science and Biochemistry
 */

/**
 * @version       1.0.1, August 04, 2012
 * @author        Chittaranjan Tripathy (2007-2012)
 * @email         chittu@cs.duke.edu
 * @organization  Duke University
 */

/**
 * Package specification
 */
package analytic;

/**
 * Import statement(s)
 */

/**
 * Description of the class
 */
public class myPhiPsi {
    private double __phi;
    private double __psi;
    private int __residue_number;  // number of first residue, though Phi and Psi are between two residues
    private String __residue_name; //We count it as belonging to the first of the two PPs

    public myPhiPsi() {
    }

    public myPhiPsi(int resNum, String resName, double phi, double psi) {
        __residue_number = resNum;
        __residue_name = resName;
        __phi = phi;
        __psi = psi;
        //phiLower = 0.0;
        //phiUpper = 0.0;
        //psiLower = 0.0;
        //psiUpper = 0.0;
    }

    /**
     * Return the residue name.
     *
     * @return the residue name
     */
    public String getResidueName() {
        return __residue_name;
    }

    /**
     * Return the residue number.
     *
     * @return the residue number
     */
    public int getResidueNumber() {
        return __residue_number;
    }

    public double getPhi() {
        return __phi;
    }

    public double getPsi() {
        return __psi;
    }
/*
    public double getPhiLower() {
        return phiLower;
    }

    public double getPhiUpper() {
        return phiUpper;
    }

    public double getPsiLower() {
        return psiLower;
    }

    public double getPsiUpper() {
        return psiUpper;
    }
*/
    
    @Override public String toString() {
        return String.valueOf(__residue_number) + "  " + __residue_name + "  " + String.valueOf(__phi * 180 / Math.PI) + "  " + String.valueOf(__psi * 180.0 / Math.PI);
    }







 


    
}
