/*
 * This file is part of RDC-ANALYTIC.
 *
 * RDC-ANALYTIC Protein Backbone Structure Determination Software Version 1.0
 * Copyright (C) 2001-2012 Bruce Donald Lab, Duke University
 *
 * RDC-ANALYTIC is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * RDC-ANALYTIC is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see:
 *     <http://www.gnu.org/licenses/>.
 *
 * There are additional restrictions imposed on the use and distribution of this
 * open-source code, including: (A) this header must be included in any
 * modification or extension of the code; (B) you are required to cite our
 * papers in any publications that use this code. The citation for the various
 * different modules of our software, together with a complete list of
 * requirements and restrictions are found in the document license.pdf enclosed
 * with this distribution.
 *
 * Contact Info:
 *     Bruce R. Donald
 *     Duke University
 *     Department of Computer Science
 *     Levine Science Research Center (LSRC)
 *     Durham, NC 27708-0129
 *     USA
 *     email: www.cs.duke.edu/brd/
 *
 * <signature of Bruce Donald>, August 04, 2012
 * Bruce R. Donald, Professor of Computer Science and Biochemistry
 */

/**
 * @version       1.0.1, August 04, 2012
 * @author        Chittaranjan Tripathy (2007-2012)
 * @email         chittu@cs.duke.edu
 * @organization  Duke University
 */

/**
 * Package specification
 */
package analytic;

/**
 * Import statement(s)
 */

/**
 * Description of the class
 */
public class myAtomLabel {

    // Proxy atoms for CSA
    public static String __C_CSAv1 = "Cv1";
    public static String __C_CSAv2 = "Cv2";

    //TODO: Perennial! adhere to new PDB format and see if the labels need to be changed.
    public static String  __OTHER =  "OTHER";
    public static String  __INVALID =  "INVALID";
    
    public static String  __N =  "N";    
    public static String  __H =  "H";

    public static String  __CA =  "CA";
    public static String  __HA =  "HA";

    public static String  __HA2 =  "HA2";//new format
    public static String  __HA3 =  "HA3";//new format
    
    public static String  __CB =  "CB";
    public static String  __HB =  "HB";
    
    public static String  __HB1 =  "HB1";//new format
    public static String  __HB2 =  "HB2";//new format
    public static String  __HB3 =  "HB3";//new format
    
    public static String  __C =  "C";
    public static String  __O =  "O";
    public static String  __OXT =  "OXT";
    public static String  __CH3 =  "CH3";
    
    public static String  __CG =  "CG";
    public static String  __CG1 =  "CG1";
    public static String  __CG2 =  "CG2";
    public static String  __HG =  "HG";
    
    public static String  __HG1 =  "HG1";//new format
    public static String  __HG2 =  "HG2";//new foramt
    public static String  __HG3 =  "HG3";//new format  
    public static String  __HG11 =  "HG11";//new format
    public static String  __HG12 =  "HG12";//new format
    public static String  __HG13 =  "HG13";//new format
    public static String  __HG21 =  "HG21";//new format
    public static String  __HG22 =  "HG22";//new format
    public static String  __HG23 =  "HG23";//new format    
    public static String  __OG =  "OG";
    public static String  __OG1 =  "OG1";
    public static String  __SG =  "SG";
    //  __HD1,  __HD2,  
    
    public static String  __CD =  "CD";
    public static String  __CD1 =  "CD1";
    public static String  __CD2 =  "CD2";
    public static String  __HD =  "HD";
    public static String  __HD1 =  "HD1";//new format
    public static String  __HD2 =  "HD2";//new format
    public static String  __HD3 =  "HD3";//new format
    
    public static String  __HD11 =  "HD11";//new format
    public static String  __HD12 =  "HD12";//new format
    public static String  __HD13 =  "HD13";//new format
    public static String  __HD21 =  "HD21";//new format
    public static String  __HD22 =  "HD22";//new format
    public static String  __HD23 =  "HD23";//new format
    
    public static String  __3HD2 =  "3HD2";    
    public static String  __SD =  "SD";
    public static String  __OD1 =  "OD1";
    public static String  __OD2 =  "OD2";
    public static String  __ND1 =  "ND1";
    public static String  __ND2 =  "ND2";
    
    public static String  __CE =  "CE";
    public static String  __CE1 =  "CE1";
    public static String  __CE2 =  "CE2";
    public static String  __CE3 =  "CE3";
    public static String  __HE =  "HE";
  
    public static String  __HE1 =  "HE1";//new format
    public static String  __HE2 =  "HE2";//new format
    public static String  __HE3 =  "HE3";//new format
    public static String  __HE21 =  "HE21";//new format
    public static String  __HE22 =  "HE22";//new format
    
    public static String  __OE1 =  "OE1";
    public static String  __OE2 =  "OE2";
    
    public static String  __NE =  "NE";
    public static String  __NE1 =  "NE1";
    public static String  __NE2 =  "NE2";
    
    public static String  __CZ =  "CZ";
    public static String  __CZ2 =  "CZ2";
    public static String  __CZ3 =  "CZ3";
    
    public static String  __NZ =  "NZ";
    public static String  __HZ =  "HZ";    
    public static String  __HZ1 =  "HZ1";//new format
    public static String  __HZ2 =  "HZ2";//new format
    public static String  __HZ3 =  "HZ3";//new format    
    //  __HZ2,  __HZ3,  
    
    public static String  __CH2 =  "CH2";    
    public static String  __NH1 =  "NH1";
    public static String  __NH2 =  "NH2";
    public static String  __OH =  "OH";
    public static String  __HH =  "HH";
    public static String  __HH2 =  "HH2";
    public static String  __HH11 =  "HH11";//new format
    public static String  __HH12 =  "HH12";//new format
    public static String  __HH21 =  "HH21";//new format
    public static String  __HH22 =  "HH22";//new format 
    public static String  __1HH3 =  "1HH3";
    public static String  __2HH3 =  "2HH3";
    public static String  __3HH3 =  "3HH3";        
}
