/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkImageFormatProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXEXTENT;
    public static final int MAXMIPLEVELS;
    public static final int MAXARRAYLAYERS;
    public static final int SAMPLECOUNTS;
    public static final int MAXRESOURCESIZE;

    public VkImageFormatProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImageFormatProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkExtent3D maxExtent() {
        return VkImageFormatProperties.nmaxExtent(this.address());
    }

    public VkImageFormatProperties maxExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.maxExtent());
        return this;
    }

    @NativeType(value="uint32_t")
    public int maxMipLevels() {
        return VkImageFormatProperties.nmaxMipLevels(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxArrayLayers() {
        return VkImageFormatProperties.nmaxArrayLayers(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int sampleCounts() {
        return VkImageFormatProperties.nsampleCounts(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long maxResourceSize() {
        return VkImageFormatProperties.nmaxResourceSize(this.address());
    }

    public static VkImageFormatProperties malloc() {
        return (VkImageFormatProperties)VkImageFormatProperties.wrap(VkImageFormatProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkImageFormatProperties calloc() {
        return (VkImageFormatProperties)VkImageFormatProperties.wrap(VkImageFormatProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkImageFormatProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkImageFormatProperties)VkImageFormatProperties.wrap(VkImageFormatProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkImageFormatProperties create(long address) {
        return (VkImageFormatProperties)VkImageFormatProperties.wrap(VkImageFormatProperties.class, (long)address);
    }

    @Nullable
    public static VkImageFormatProperties createSafe(long address) {
        return address == 0L ? null : (VkImageFormatProperties)VkImageFormatProperties.wrap(VkImageFormatProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkImageFormatProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkImageFormatProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkImageFormatProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageFormatProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkImageFormatProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkImageFormatProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkImageFormatProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkImageFormatProperties mallocStack() {
        return VkImageFormatProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageFormatProperties callocStack() {
        return VkImageFormatProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkImageFormatProperties mallocStack(MemoryStack stack) {
        return (VkImageFormatProperties)VkImageFormatProperties.wrap(VkImageFormatProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageFormatProperties callocStack(MemoryStack stack) {
        return (VkImageFormatProperties)VkImageFormatProperties.wrap(VkImageFormatProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageFormatProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageFormatProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageFormatProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageFormatProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkExtent3D nmaxExtent(long struct) {
        return VkExtent3D.create(struct + (long)MAXEXTENT);
    }

    public static int nmaxMipLevels(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXMIPLEVELS);
    }

    public static int nmaxArrayLayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXARRAYLAYERS);
    }

    public static int nsampleCounts(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLECOUNTS);
    }

    public static long nmaxResourceSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)MAXRESOURCESIZE);
    }

    static {
        Struct.Layout layout = VkImageFormatProperties.__struct((Struct.Member[])new Struct.Member[]{VkImageFormatProperties.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF), VkImageFormatProperties.__member((int)4), VkImageFormatProperties.__member((int)4), VkImageFormatProperties.__member((int)4), VkImageFormatProperties.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXEXTENT = layout.offsetof(0);
        MAXMIPLEVELS = layout.offsetof(1);
        MAXARRAYLAYERS = layout.offsetof(2);
        SAMPLECOUNTS = layout.offsetof(3);
        MAXRESOURCESIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageFormatProperties, Buffer>
    implements NativeResource {
        private static final VkImageFormatProperties ELEMENT_FACTORY = VkImageFormatProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImageFormatProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkExtent3D maxExtent() {
            return VkImageFormatProperties.nmaxExtent(this.address());
        }

        public Buffer maxExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.maxExtent());
            return this;
        }

        @NativeType(value="uint32_t")
        public int maxMipLevels() {
            return VkImageFormatProperties.nmaxMipLevels(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxArrayLayers() {
            return VkImageFormatProperties.nmaxArrayLayers(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int sampleCounts() {
            return VkImageFormatProperties.nsampleCounts(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long maxResourceSize() {
            return VkImageFormatProperties.nmaxResourceSize(this.address());
        }
    }
}

