/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDisplayModeParametersKHR;

public class VkDisplayModeCreateInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PARAMETERS;

    public VkDisplayModeCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDisplayModeCreateInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDisplayModeCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDisplayModeCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkDisplayModeCreateFlagsKHR")
    public int flags() {
        return VkDisplayModeCreateInfoKHR.nflags(this.address());
    }

    public VkDisplayModeParametersKHR parameters() {
        return VkDisplayModeCreateInfoKHR.nparameters(this.address());
    }

    public VkDisplayModeCreateInfoKHR parameters(Consumer<VkDisplayModeParametersKHR> consumer) {
        consumer.accept(this.parameters());
        return this;
    }

    public VkDisplayModeCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDisplayModeCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDisplayModeCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR flags(@NativeType(value="VkDisplayModeCreateFlagsKHR") int value) {
        VkDisplayModeCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR parameters(VkDisplayModeParametersKHR value) {
        VkDisplayModeCreateInfoKHR.nparameters(this.address(), value);
        return this;
    }

    public VkDisplayModeCreateInfoKHR set(int sType, long pNext, int flags, VkDisplayModeParametersKHR parameters) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.parameters(parameters);
        return this;
    }

    public VkDisplayModeCreateInfoKHR set(VkDisplayModeCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDisplayModeCreateInfoKHR malloc() {
        return (VkDisplayModeCreateInfoKHR)VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDisplayModeCreateInfoKHR calloc() {
        return (VkDisplayModeCreateInfoKHR)VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDisplayModeCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDisplayModeCreateInfoKHR)VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDisplayModeCreateInfoKHR create(long address) {
        return (VkDisplayModeCreateInfoKHR)VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkDisplayModeCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkDisplayModeCreateInfoKHR)VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDisplayModeCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDisplayModeCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDisplayModeCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplayModeCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDisplayModeCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDisplayModeCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDisplayModeCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDisplayModeCreateInfoKHR mallocStack() {
        return VkDisplayModeCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDisplayModeCreateInfoKHR callocStack() {
        return VkDisplayModeCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDisplayModeCreateInfoKHR mallocStack(MemoryStack stack) {
        return (VkDisplayModeCreateInfoKHR)VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayModeCreateInfoKHR callocStack(MemoryStack stack) {
        return (VkDisplayModeCreateInfoKHR)VkDisplayModeCreateInfoKHR.wrap(VkDisplayModeCreateInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDisplayModeCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDisplayModeCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDisplayModeCreateInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDisplayModeCreateInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static VkDisplayModeParametersKHR nparameters(long struct) {
        return VkDisplayModeParametersKHR.create(struct + (long)PARAMETERS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nparameters(long struct, VkDisplayModeParametersKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARAMETERS), (long)VkDisplayModeParametersKHR.SIZEOF);
    }

    static {
        Struct.Layout layout = VkDisplayModeCreateInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkDisplayModeCreateInfoKHR.__member((int)4), VkDisplayModeCreateInfoKHR.__member((int)POINTER_SIZE), VkDisplayModeCreateInfoKHR.__member((int)4), VkDisplayModeCreateInfoKHR.__member((int)VkDisplayModeParametersKHR.SIZEOF, (int)VkDisplayModeParametersKHR.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PARAMETERS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayModeCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkDisplayModeCreateInfoKHR ELEMENT_FACTORY = VkDisplayModeCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDisplayModeCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDisplayModeCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDisplayModeCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkDisplayModeCreateFlagsKHR")
        public int flags() {
            return VkDisplayModeCreateInfoKHR.nflags(this.address());
        }

        public VkDisplayModeParametersKHR parameters() {
            return VkDisplayModeCreateInfoKHR.nparameters(this.address());
        }

        public Buffer parameters(Consumer<VkDisplayModeParametersKHR> consumer) {
            consumer.accept(this.parameters());
            return this;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDisplayModeCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDisplayModeCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkDisplayModeCreateFlagsKHR") int value) {
            VkDisplayModeCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer parameters(VkDisplayModeParametersKHR value) {
            VkDisplayModeCreateInfoKHR.nparameters(this.address(), value);
            return this;
        }
    }
}

