/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools.resultdoc;

import edu.duke.cs.osprey.tools.Streams;
import edu.duke.cs.osprey.tools.resultdoc.GNUPlot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class Plot {
    public static List<Color> defaultColors = Arrays.asList(new Color("004586"), new Color("ff420e"), new Color("579d1c"), new Color("7e0021"), new Color("83caff"), new Color("314004"), new Color("aecf00"), new Color("4b1f6f"));
    public final List<Series> series = new ArrayList<Series>();
    public int width = 600;
    public int height = 400;
    public String xlabel = null;
    public String ylabel = null;
    public List<Color> colors = defaultColors;
    public List<String> xlabels = null;
    public Double xlabelrotate = null;
    public List<String> ylabels = null;
    public String key = null;

    public static <T> T modGet(List<T> items, int i) {
        return items.get(i % items.size());
    }

    public byte[] renderPng() {
        return GNUPlot.plotPng(this.width, this.height, c -> this.render(c));
    }

    public String renderSvg() {
        return GNUPlot.plotSvg(this.width, this.height, c -> this.render(c));
    }

    private Map<Number, String> makeIndexedTics(List<String> labels) {
        TreeMap<Number, String> out = new TreeMap<Number, String>();
        for (int i = 0; i < labels.size(); ++i) {
            out.put(i, labels.get(i));
        }
        return out;
    }

    private void addInfLabels(Axis axis, GNUPlot.Cmd c, GNUPlot.Cmd.Tics tics, Map<Axis, Double> neginfVals, Map<Axis, Double> posinfVals) throws IOException {
        boolean hasPosinf;
        boolean hasNeginf = this.series.stream().anyMatch(s -> {
            AxisInfo axisInfo = s.axisInfos.get((Object)axis);
            return axisInfo != null && axisInfo.hasNeginf;
        });
        if (hasNeginf) {
            double neginf = neginfVals.get((Object)axis);
            tics.add(neginf, "-Inf");
            c.command("set %srange [%f:]", axis.name().toLowerCase(), neginf - Math.abs(neginf) * 0.01);
        }
        if (hasPosinf = this.series.stream().anyMatch(s -> {
            AxisInfo axisInfo = s.axisInfos.get((Object)axis);
            return axisInfo != null && axisInfo.hasPosinf;
        })) {
            double posinf = posinfVals.get((Object)axis);
            tics.add(posinf, "+Inf");
            c.command("set %srange [:%f]", axis.name().toLowerCase(), posinf + Math.abs(posinf) * 0.01);
        }
    }

    private static String renderDouble(Double val, Double neginf, Double posinf) {
        if (val == null) {
            return "";
        }
        if (val == Double.NEGATIVE_INFINITY) {
            return neginf.toString();
        }
        if (val == Double.POSITIVE_INFINITY) {
            return posinf.toString();
        }
        return val.toString();
    }

    private void render(GNUPlot.Cmd c) throws IOException {
        boolean showY;
        boolean showX;
        for (Series s2 : this.series) {
            for (AxisInfo axisInfo2 : s2.axisInfos.values()) {
                axisInfo2.update();
                assert (Double.isFinite(axisInfo2.minFinite));
                assert (Double.isFinite(axisInfo2.maxFinite));
            }
        }
        Map<Axis, Double> neginfVals = Axis.makeMap();
        Map<Axis, Double> posinfVals = Axis.makeMap();
        for (Axis axis : Axis.values()) {
            Double maxFinite;
            Double minFinite = this.series.stream().map(s -> s.axisInfos.get((Object)axis)).filter(Objects::nonNull).map(axisInfo -> axisInfo.minFinite).min(Double::compare).orElse(null);
            if (minFinite == null || (maxFinite = (Double)this.series.stream().map(s -> s.axisInfos.get((Object)axis)).filter(Objects::nonNull).map(axisInfo -> axisInfo.maxFinite).max(Double::compare).orElse(null)) == null) continue;
            double padFactor = 0.1;
            double pad = (maxFinite - minFinite) * padFactor;
            neginfVals.put(axis, minFinite - pad);
            posinfVals.put(axis, maxFinite + pad);
        }
        for (int i = 0; i < this.series.size(); ++i) {
            c.datablock("series" + i, this.series.get(i).renderData(neginfVals, posinfVals));
        }
        c.key.set(this.key);
        c.command("set border 3 back");
        c.command("set tics nomirror");
        c.command("set style line 102 linecolor rgb \"#cccccc\" linetype 0 linewidth 1");
        c.command("set grid back linestyle 102");
        c.xlabel.set(this.xlabel);
        boolean bl = showX = this.series.stream().anyMatch(s -> s.axisInfos.containsKey((Object)Axis.X)) || this.xlabels != null || this.xlabelrotate != null;
        if (showX) {
            if (this.xlabels != null) {
                c.xtics.set(this.makeIndexedTics(this.xlabels));
            }
            this.addInfLabels(Axis.X, c, c.xtics, neginfVals, posinfVals);
            if (this.xlabelrotate != null) {
                c.xtics.rotate.set(-this.xlabelrotate.doubleValue());
            }
        } else {
            c.xtics.hide();
        }
        c.ylabel.set(this.ylabel);
        boolean bl2 = showY = this.series.stream().anyMatch(s -> s.axisInfos.containsKey((Object)Axis.Y)) || this.ylabels != null;
        if (showY) {
            if (this.ylabels != null) {
                c.ytics.set(this.makeIndexedTics(this.ylabels));
            }
            this.addInfLabels(Axis.Y, c, c.ytics, neginfVals, posinfVals);
        } else {
            c.ytics.hide();
        }
        ArrayList<String> seriesCmds = new ArrayList<String>();
        for (int i = 0; i < this.series.size(); ++i) {
            Series s3 = this.series.get(i);
            seriesCmds.add(String.format("$series%d using %s title \"%s\" %s", i, s3.renderCols(), s3.name != null ? s3.name : "Series " + i, s3.renderStyle(i, this.colors)));
        }
        c.command("plot " + String.join((CharSequence)", ", seriesCmds));
    }

    private static enum Axis {
        X,
        Y;


        public static <T> Map<Axis, T> makeMap() {
            return new EnumMap(Axis.class);
        }
    }

    public abstract class Series {
        public String name = null;
        public Color color = null;
        protected Map<Axis, AxisInfo> axisInfos = Axis.makeMap();

        public abstract String renderData(Map<Axis, Double> var1, Map<Axis, Double> var2);

        public abstract String renderCols();

        public abstract String renderStyle(int var1, List<Color> var2);

        public Series(Plot this$0) {
            this$0.series.add(this);
        }

        public Color pickColor(int seriesIndex, List<Color> colors) {
            if (this.color != null) {
                return this.color;
            }
            return Plot.modGet(colors, seriesIndex);
        }
    }

    private static abstract class AxisInfo {
        double minFinite = Double.NaN;
        double maxFinite = Double.NaN;
        boolean hasNeginf = false;
        boolean hasPosinf = false;
        String neginf = null;
        String posinf = null;

        private AxisInfo() {
        }

        abstract void update();

        static class DoubleList
        extends AxisInfo {
            private Supplier<List<Double>> dataSupplier;

            DoubleList(Supplier<List<Double>> dataSupplier) {
                this.dataSupplier = dataSupplier;
            }

            @Override
            void update() {
                List<Double> data = this.dataSupplier.get();
                this.minFinite = data.stream().filter(Objects::nonNull).filter(Double::isFinite).min(Double::compare).orElse(0.0);
                this.maxFinite = data.stream().filter(Objects::nonNull).filter(Double::isFinite).max(Double::compare).orElse(0.0);
                this.hasNeginf = data.stream().anyMatch(d -> d == Double.NEGATIVE_INFINITY);
                this.hasPosinf = data.stream().anyMatch(d -> d == Double.POSITIVE_INFINITY);
            }
        }
    }

    public static class Color {
        public final String hex;

        public Color(String hex) {
            this.hex = hex;
        }

        public String render() {
            return "rgbcolor \"#" + this.hex + "\"";
        }
    }

    public class IntervalsY
    extends Intervals {
        public double barwidth = 0.8;

        public IntervalsY(Plot this$0) {
            super(this$0, Axis.Y);
        }

        @Override
        public String renderData(Map<Axis, Double> neginfVals, Map<Axis, Double> posinfVals) {
            Double neginf = neginfVals.get((Object)Axis.X);
            Double posinf = posinfVals.get((Object)Axis.X);
            double barHalfWidth = this.barwidth / 2.0;
            AtomicInteger i = new AtomicInteger(0);
            return Streams.joinToString(this.data, "\n", interval -> {
                if (interval == null) {
                    i.getAndIncrement();
                    return "";
                }
                double x = i.getAndIncrement();
                double xlo = x - barHalfWidth;
                double xhi = x + barHalfWidth;
                double y = this.getIntervalMid((Interval)interval);
                double ylo = interval.min;
                double yhi = interval.max;
                return String.format("%f %s %f %f %s %s", x, Plot.renderDouble(y, neginf, posinf), xlo, xhi, Plot.renderDouble(ylo, neginf, posinf), Plot.renderDouble(yhi, neginf, posinf));
            });
        }
    }

    public class IntervalsX
    extends Intervals {
        public double barheight = 0.8;

        public IntervalsX(Plot this$0) {
            super(this$0, Axis.X);
        }

        @Override
        public String renderData(Map<Axis, Double> neginfVals, Map<Axis, Double> posinfVals) {
            Double neginf = neginfVals.get((Object)Axis.X);
            Double posinf = posinfVals.get((Object)Axis.X);
            double barHalfHeight = this.barheight / 2.0;
            AtomicInteger i = new AtomicInteger(0);
            return Streams.joinToString(this.data, "\n", interval -> {
                if (interval == null) {
                    i.getAndIncrement();
                    return "";
                }
                double x = this.getIntervalMid((Interval)interval);
                double xlo = interval.min;
                double xhi = interval.max;
                double y = i.getAndIncrement();
                double ylo = y - barHalfHeight;
                double yhi = y + barHalfHeight;
                return String.format("%s %f %s %s %f %f", Plot.renderDouble(x, neginf, posinf), y, Plot.renderDouble(xlo, neginf, posinf), Plot.renderDouble(xhi, neginf, posinf), ylo, yhi);
            });
        }
    }

    public abstract class Intervals
    extends Series {
        public List<Interval> data = null;

        protected Intervals(final Plot this$0, Axis axis) {
            super(this$0);
            this.axisInfos.put(axis, new AxisInfo(){

                @Override
                void update() {
                    this.minFinite = Intervals.this.data.stream().filter(Objects::nonNull).map(Interval::finiteMin).filter(Objects::nonNull).min(Double::compare).orElse(0.0);
                    this.maxFinite = Intervals.this.data.stream().filter(Objects::nonNull).map(Interval::finiteMax).filter(Objects::nonNull).max(Double::compare).orElse(0.0);
                    this.hasNeginf = Intervals.this.data.stream().filter(Objects::nonNull).anyMatch(i -> i.min == Double.NEGATIVE_INFINITY || i.max == Double.NEGATIVE_INFINITY);
                    this.hasPosinf = Intervals.this.data.stream().filter(Objects::nonNull).anyMatch(i -> i.min == Double.POSITIVE_INFINITY || i.max == Double.POSITIVE_INFINITY);
                }
            });
        }

        protected double getIntervalMid(Interval interval) {
            if (Double.isFinite(interval.min) && Double.isFinite(interval.max)) {
                return (interval.min + interval.max) / 2.0;
            }
            if (Double.isFinite(interval.min)) {
                return interval.min;
            }
            if (Double.isFinite(interval.max)) {
                return interval.max;
            }
            return 0.0;
        }

        @Override
        public String renderStyle(int seriesIndex, List<Color> colors) {
            return String.format("with boxxy linecolor %s", this.pickColor(seriesIndex, colors).render());
        }

        @Override
        public String renderCols() {
            return "1:2:3:4:5:6";
        }
    }

    public static class Interval {
        public double min;
        public double max;

        public Interval(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public Double finiteMin() {
            if (Double.isFinite(this.min)) {
                return this.min;
            }
            if (Double.isFinite(this.max)) {
                return this.max;
            }
            return null;
        }

        public Double finiteMax() {
            if (Double.isFinite(this.max)) {
                return this.max;
            }
            if (Double.isFinite(this.min)) {
                return this.min;
            }
            return null;
        }
    }

    public class LinesY
    extends Lines {
        public List<Double> data = null;

        public LinesY(Plot this$0) {
            super(this$0);
            this.axisInfos.put(Axis.Y, new AxisInfo.DoubleList(() -> this.data));
        }

        @Override
        public String renderData(Map<Axis, Double> neginfVals, Map<Axis, Double> posinfVals) {
            return this.renderData1D(this.data, neginfVals.get((Object)Axis.Y), posinfVals.get((Object)Axis.Y));
        }

        @Override
        public String renderCols() {
            return "0:1";
        }
    }

    public class LinesX
    extends Lines {
        public List<Double> data = null;

        public LinesX(Plot this$0) {
            super(this$0);
            this.axisInfos.put(Axis.X, new AxisInfo.DoubleList(() -> this.data));
        }

        @Override
        public String renderData(Map<Axis, Double> neginfVals, Map<Axis, Double> posinfVals) {
            return this.renderData1D(this.data, neginfVals.get((Object)Axis.X), posinfVals.get((Object)Axis.X));
        }

        @Override
        public String renderCols() {
            return "1:0";
        }
    }

    public abstract class Lines
    extends Series {
        public Lines(Plot this$0) {
            super(this$0);
        }

        protected String renderData1D(List<Double> data, Double neginf, Double posinf) {
            return Streams.joinToString(data, "\n", d -> Plot.renderDouble(d, neginf, posinf));
        }

        @Override
        public String renderStyle(int seriesIndex, List<Color> colors) {
            return String.format("with lines linecolor %s", this.pickColor(seriesIndex, colors).render());
        }
    }

    public class PointsY
    extends Points {
        public List<Double> data = null;

        public PointsY(Plot this$0) {
            super(this$0);
            this.axisInfos.put(Axis.Y, new AxisInfo.DoubleList(() -> this.data));
        }

        @Override
        public String renderData(Map<Axis, Double> neginfVals, Map<Axis, Double> posinfVals) {
            return this.renderData1D(this.data, neginfVals.get((Object)Axis.Y), posinfVals.get((Object)Axis.Y));
        }

        @Override
        public String renderCols() {
            return "0:1";
        }
    }

    public class PointsX
    extends Points {
        public List<Double> data = null;

        public PointsX(Plot this$0) {
            super(this$0);
            this.axisInfos.put(Axis.X, new AxisInfo.DoubleList(() -> this.data));
        }

        @Override
        public String renderData(Map<Axis, Double> neginfVals, Map<Axis, Double> posinfVals) {
            return this.renderData1D(this.data, neginfVals.get((Object)Axis.X), posinfVals.get((Object)Axis.X));
        }

        @Override
        public String renderCols() {
            return "1:0";
        }
    }

    public abstract class Points
    extends Series {
        public PointType type = null;
        public Double size = null;

        public Points(Plot this$0) {
            super(this$0);
        }

        protected String renderData1D(List<Double> data, Double neginf, Double posinf) {
            return Streams.joinToString(data, "\n", d -> Plot.renderDouble(d, neginf, posinf));
        }

        @Override
        public String renderStyle(int seriesIndex, List<Color> colors) {
            return String.format("with points linecolor %s %s %s", this.pickColor(seriesIndex, colors).render(), this.type == null ? "" : "pointtype " + this.type.id, this.size == null ? "" : "pointsize " + this.size);
        }
    }

    public static enum PointType {
        Dot(0),
        Plus(1),
        X(2),
        Star(3),
        Square(4),
        FilledSquare(5),
        Circle(6),
        CircleFilled(7),
        TriangleUp(8),
        TriangleUpFilled(9),
        TriangleDown(10),
        TriangleDownFilled(11),
        Diamond(12),
        DiamondFilled(13);

        public final int id;

        private PointType(int id) {
            this.id = id;
        }
    }
}

