/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Streams {
    public static <T> Stream<T> of(Iterator<T> iter) {
        return Streams.of(() -> iter);
    }

    public static <T> Stream<T> of(Iterable<T> things) {
        return StreamSupport.stream(things.spliterator(), false);
    }

    public static <T> Stream<T> of(T[] things) {
        return Arrays.stream(things);
    }

    public static <T> String joinToString(Iterable<T> things, String delimiter, Function<T, String> map) {
        if (things == null) {
            return "";
        }
        return String.join((CharSequence)delimiter, Streams.of(things).map(map).collect(Collectors.toList()));
    }

    public static <T> String joinToString(Iterable<T> things, String delimiter) {
        return Streams.joinToString(things, delimiter, (T thing) -> Objects.toString(thing));
    }

    public static <T> String joinToString(T[] things, String delimiter, Function<T, String> map) {
        if (things == null) {
            return "";
        }
        return String.join((CharSequence)delimiter, Streams.of(things).map(map).collect(Collectors.toList()));
    }

    public static <T> String joinToString(T[] things, String delimiter) {
        return Streams.joinToString(things, delimiter, (T thing) -> Objects.toString(thing));
    }

    public static <K, V> String joinToString(Map<K, V> things, String delimiter, BiFunction<K, V, String> map) {
        if (things == null) {
            return "";
        }
        return String.join((CharSequence)delimiter, Streams.of(things.entrySet()).map(entry -> (String)map.apply(entry.getKey(), entry.getValue())).collect(Collectors.toList()));
    }

    public static <K, V> String joinToString(Map<K, V> things, String delimiter) {
        return Streams.joinToString(things, delimiter, (K key, V val) -> Objects.toString(key) + "=" + Objects.toString(val));
    }

    public static String joinToString(int[] things, String delimiter, IntFunction<String> map) {
        if (things == null) {
            return "";
        }
        return String.join((CharSequence)delimiter, Arrays.stream(things).mapToObj(map).collect(Collectors.toList()));
    }

    public static String joinToString(long[] things, String delimiter, LongFunction<String> map) {
        if (things == null) {
            return "";
        }
        return String.join((CharSequence)delimiter, Arrays.stream(things).mapToObj(map).collect(Collectors.toList()));
    }

    public static String joinToString(double[] things, String delimiter, DoubleFunction<String> map) {
        if (things == null) {
            return "";
        }
        return String.join((CharSequence)delimiter, Arrays.stream(things).mapToObj(map).collect(Collectors.toList()));
    }
}

