/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tests;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.confspace.TupleEnumerator;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.plug.PolytopeMatrix;
import edu.duke.cs.osprey.pruning.PruningControl;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.util.ArrayList;
import java.util.Arrays;

public class PruningPlayground {
    String[] args;
    PolytopeMatrix plugMatCache = null;

    public static void main(String[] args) {
        Switches sw = new Switches(args);
        if (sw.usingSwitches()) {
            args = Arrays.copyOfRange(args, 0, args.length - 1);
        }
        PruningPlayground fun = new PruningPlayground(args);
        if (sw.isSwitchedOn(-1.0, false)) {
            System.out.println("Single-term PLUG only: ");
            fun.checkPruningEfficacy(true, false, false, 0.0);
        }
        if (sw.isSwitchedOn(-1.0, true)) {
            System.out.println("PLUG only: ");
            fun.checkPruningEfficacy(true, true, false, 0.0);
        }
        for (double ival : new double[]{0.0, 5.0, 10.0, 15.0, 20.0, 1000000.0}) {
            System.out.println("Ival: " + ival);
            if (sw.isSwitchedOn(ival, false)) {
                System.out.println("DEE only: ");
                fun.checkPruningEfficacy(false, false, true, ival);
            }
            if (!sw.isSwitchedOn(ival, true)) continue;
            System.out.println("DEE+PLUG: ");
            fun.checkPruningEfficacy(true, true, true, ival);
        }
    }

    public PruningPlayground(String[] args) {
        this.args = args;
    }

    private void checkPruningEfficacy(boolean usePLUG, boolean fullPLUGPruning, boolean useDEE, double pruningInterval) {
        ConfigFileParser cfp = ConfigFileParser.makeFromFilePaths(this.args);
        cfp.loadData();
        SearchProblem sp = cfp.getSearchProblem();
        sp.loadEnergyMatrix();
        sp.pruneMat = new PruningMatrix(sp.confSpace, pruningInterval);
        if (usePLUG) {
            if (fullPLUGPruning) {
                if (this.plugMatCache == null) {
                    this.plugMatCache = new PolytopeMatrix(sp, true);
                }
                this.plugMatCache.doMultiTermPruning(sp.pruneMat, true);
            } else {
                new PolytopeMatrix(sp, true);
            }
        }
        if (useDEE) {
            boolean useTriples;
            boolean bl = useTriples = pruningInterval < 1000.0;
            if (useDEE) {
                this.prepareCompetitorPruneMat(sp, pruningInterval, useTriples);
            }
            PruningControl pruningControl = new PruningControl(sp, pruningInterval, false, 100.0, 3, true, useTriples, false, false, false, 100.0);
            pruningControl.prune();
        }
        TupleEnumerator tupEnum = new TupleEnumerator(sp.pruneMat, null, sp.confSpace.numPos);
        System.out.println(tupEnum.enumerateUnprunedTuples(1).size() + " unpruned singles, out of " + PruningPlayground.totalNumSingles(sp));
        System.out.println(tupEnum.enumerateUnprunedTuples(2).size() + " unpruned pairs");
    }

    private static int totalNumSingles(SearchProblem sp) {
        int ans = 0;
        for (int nr : sp.confSpace.getNumRCsAtPos()) {
            ans += nr;
        }
        return ans;
    }

    private void prepareCompetitorPruneMat(SearchProblem sp, double pruningInterval, boolean useTriples) {
        System.out.println("PRECOMPUTING COMPETITOR PRUNING MATRIX");
        PruningMatrix tmpPruneMat = sp.pruneMat;
        sp.pruneMat = new PruningMatrix(sp.confSpace, 0.0);
        TupleEnumerator tupEnum = new TupleEnumerator(sp.pruneMat, null, sp.confSpace.numPos);
        for (int numPos = 1; numPos <= 3; ++numPos) {
            for (RCTuple tup : tupEnum.enumerateUnprunedTuples(numPos)) {
                if (!tmpPruneMat.isPruned(tup)) continue;
                sp.pruneMat.setTupleValue(tup, true);
            }
        }
        PruningControl pruningControl = new PruningControl(sp, 0.0, false, 100.0, 3, true, useTriples, false, false, false, 100.0);
        pruningControl.setOnlyGoldstein(true);
        pruningControl.prune();
        sp.competitorPruneMat = sp.pruneMat;
        sp.pruneMat = tmpPruneMat;
        System.out.println("COMPETITOR PRUNING DONE");
    }

    private static class Switches {
        ArrayList<RunPair> switchedOn = null;

        private Switches(String[] args) {
            String arg = args[args.length - 1];
            if (arg.startsWith("SWITCHES")) {
                this.switchedOn = new ArrayList();
                String[] tok = arg.split(",");
                for (int a = 0; a < tok.length / 2; ++a) {
                    this.switchedOn.add(new RunPair(Double.parseDouble(tok[2 * a + 1]), Boolean.parseBoolean(tok[2 * a + 2])));
                }
            }
        }

        boolean usingSwitches() {
            return this.switchedOn != null;
        }

        boolean isSwitchedOn(double ival, boolean second) {
            if (!this.usingSwitches()) {
                return true;
            }
            for (RunPair rp : this.switchedOn) {
                if (!rp.matches(ival, second)) continue;
                return true;
            }
            return false;
        }

        private static class RunPair {
            double ival;
            boolean second;

            private RunPair(double ival, boolean second) {
                this.ival = ival;
                this.second = second;
            }

            private boolean matches(double ival, boolean second) {
                return Math.abs(ival - this.ival) < 1.0E-10 && second == this.second;
            }
        }
    }
}

