/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure.analysis;

import edu.duke.cs.osprey.tools.Protractor;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SmallAngleVoxel {
    public Interval[] intervals;

    public SmallAngleVoxel(Interval ... intervals) {
        this.intervals = intervals;
    }

    public SmallAngleVoxel(double[] p) {
        this.intervals = new Interval[p.length];
        for (int d = 0; d < p.length; ++d) {
            this.intervals[d] = new Interval(p[d]);
        }
    }

    public static SmallAngleVoxel makeFromBounds(double[] bounds) {
        if (bounds.length % 3 != 0) {
            throw new IllegalArgumentException("bounds could come in multiples of 3");
        }
        int n = bounds.length / 3;
        Interval[] voxels = new Interval[n];
        for (int i = 0; i < n; ++i) {
            int i3 = i * 3;
            voxels[i] = new Interval(bounds[i3], bounds[i3 + 1], bounds[i3 + 2]);
        }
        return new SmallAngleVoxel(voxels);
    }

    public void expand(double[] p) {
        for (int d = 0; d < p.length; ++d) {
            this.intervals[d].expand(p[d]);
        }
    }

    public double volume() {
        if (this.intervals.length == 0) {
            return 0.0;
        }
        double v = 1.0;
        for (Interval interval : this.intervals) {
            v *= interval.size();
        }
        return v;
    }

    public boolean contains(double[] p) {
        for (int d = 0; d < p.length; ++d) {
            if (this.intervals[d].contains(p[d])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int d = 0; d < this.intervals.length; ++d) {
            if (d > 0) {
                buf.append("\n");
            }
            buf.append(this.intervals[d].toString());
        }
        return buf.toString();
    }

    public List<double[]> filter(Collection<double[]> points) {
        return points.stream().filter((? super T p) -> this.contains((double[])p)).collect(Collectors.toList());
    }

    public static class Interval {
        public double center;
        public double less;
        public double more;

        public Interval(double center) {
            this(0.0, center, 0.0);
        }

        public Interval(double less, double center, double more) {
            this.center = center;
            this.less = less;
            this.more = more;
        }

        public void expand(double p) {
            double delta = Protractor.getDeltaDegrees(this.center, p);
            if (delta < this.less) {
                this.less = delta;
            }
            if (delta > this.more) {
                this.more = delta;
            }
        }

        public double size() {
            return this.more - this.less;
        }

        public boolean contains(double p) {
            double delta = Protractor.getDeltaDegrees(this.center, p);
            return delta >= this.less && delta <= this.more;
        }

        public double min() {
            return Protractor.normalizeDegrees(this.center + this.less);
        }

        public double max() {
            return Protractor.normalizeDegrees(this.center + this.more);
        }

        public String toString() {
            return String.format("[%6.1f, %6.1f, %6.1f] -> [%6.1f,%6.1f]  width=%6.1f", this.less, this.center, this.more, this.min(), this.max(), this.more - this.less);
        }
    }
}

