/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure;

import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.AtomConnectivity;
import edu.duke.cs.osprey.structure.AtomNeighbors;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.Residues;
import edu.duke.cs.osprey.tools.ConfigFileReader;
import edu.duke.cs.osprey.tools.FileTools;
import edu.duke.cs.osprey.tools.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class Probe {
    public double maxOverlapHBond = Double.NaN;
    public double maxOverlapSaltBridge = Double.NaN;
    public double minOverlapWideContact = Double.NaN;
    public double minOverlapCloseContact = Double.NaN;
    public double minOverlapBadClash = Double.NaN;
    private Map<String, List<Template>> templatesByResType = new HashMap<String, List<Template>>();
    private Map<ResidueTemplate, Template> templateMap = new IdentityHashMap<ResidueTemplate, Template>();

    public Probe() {
        this(true);
    }

    public Probe(boolean loadDefaults) {
        if (loadDefaults) {
            this.load(FileTools.readResource("/config/probe.cfg"));
        }
    }

    public void load(String configText) {
        ConfigFileReader reader = new ConfigFileReader(configText);
        reader.advanceToNonEmptyLine();
        while (reader.getLine() != null) {
            String section = reader.getSectionName();
            if (section.equalsIgnoreCase("params")) {
                this.loadParams(reader);
                continue;
            }
            if (section.equalsIgnoreCase("templates")) {
                this.loadTemplates(reader);
                continue;
            }
            throw new IllegalArgumentException("unknown section: " + section);
        }
    }

    private void loadParams(ConfigFileReader reader) {
        while (true) {
            reader.advanceToNonEmptyLine();
            if (reader.getLine() == null || reader.getSectionName() != null) break;
            try {
                reader.getAssignment((name, value2) -> {
                    if (name.equalsIgnoreCase("MaxOverlapHBond")) {
                        this.maxOverlapHBond = Double.parseDouble(value2);
                    } else if (name.equalsIgnoreCase("MaxOverlapSaltBridge")) {
                        this.maxOverlapSaltBridge = Double.parseDouble(value2);
                    } else if (name.equalsIgnoreCase("MinOverlapWideContact")) {
                        this.minOverlapWideContact = Double.parseDouble(value2);
                    } else if (name.equalsIgnoreCase("MinOverlapCloseContact")) {
                        this.minOverlapCloseContact = Double.parseDouble(value2);
                    } else if (name.equalsIgnoreCase("MinOverlapBadClash")) {
                        this.minOverlapBadClash = Double.parseDouble(value2);
                    }
                });
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("can't parse param value: " + reader.getLine());
            }
        }
    }

    private void loadTemplates(ConfigFileReader reader) {
        block2: while (true) {
            reader.advanceToNonEmptyLine();
            if (reader.getLine() == null || reader.getSectionName() != null) break;
            String id = reader.getLine();
            String[] parts = id.split("-");
            String resType = parts[0];
            String classifier = null;
            if (parts.length >= 2) {
                classifier = parts[1];
            }
            ArrayList<AtomInfo> atomInfos = new ArrayList<AtomInfo>();
            while (true) {
                reader.advance();
                if (reader.getLine() == null || reader.getLine().isEmpty()) continue block2;
                StringTokenizer tok = new StringTokenizer(reader.getLine(), " \t");
                try {
                    String atomName = tok.nextToken();
                    double vdwRadius = Double.parseDouble(tok.nextToken());
                    ArrayList<AtomFlag> flags = new ArrayList<AtomFlag>();
                    if (tok.hasMoreTokens()) {
                        String flagsStr = tok.nextToken();
                        if (flagsStr.startsWith("-")) {
                            flags.add(AtomFlag.Negative);
                            flagsStr = flagsStr.substring(1);
                        } else if (flagsStr.startsWith("+")) {
                            flags.add(AtomFlag.Positive);
                            flagsStr = flagsStr.substring(1);
                        }
                        if (flagsStr.equalsIgnoreCase("donor")) {
                            flags.add(AtomFlag.Donor);
                        } else if (flagsStr.equalsIgnoreCase("acceptor")) {
                            flags.add(AtomFlag.Acceptor);
                        }
                    }
                    atomInfos.add(new AtomInfo(atomName, vdwRadius, flags));
                }
                catch (NumberFormatException | NoSuchElementException ex) {
                    throw new IllegalArgumentException("can't parse atom record: " + reader.getLine());
                }
                this.templatesByResType.computeIfAbsent(resType, resTypeAgain -> new ArrayList()).add(new Template(id, resType, classifier, atomInfos));
            }
            break;
        }
    }

    public boolean matchTemplates(Residues residues) {
        HashSet<ResidueTemplate> templates = new HashSet<ResidueTemplate>();
        for (Residue res : residues) {
            templates.add(res.template);
        }
        boolean allMatched = true;
        for (ResidueTemplate template : templates) {
            allMatched &= this.matchTemplate(template);
        }
        return allMatched;
    }

    public boolean matchTemplates(ResidueTemplateLibrary templateLib) {
        return this.matchTemplates(templateLib.templates) && this.matchTemplates(templateLib.wildTypeTemplates.values());
    }

    public boolean matchTemplates(Collection<ResidueTemplate> templates) {
        boolean allMatched = true;
        for (ResidueTemplate templ : templates) {
            allMatched &= this.matchTemplate(templ);
        }
        return allMatched;
    }

    public boolean matchTemplates(SimpleConfSpace confSpace) {
        HashSet<ResidueTemplate> templates = new HashSet<ResidueTemplate>();
        for (SimpleConfSpace.Position pos : confSpace.positions) {
            for (SimpleConfSpace.ResidueConf rc : pos.resConfs) {
                templates.add(rc.template);
            }
        }
        for (Strand strand : confSpace.strands) {
            for (Residue res : strand.mol.residues) {
                templates.add(res.template);
            }
        }
        boolean allMatched = true;
        for (ResidueTemplate template : templates) {
            allMatched &= this.matchTemplate(template);
        }
        return allMatched;
    }

    public boolean matchTemplate(ResidueTemplate resTemplate) {
        List<Template> templates = this.templatesByResType.get(resTemplate.name);
        if (templates == null) {
            return false;
        }
        HashSet<String> resAtomNames = new HashSet<String>();
        for (Atom atom : resTemplate.templateRes.atoms) {
            resAtomNames.add(atom.name);
        }
        for (Template template : templates) {
            if (!resAtomNames.equals(template.atoms.keySet())) continue;
            this.templateMap.put(resTemplate, template);
            return true;
        }
        return false;
    }

    public Template getTemplate(Residue res) {
        if (res.template == null) {
            throw new IllegalArgumentException("residue " + String.valueOf(res) + " does not have a template");
        }
        Template template = this.templateMap.get(res.template);
        if (template == null) {
            Set atomNames2 = res.template.templateRes.atoms.stream().map(atom -> atom.name).collect(Collectors.toSet());
            throw new IllegalArgumentException("no probe template for residue template " + String.valueOf(res.template) + " with atoms " + Streams.joinToString(atomNames2, ","));
        }
        return template;
    }

    public AtomInfo getAtomInfo(Atom a) {
        if (a.res == null) {
            throw new IllegalArgumentException("atom " + a.name + " does not have a residue");
        }
        Template template = this.getTemplate(a.res);
        AtomInfo info2 = template.atoms.get(a.name);
        if (info2 == null) {
            throw new IllegalArgumentException("no probe atom info for " + a.name + " in template " + template.id);
        }
        return info2;
    }

    public double getViolation(double overlap, double maxOverlap, double tolerance) {
        return overlap - maxOverlap - tolerance;
    }

    public double getDistSq(Atom a, Atom b) {
        int i = a.indexInRes * 3;
        double ax = a.res.coords[i];
        double ay = a.res.coords[i + 1];
        double az = a.res.coords[i + 2];
        i = b.indexInRes * 3;
        double bx = b.res.coords[i];
        double by = b.res.coords[i + 1];
        double bz = b.res.coords[i + 2];
        double dx = ax - bx;
        double dy = ay - by;
        double dz = az - bz;
        return dx * dx + dy * dy + dz * dz;
    }

    public double getDist(Atom a, Atom b) {
        return Math.sqrt(this.getDistSq(a, b));
    }

    public Attraction getAttraction(AtomInfo a, AtomInfo b) {
        boolean bothCharged;
        boolean donorAcceptorMatch;
        boolean bl = donorAcceptorMatch = a.flags.contains((Object)AtomFlag.Donor) && b.flags.contains((Object)AtomFlag.Acceptor) || a.flags.contains((Object)AtomFlag.Acceptor) && b.flags.contains((Object)AtomFlag.Donor);
        if (!donorAcceptorMatch) {
            return Attraction.None;
        }
        boolean bl2 = bothCharged = !(!a.flags.contains((Object)AtomFlag.Positive) && !a.flags.contains((Object)AtomFlag.Negative) || !b.flags.contains((Object)AtomFlag.Positive) && !b.flags.contains((Object)AtomFlag.Negative));
        if (bothCharged) {
            boolean chargeComplementarity;
            boolean bl3 = chargeComplementarity = a.flags.contains((Object)AtomFlag.Positive) && b.flags.contains((Object)AtomFlag.Negative) || a.flags.contains((Object)AtomFlag.Negative) && b.flags.contains((Object)AtomFlag.Positive);
            if (chargeComplementarity) {
                return Attraction.SaltBridge;
            }
            return Attraction.None;
        }
        return Attraction.Hbond;
    }

    public double getOverlap(AtomInfo a, AtomInfo b, double dist) {
        return a.vdwRadius + b.vdwRadius - dist;
    }

    public double getMaxOverlap(Attraction attraction) {
        if (attraction == Attraction.Hbond) {
            return this.maxOverlapHBond;
        }
        if (attraction == Attraction.SaltBridge) {
            return this.maxOverlapSaltBridge;
        }
        return 0.0;
    }

    public Contact getContact(double overlap, double maxOverlap, Attraction attraction) {
        if (overlap < this.minOverlapWideContact) {
            return Contact.NoContact;
        }
        if (overlap < this.minOverlapCloseContact) {
            return Contact.WideContact;
        }
        if (overlap <= 0.0) {
            return Contact.CloseContact;
        }
        if (attraction.isBond) {
            if (overlap <= maxOverlap) {
                return Contact.Bonded;
            }
            if (overlap - maxOverlap < this.minOverlapBadClash) {
                return Contact.SmallClash;
            }
            return Contact.BadClash;
        }
        if (overlap < this.minOverlapBadClash) {
            return Contact.SmallClash;
        }
        return Contact.BadClash;
    }

    public List<AtomPair.Interaction> getInteractions(Residues residues, ResidueInteractions inters, AtomConnectivity connectivity) {
        ArrayList<AtomPair.Interaction> interactions = new ArrayList<AtomPair.Interaction>();
        for (ResidueInteractions.Pair resPair : inters) {
            Residue res1 = residues.getOrThrow(resPair.resNum1);
            Residue res2 = residues.getOrThrow(resPair.resNum2);
            for (int[] atomPair : connectivity.getAtomPairs(res1, res2).getPairs(AtomNeighbors.Type.NONBONDED)) {
                Atom a1 = res1.atoms.get(atomPair[0]);
                Atom a2 = res2.atoms.get(atomPair[1]);
                interactions.add(new AtomPair(a1, a2).getInteraction());
            }
        }
        return interactions;
    }

    public List<AtomPair.Interaction> getInteractions(Residue res, AtomConnectivity connectivity) {
        ArrayList<AtomPair.Interaction> interactions = new ArrayList<AtomPair.Interaction>();
        for (int[] atomPair : connectivity.getAtomPairs(res, res).getPairs(AtomNeighbors.Type.NONBONDED)) {
            Atom a1 = res.atoms.get(atomPair[0]);
            Atom a2 = res.atoms.get(atomPair[1]);
            interactions.add(new AtomPair(a1, a2).getInteraction());
        }
        return interactions;
    }

    public static enum AtomFlag {
        Donor,
        Acceptor,
        Positive,
        Negative;

    }

    public static class AtomInfo {
        public final String name;
        public final double vdwRadius;
        public final EnumSet<AtomFlag> flags;

        public AtomInfo(String name, double vdwRadius, List<AtomFlag> flags) {
            this.name = name;
            this.vdwRadius = vdwRadius;
            this.flags = EnumSet.noneOf(AtomFlag.class);
            this.flags.addAll(flags);
        }
    }

    public static class Template {
        public final String id;
        public final String resType;
        public final String classifier;
        public final Map<String, AtomInfo> atoms;

        public Template(String id, String resType, String classifier, List<AtomInfo> atomInfos) {
            this.id = id;
            this.resType = resType;
            this.classifier = classifier;
            this.atoms = new HashMap<String, AtomInfo>();
            for (AtomInfo info2 : atomInfos) {
                this.atoms.put(info2.name, info2);
            }
        }
    }

    public static enum Attraction {
        None(false),
        Hbond(true),
        SaltBridge(true);

        public final boolean isBond;

        private Attraction(boolean isBond) {
            this.isBond = isBond;
        }
    }

    public static enum Contact {
        NoContact(false, false, false),
        WideContact(true, false, false),
        CloseContact(true, false, false),
        SmallClash(true, true, false),
        BadClash(true, true, false),
        Bonded(true, false, true);

        public final boolean isContact;
        public final boolean isClash;
        public final boolean isBond;

        private Contact(boolean isContact, boolean isClash, boolean isBond) {
            this.isContact = isContact;
            this.isClash = isClash;
            this.isBond = isBond;
        }
    }

    public class AtomPair {
        public final Probe probe;
        public final Atom a;
        public final Atom b;
        public final AtomInfo infoa;
        public final AtomInfo infob;
        public final Attraction attraction;
        public final double maxOverlap;

        public AtomPair(Atom a, Atom b) {
            this(a, b, this$0.getAtomInfo(a), this$0.getAtomInfo(b));
        }

        public AtomPair(Atom a, Atom b, AtomInfo infoa, AtomInfo infob) {
            this.probe = Probe.this;
            this.a = a;
            this.b = b;
            this.infoa = infoa;
            this.infob = infob;
            this.attraction = Probe.this.getAttraction(infoa, infob);
            this.maxOverlap = Probe.this.getMaxOverlap(this.attraction);
        }

        public double getDist() {
            return this.probe.getDist(this.a, this.b);
        }

        public Interaction getInteraction() {
            double dist = this.getDist();
            double overlap = Probe.this.getOverlap(this.infoa, this.infob, dist);
            Contact contact = this.getContact(overlap);
            return new Interaction(dist, overlap, contact);
        }

        public Contact getContact(double overlap) {
            return this.probe.getContact(overlap, this.maxOverlap, this.attraction);
        }

        public double getViolation(double tolerance) {
            double dist = this.getDist();
            double overlap = Probe.this.getOverlap(this.infoa, this.infob, dist);
            return this.probe.getViolation(overlap, this.maxOverlap, tolerance);
        }

        public String toString() {
            return String.format("%s:%-4s <-> %s:%-4s", this.a.res.getPDBResNumber(), this.a.name, this.b.res.getPDBResNumber(), this.b.name);
        }

        public class Interaction {
            public final AtomPair atomPair;
            public final double dist;
            public final double overlap;
            public final Contact contact;

            public Interaction(double dist, double overlap, Contact contact) {
                this.atomPair = AtomPair.this;
                this.dist = dist;
                this.overlap = overlap;
                this.contact = contact;
            }

            public double getViolation(double tolerance) {
                return AtomPair.this.probe.getViolation(this.overlap, AtomPair.this.maxOverlap, tolerance);
            }

            public boolean isClash(double tolerance) {
                return this.getViolation(tolerance) > 0.0;
            }

            public String toString() {
                return String.format("%-10s overlap=%8.3f %s%5.3f%12s", AtomPair.this.attraction == Attraction.None ? "" : AtomPair.this.attraction.name(), this.overlap, this.overlap > AtomPair.this.maxOverlap ? " >" : "<=", AtomPair.this.maxOverlap, this.contact == Contact.NoContact ? "" : " " + this.contact.name());
            }
        }
    }
}

