/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.sofea;

import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.TupleMatrixGeneric;
import edu.duke.cs.osprey.confspace.TupleTree;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.tools.BigExp;
import java.math.MathContext;
import java.math.RoundingMode;

public class ZMatrix
extends TupleMatrixGeneric<BigExp> {
    private final BoltzmannCalculator bcalc = new BoltzmannCalculator(new MathContext(16, RoundingMode.HALF_UP));

    public ZMatrix(ConfSpaceIteration confSpace) {
        super(confSpace);
    }

    private BigExp calc(double energy) {
        return new BigExp(this.bcalc.calcPrecise(energy));
    }

    public void set(EnergyMatrix emat) {
        int rc2;
        int m2;
        int pos2;
        int rc1;
        int m1;
        int pos1;
        int n = this.getNumPos();
        for (pos1 = 0; pos1 < n; ++pos1) {
            m1 = this.getNumConfAtPos(pos1);
            for (rc1 = 0; rc1 < m1; ++rc1) {
                this.setOneBody(pos1, rc1, this.calc(emat.getOneBody(pos1, rc1)));
                for (pos2 = 0; pos2 < pos1; ++pos2) {
                    m2 = this.getNumConfAtPos(pos2);
                    for (rc2 = 0; rc2 < m2; ++rc2) {
                        this.setPairwise(pos1, rc1, pos2, rc2, this.calc(emat.getPairwise(pos1, rc1, pos2, rc2)));
                    }
                }
            }
        }
        if (emat.hasHigherOrderTuples()) {
            for (pos1 = 0; pos1 < n; ++pos1) {
                m1 = this.getNumConfAtPos(pos1);
                for (rc1 = 0; rc1 < m1; ++rc1) {
                    for (pos2 = 0; pos2 < pos1; ++pos2) {
                        m2 = this.getNumConfAtPos(pos2);
                        for (rc2 = 0; rc2 < m2; ++rc2) {
                            TupleTree tuples = emat.getHigherOrderTuples(pos1, rc1, pos2, rc2);
                            if (tuples == null) continue;
                            for (RCTuple tuple : tuples.makeTuplesList()) {
                                this.setTuple(tuple, this.calc((Double)tuples.get(tuple)));
                            }
                        }
                    }
                }
            }
        }
    }
}

