/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.sofea;

import edu.duke.cs.osprey.tools.MathTools;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public interface BigDecimalIO {
    public void write(DataOutput var1, BigDecimal var2) throws IOException;

    public BigDecimal read(DataInput var1) throws IOException;

    public static class Fixed
    implements BigDecimalIO {
        public final int numBytes;
        private final int unscaledValBytes;
        private final int noncodeBytes;
        private static final int otherBytes = 5;

        public Fixed(int numBytes) {
            this.numBytes = numBytes;
            this.unscaledValBytes = numBytes - 5;
            this.noncodeBytes = numBytes - 1;
        }

        public Fixed(MathContext mathContext) {
            this(Fixed.calcUnscaledValBytes(mathContext.getPrecision()) + 5);
        }

        private static int calcUnscaledValBytes(int precision) {
            MathContext mc = new MathContext(precision, RoundingMode.HALF_UP);
            BigDecimal d = new BigDecimal("7.0");
            int size = 0;
            int numSame = 0;
            while (numSame < 10) {
                int newsize = (d = d.multiply(d, mc)).unscaledValue().toByteArray().length;
                if (newsize > size) {
                    size = newsize;
                    numSame = 0;
                    continue;
                }
                ++numSame;
            }
            return size;
        }

        private void writePad(DataOutput out, int size) throws IOException {
            for (int i = 0; i < size; ++i) {
                out.writeByte(0);
            }
        }

        @Override
        public void write(DataOutput out, BigDecimal d) throws IOException {
            Type type = Type.get(d);
            out.writeByte(type.code);
            if (type == Type.Val) {
                byte[] bytes = d.unscaledValue().toByteArray();
                assert (bytes.length <= this.unscaledValBytes);
                this.writePad(out, this.unscaledValBytes - bytes.length);
                out.write(bytes);
                out.writeInt(d.scale());
            } else {
                this.writePad(out, this.noncodeBytes);
            }
        }

        private void readPad(DataInput in, int size) throws IOException {
            for (int i = 0; i < size; ++i) {
                in.readByte();
            }
        }

        @Override
        public BigDecimal read(DataInput in) throws IOException {
            Type type = Type.get(in.readByte());
            if (type == Type.Val) {
                byte[] bytes = new byte[this.unscaledValBytes];
                in.readFully(bytes);
                return new BigDecimal(new BigInteger(bytes), in.readInt());
            }
            this.readPad(in, this.noncodeBytes);
            return type.value;
        }
    }

    public static class Variable
    implements BigDecimalIO {
        @Override
        public void write(DataOutput out, BigDecimal d) throws IOException {
            Type type = Type.get(d);
            out.writeByte(type.code);
            if (type == Type.Val) {
                byte[] bytes = d.unscaledValue().toByteArray();
                out.writeInt(bytes.length);
                out.write(bytes);
                out.writeInt(d.scale());
            }
        }

        @Override
        public BigDecimal read(DataInput in) throws IOException {
            Type type = Type.get(in.readByte());
            if (type == Type.Val) {
                byte[] bytes = new byte[in.readInt()];
                in.readFully(bytes);
                return new BigDecimal(new BigInteger(bytes), in.readInt());
            }
            return type.value;
        }
    }

    public static enum Type {
        Null(null),
        NaN(MathTools.BigNaN),
        NegInf(MathTools.BigNegativeInfinity),
        PosInf(MathTools.BigPositiveInfinity),
        Zero(BigDecimal.ZERO),
        One(BigDecimal.ONE),
        Val(null);

        private final byte code = (byte)this.ordinal();
        private final BigDecimal value;

        private Type(BigDecimal value2) {
            this.value = value2;
        }

        public static Type get(BigDecimal d) {
            if (d == null) {
                return Null;
            }
            if (d == MathTools.BigNaN) {
                return NaN;
            }
            if (d == MathTools.BigNegativeInfinity) {
                return NegInf;
            }
            if (d == MathTools.BigPositiveInfinity) {
                return PosInf;
            }
            if (d == BigDecimal.ZERO) {
                return Zero;
            }
            if (d == BigDecimal.ONE) {
                return One;
            }
            return Val;
        }

        public static Type get(byte code) {
            return Type.values()[code];
        }
    }
}

