/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.restypes;

import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.io.Serializable;
import java.util.List;

public abstract class InterResBondingTemplate
implements Serializable {
    public abstract void connectInterResBonds(Residue var1, boolean var2);

    public abstract boolean atomCanBondOtherRes(Atom var1);

    public abstract boolean isInterResBondedForward(Residue var1, Residue var2);

    public static void tryToMakePeptideBond(Residue res1, Residue res2) {
        int NIndex;
        int CIndex;
        double CNDist;
        if (HardCodedResidueInfo.hasAminoAcidBB(res1) && HardCodedResidueInfo.hasAminoAcidBB(res2) && (CNDist = VectorAlgebra.distance(res1.coords, CIndex = res1.getAtomIndexByName("C"), res2.coords, NIndex = res2.getAtomIndexByName("N"))) < HardCodedResidueInfo.bondLengthUpperBound(6, 7)) {
            Atom C = res1.atoms.get(CIndex);
            Atom N = res2.atoms.get(NIndex);
            C.addBond(N);
        }
    }

    public static void tryToMakeNucleotideBond(Residue res1, Residue res2) {
        int Oi = res1.getAtomIndexByName("O3'");
        if (Oi < 0) {
            return;
        }
        int Pi = res2.getAtomIndexByName("P");
        if (Pi < 0) {
            return;
        }
        Atom O = res1.atoms.get(Oi);
        Atom P = res2.atoms.get(Pi);
        double dist = VectorAlgebra.distance(res1.coords, Oi, res2.coords, Pi);
        if (dist < HardCodedResidueInfo.bondLengthUpperBound(O.elementNumber, P.elementNumber)) {
            O.addBond(P);
        }
    }

    public static void tryToMakeDisulfideBond(Residue res1, Residue res2) {
        if (res1.template == null || res2.template == null) {
            throw new RuntimeException("ERROR: Trying to disulfide-bond residue without template");
        }
        int SIndex1 = res1.getAtomIndexByName("SG");
        int SIndex2 = res2.getAtomIndexByName("SG");
        if (SIndex1 == -1 || SIndex2 == -1) {
            throw new RuntimeException("ERROR: Trying to disulfide-bond residue without SG");
        }
        double SSDist = VectorAlgebra.distance(res1.coords, SIndex1, res2.coords, SIndex2);
        if (SSDist < HardCodedResidueInfo.bondLengthUpperBound(16, 16)) {
            Atom S1 = res1.atoms.get(SIndex1);
            Atom S2 = res2.atoms.get(SIndex2);
            S1.addBond(S2);
        }
    }

    public static class SpecifiedBondingAtomsTemplate
    extends InterResBondingTemplate {
        List<String> bondingAtomNames;
        private static String notSupportedMsg = "atom connectivity queries for generic inter-residue bonds are not supported. Generic inter-residue bonds do not define a \"forward\" direction";

        public SpecifiedBondingAtomsTemplate(List<String> bondingAtNames) {
            this.bondingAtomNames = bondingAtNames;
        }

        @Override
        public void connectInterResBonds(Residue res, boolean lowerNumResOnly) {
            for (Residue res2 : res.molec.residues) {
                if (res2 == res || res2.indexInMolecule >= res.indexInMolecule && lowerNumResOnly) continue;
                for (int atnum2 = 0; atnum2 < res2.atoms.size(); ++atnum2) {
                    Atom at2 = res2.atoms.get(atnum2);
                    if (!res2.template.interResBonding.atomCanBondOtherRes(at2)) continue;
                    for (Atom at : res.atoms) {
                        double dist;
                        if (!this.atomCanBondOtherRes(at) || !((dist = VectorAlgebra.distance(res.coords, at.indexInRes, res2.coords, atnum2)) < HardCodedResidueInfo.bondLengthUpperBound(at.elementNumber, at2.elementNumber))) continue;
                        at.addBond(res2.atoms.get(atnum2));
                    }
                }
            }
        }

        @Override
        public boolean atomCanBondOtherRes(Atom atom) {
            return this.bondingAtomNames.contains(atom.name);
        }

        public List<String> getBondingAtomNames() {
            return this.bondingAtomNames;
        }

        @Override
        public boolean isInterResBondedForward(Residue res1, Residue res2) {
            throw new UnsupportedOperationException(notSupportedMsg);
        }
    }

    public static class CysteineBondingTemplate
    extends PeptideBondingTemplate {
        @Override
        public void connectInterResBonds(Residue res, boolean lowerNumResOnly) {
            super.connectInterResBonds(res, lowerNumResOnly);
            for (Residue res2 : res.molec.residues) {
                if (res2 == res || res2.indexInMolecule >= res.indexInMolecule && lowerNumResOnly || !(res2.template.interResBonding instanceof CysteineBondingTemplate)) continue;
                CysteineBondingTemplate.tryToMakeDisulfideBond(res, res2);
            }
        }

        @Override
        public boolean atomCanBondOtherRes(Atom atom) {
            return atom.name.equalsIgnoreCase("N") || atom.name.equalsIgnoreCase("C") || atom.name.equalsIgnoreCase("SG");
        }
    }

    public static class NucleotideBondingTemplate
    extends InterResBondingTemplate {
        @Override
        public void connectInterResBonds(Residue res, boolean lowerNumResOnly) {
            if (res.indexInMolecule > 0) {
                Residue prevRes = (Residue)res.molec.residues.get(res.indexInMolecule - 1);
                NucleotideBondingTemplate.tryToMakeNucleotideBond(prevRes, res);
            }
            if (res.indexInMolecule < res.molec.residues.size() - 1 && !lowerNumResOnly) {
                Residue nextRes = (Residue)res.molec.residues.get(res.indexInMolecule + 1);
                NucleotideBondingTemplate.tryToMakeNucleotideBond(res, nextRes);
            }
        }

        @Override
        public boolean atomCanBondOtherRes(Atom atom) {
            return atom.name.equalsIgnoreCase("P") || atom.name.equalsIgnoreCase("O3'");
        }

        @Override
        public boolean isInterResBondedForward(Residue res1, Residue res2) {
            Atom O = res1.getAtomByName("O3'");
            Atom P = res2.getAtomByName("P");
            if (O == null || P == null) {
                return false;
            }
            return O.bonds.contains(P);
        }
    }

    public static class PeptideBondingTemplate
    extends InterResBondingTemplate {
        @Override
        public void connectInterResBonds(Residue res, boolean lowerNumResOnly) {
            if (res.indexInMolecule > 0) {
                Residue prevRes = (Residue)res.molec.residues.get(res.indexInMolecule - 1);
                PeptideBondingTemplate.tryToMakePeptideBond(prevRes, res);
            }
            if (res.indexInMolecule < res.molec.residues.size() - 1 && !lowerNumResOnly) {
                Residue nextRes = (Residue)res.molec.residues.get(res.indexInMolecule + 1);
                PeptideBondingTemplate.tryToMakePeptideBond(res, nextRes);
            }
        }

        @Override
        public boolean atomCanBondOtherRes(Atom atom) {
            return atom.name.equalsIgnoreCase("N") || atom.name.equalsIgnoreCase("C");
        }

        @Override
        public boolean isInterResBondedForward(Residue res1, Residue res2) {
            Atom C = res1.getAtomByName("C");
            Atom N = res2.getAtomByName("N");
            if (C == null || N == null) {
                return false;
            }
            return C.bonds.contains(N);
        }
    }

    public static class NoBondingTemplate
    extends InterResBondingTemplate {
        @Override
        public void connectInterResBonds(Residue res, boolean lowerNumResOnly) {
        }

        @Override
        public boolean atomCanBondOtherRes(Atom atom) {
            return false;
        }

        @Override
        public boolean isInterResBondedForward(Residue res1, Residue res2) {
            return false;
        }
    }
}

