/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.pruning;

import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.Progress;
import java.util.concurrent.atomic.AtomicLong;

public class TransitivePruner {
    public final SimpleConfSpace confSpace;

    public TransitivePruner(SimpleConfSpace confSpace) {
        this.confSpace = confSpace;
    }

    public void pruneSingles(PruningMatrix pmat, TaskExecutor tasks) {
        AtomicLong numSingles = new AtomicLong(0L);
        pmat.forEachUnprunedSingle((pos1, rc1) -> {
            numSingles.incrementAndGet();
            return PruningMatrix.IteratorCommand.Continue;
        });
        Progress progress2 = new Progress(numSingles.get());
        pmat.forEachUnprunedSingle((pos1, rc1) -> {
            tasks.submit(() -> this.isPrunedTransitively(pmat, pos1, rc1), isPruned -> {
                if (isPruned.booleanValue()) {
                    pmat.pruneSingle(pos1, rc1);
                }
                progress2.incrementProgress();
            });
            return PruningMatrix.IteratorCommand.Continue;
        });
    }

    private boolean isPrunedTransitively(PruningMatrix pmat, int pos1, int rc1) {
        for (int pos2 = 0; pos2 < pmat.getNumPos(); ++pos2) {
            if (pos2 == pos1) continue;
            if (!this.isPos2Assignable(pmat, pos1, rc1, pos2)) {
                return true;
            }
            for (int pos3 = 0; pos3 < pos2; ++pos3) {
                if (pos3 == pos1 || this.arePos23Assignable(pmat, pos1, rc1, pos2, pos3)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPos2Assignable(PruningMatrix pmat, int pos1, int rc1, int pos2) {
        for (int rc2 = 0; rc2 < pmat.getNumConfAtPos(pos2); ++rc2) {
            if (pmat.isPairPruned(pos1, rc1, pos2, rc2)) continue;
            return true;
        }
        return false;
    }

    private boolean arePos23Assignable(PruningMatrix pmat, int pos1, int rc1, int pos2, int pos3) {
        for (int rc2 = 0; rc2 < pmat.getNumConfAtPos(pos2); ++rc2) {
            for (int rc3 = 0; rc3 < pmat.getNumConfAtPos(pos3); ++rc3) {
                if (pmat.isTriplePruned(pos1, rc1, pos2, rc2, pos3, rc3)) continue;
                return true;
            }
        }
        return false;
    }

    public void prunePairs(PruningMatrix pmat, TaskExecutor tasks) {
        AtomicLong numPairs = new AtomicLong(0L);
        pmat.forEachUnprunedPair((pos1, rc1, pos2, rc2) -> {
            numPairs.incrementAndGet();
            return PruningMatrix.IteratorCommand.Continue;
        });
        Progress progress2 = new Progress(numPairs.get());
        pmat.forEachUnprunedPair((pos1, rc1, pos2, rc2) -> {
            tasks.submit(() -> this.isPrunedTransitively(pmat, pos1, rc1, pos2, rc2), isPruned -> {
                if (isPruned.booleanValue()) {
                    pmat.prunePair(pos1, rc1, pos2, rc2);
                }
                progress2.incrementProgress();
            });
            return PruningMatrix.IteratorCommand.Continue;
        });
    }

    private boolean isPrunedTransitively(PruningMatrix pmat, int pos1, int rc1, int pos2, int rc2) {
        for (int pos3 = 0; pos3 < pmat.getNumPos(); ++pos3) {
            if (pos3 == pos1 || pos3 == pos2) continue;
            if (!this.isPos3Assignable(pmat, pos1, rc1, pos2, rc2, pos3)) {
                return true;
            }
            for (int pos4 = 0; pos4 < pos3; ++pos4) {
                if (pos4 == pos1 || pos4 == pos2 || this.arePos34Assignable(pmat, pos1, rc1, pos2, rc2, pos3, pos4)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPos3Assignable(PruningMatrix pmat, int pos1, int rc1, int pos2, int rc2, int pos3) {
        for (int rc3 = 0; rc3 < pmat.getNumConfAtPos(pos3); ++rc3) {
            if (pmat.isTriplePruned(pos1, rc1, pos2, rc2, pos3, rc3)) continue;
            return true;
        }
        return false;
    }

    private boolean arePos34Assignable(PruningMatrix pmat, int pos1, int rc1, int pos2, int rc2, int pos3, int pos4) {
        for (int rc3 = 0; rc3 < pmat.getNumConfAtPos(pos3); ++rc3) {
            for (int rc4 = 0; rc4 < pmat.getNumConfAtPos(pos4); ++rc4) {
                if (pmat.isQuadruplePruned(pos1, rc1, pos2, rc2, pos3, rc3, pos4, rc4)) continue;
                return true;
            }
        }
        return false;
    }

    public void pruneTriples(PruningMatrix pmat, TaskExecutor tasks) {
        AtomicLong numTriples = new AtomicLong(0L);
        pmat.forEachUnprunedTriple((pos1, rc1, pos2, rc2, pos3, rc3) -> {
            numTriples.incrementAndGet();
            return PruningMatrix.IteratorCommand.Continue;
        });
        Progress progress2 = new Progress(numTriples.get());
        pmat.forEachUnprunedTriple((pos1, rc1, pos2, rc2, pos3, rc3) -> {
            tasks.submit(() -> this.isPrunedTransitively(pmat, pos1, rc1, pos2, rc2, pos3, rc3), isPruned -> {
                if (isPruned.booleanValue()) {
                    pmat.pruneTriple(pos1, rc1, pos2, rc2, pos3, rc3);
                }
                progress2.incrementProgress();
            });
            return PruningMatrix.IteratorCommand.Continue;
        });
    }

    private boolean isPrunedTransitively(PruningMatrix pmat, int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
        for (int pos4 = 0; pos4 < pmat.getNumPos(); ++pos4) {
            if (pos4 == pos1 || pos4 == pos2 || pos4 == pos3) continue;
            if (!this.isPos4Assignable(pmat, pos1, rc1, pos2, rc2, pos3, rc3, pos4)) {
                return true;
            }
            for (int pos5 = 0; pos5 < pos4; ++pos5) {
                if (pos5 == pos1 || pos5 == pos2 || pos5 == pos3 || this.arePos45Assignable(pmat, pos1, rc1, pos2, rc2, pos3, rc3, pos4, pos5)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPos4Assignable(PruningMatrix pmat, int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, int pos4) {
        for (int rc4 = 0; rc4 < pmat.getNumConfAtPos(pos4); ++rc4) {
            if (pmat.isQuadruplePruned(pos1, rc1, pos2, rc2, pos3, rc3, pos4, rc4)) continue;
            return true;
        }
        return false;
    }

    private boolean arePos45Assignable(PruningMatrix pmat, int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, int pos4, int pos5) {
        for (int rc4 = 0; rc4 < pmat.getNumConfAtPos(pos4); ++rc4) {
            for (int rc5 = 0; rc5 < pmat.getNumConfAtPos(pos5); ++rc5) {
                if (pmat.isQuintuplePruned(pos1, rc1, pos2, rc2, pos3, rc3, pos4, rc4, pos5, rc5)) continue;
                return true;
            }
        }
        return false;
    }
}

