/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.pruning;

public class PruningMethod {
    boolean useCompetitor;
    int numPos;
    CheckSumType cst;

    public PruningMethod(boolean useCompetitor, int numPos, CheckSumType cst) {
        this.useCompetitor = useCompetitor;
        this.numPos = numPos;
        this.cst = cst;
    }

    public static PruningMethod getMethod(String name) {
        if (name.equalsIgnoreCase("GOLDSTEIN")) {
            return new PruningMethod(true, 1, CheckSumType.GOLDSTEIN);
        }
        if (name.equalsIgnoreCase("GOLDSTEIN PAIRS")) {
            return new PruningMethod(true, 2, CheckSumType.GOLDSTEIN);
        }
        if (name.equalsIgnoreCase("GOLDSTEIN PAIRS FULL")) {
            return new PruningMethod(true, 2, CheckSumType.GOLDSTEIN);
        }
        if (name.equalsIgnoreCase("GOLDSTEIN TRIPLES")) {
            return new PruningMethod(true, 3, CheckSumType.GOLDSTEIN);
        }
        if (name.equalsIgnoreCase("INDIRECT")) {
            return new PruningMethod(true, 1, CheckSumType.INDIRECT);
        }
        if (name.equalsIgnoreCase("INDIRECT PAIRS")) {
            return new PruningMethod(true, 2, CheckSumType.INDIRECT);
        }
        if (name.equalsIgnoreCase("SPLIT1")) {
            return new PruningMethod(true, 1, CheckSumType.CONFSPLIT1);
        }
        if (name.equalsIgnoreCase("SPLIT2")) {
            return new PruningMethod(true, 1, CheckSumType.CONFSPLIT2);
        }
        if (name.equalsIgnoreCase("BOUNDS")) {
            return new PruningMethod(false, 1, CheckSumType.BOUNDS);
        }
        if (name.equalsIgnoreCase("BOUNDING FLAGS")) {
            return new PruningMethod(false, 2, CheckSumType.BOUNDS);
        }
        throw new RuntimeException("ERROR: Unrecognized pruning method: " + name);
    }

    String name() {
        return this.cst.name() + " FOR " + this.numPos + " POSITION(S)";
    }

    static enum CheckSumType {
        GOLDSTEIN,
        INDIRECT,
        CONFSPLIT1,
        CONFSPLIT2,
        BOUNDS;

    }
}

