/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.partcr;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.gmec.GMECConfEnergyCalculator;
import edu.duke.cs.osprey.gmec.GMECFinder;
import edu.duke.cs.osprey.partcr.PartCR;
import edu.duke.cs.osprey.partcr.pickers.WalkingConfPicker;
import edu.duke.cs.osprey.partcr.scorers.VolumeRCScorer;
import edu.duke.cs.osprey.partcr.splitters.NAryRCSplitter;
import java.util.List;

public class PartCRConfPruner
implements GMECFinder.ConfPruner {
    private SearchProblem search;
    private double Ew;

    public PartCRConfPruner(SearchProblem search2, double Ew) {
        this.search = search2;
        this.Ew = Ew;
    }

    @Override
    public void prune(List<ConfSearch.ScoredConf> confs, GMECConfEnergyCalculator confEcalc) {
        if (confs.isEmpty()) {
            return;
        }
        System.out.println("\nChecking to see if it's ok to use PartCR with this config...");
        double expectedMinimizedEnergy = confEcalc.calcEnergy(confs.get(0)).getEnergy();
        double partcrMinimizedEnergy = this.search.minimizedEnergy(confs.get(0).getAssignments());
        double absErr = Math.abs(expectedMinimizedEnergy - partcrMinimizedEnergy);
        if (absErr > 1.0E-6) {
            throw new Error("This PartCR implmentation is not compatible with the current Osprey config!\nNeed to refactor energy calculation to make it work.\n\nOr the minimizer is just non-deterministic. The abs error is: " + absErr);
        }
        System.out.println("Yup, we're good. Full speed ahead, captain!");
        WalkingConfPicker picker = new WalkingConfPicker();
        VolumeRCScorer scorer = new VolumeRCScorer();
        NAryRCSplitter splitter = new NAryRCSplitter();
        PartCR pcr = new PartCR(this.search, EnvironmentVars.curEFcnGenerator.ffParams, this.Ew, confs);
        pcr.setPicker(picker);
        pcr.setScorer(scorer);
        pcr.setSplitter(splitter);
        int numStrikes = 3;
        pcr.autoIterate(numStrikes);
    }
}

