/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import edu.duke.cs.osprey.parallelism.PulseSignal;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class Generator<T>
implements Iterable<T>,
AutoCloseable {
    private final Thread genThread;
    private final Iterator<T> iter;
    private final PulseSignal iterSignal = new PulseSignal();
    private final SynchronousQueue<T> queue = new SynchronousQueue();
    private final AtomicBoolean isActive = new AtomicBoolean(true);
    private final T end = new Object();

    public Generator(Consumer<Yielder<T>> func) {
        this.genThread = new Thread(() -> {
            while (this.iterSignal.waitForSignal(1L, TimeUnit.SECONDS) == PulseSignal.Result.TimedOut) {
                if (this.isActive.get()) continue;
                return;
            }
            Yielder yielder = new Yielder<T>(){

                @Override
                public void yield(T value2) {
                    try {
                        while (!Generator.this.queue.offer(value2, 1L, TimeUnit.SECONDS)) {
                            if (Generator.this.isActive.get()) continue;
                            throw new AbortGeneratorException();
                        }
                        while (Generator.this.iterSignal.waitForSignal(1L, TimeUnit.SECONDS) == PulseSignal.Result.TimedOut) {
                            if (Generator.this.isActive.get()) continue;
                            return;
                        }
                    }
                    catch (InterruptedException ex) {
                        throw new Error(ex);
                    }
                }
            };
            try {
                func.accept(yielder);
                while (!this.queue.offer(this.end, 1L, TimeUnit.SECONDS)) {
                    if (this.isActive.get()) continue;
                    throw new AbortGeneratorException();
                }
            }
            catch (AbortGeneratorException abortGeneratorException) {
            }
            catch (InterruptedException ex) {
                throw new Error(ex);
            }
        });
        this.genThread.setName("Generator Thread");
        this.genThread.setDaemon(true);
        this.genThread.start();
        this.iter = new Iterator<T>(){
            private T nextValue = this.get();

            T get() {
                Generator.this.iterSignal.signal();
                try {
                    do {
                        Object value2;
                        if ((value2 = Generator.this.queue.poll(1L, TimeUnit.SECONDS)) == null) continue;
                        if (value2 == Generator.this.end) {
                            return null;
                        }
                        return value2;
                    } while (Generator.this.genThread.isAlive());
                    throw new GeneratorFailedException("Generator thread failed, no value can be iterated");
                }
                catch (InterruptedException ex) {
                    throw new Error(ex);
                }
            }

            @Override
            public synchronized boolean hasNext() {
                return this.nextValue != null;
            }

            @Override
            public synchronized T next() {
                Object value2 = this.nextValue;
                if (value2 == null) {
                    throw new NoSuchElementException();
                }
                this.nextValue = this.get();
                return value2;
            }
        };
    }

    @Override
    public void close() {
        this.isActive.set(false);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iter;
    }

    private static class AbortGeneratorException
    extends RuntimeException {
        private AbortGeneratorException() {
        }
    }

    public static class GeneratorFailedException
    extends RuntimeException {
        public GeneratorFailedException(String msg) {
            super(msg);
        }
    }

    public static interface Yielder<T> {
        public void yield(T var1);
    }
}

