/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

public class CounterSignal {
    private int count;
    private SignalCondition condition;

    public CounterSignal(int initialCount, SignalCondition condition) {
        this.count = initialCount;
        this.condition = condition;
    }

    public synchronized void waitForSignal() {
        this.waitForSignal(0L);
    }

    public synchronized void waitForSignal(long timeoutMs) {
        if (!this.condition.shouldSignal(this.count)) {
            try {
                this.wait(timeoutMs);
            }
            catch (InterruptedException ex) {
                throw new Error(ex);
            }
        }
    }

    public synchronized void offset(int delta) {
        this.count += delta;
        if (this.condition.shouldSignal(this.count)) {
            this.notifyAll();
        }
    }

    public static interface SignalCondition {
        public boolean shouldSignal(int var1);
    }
}

