/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class BottleneckThread
implements AutoCloseable {
    public final String name;
    private final SynchronousQueue<Runnable> queue;
    private final Thread thread;
    private volatile boolean isRunning;

    public BottleneckThread(String name) {
        this.name = name;
        this.isRunning = true;
        this.queue = new SynchronousQueue();
        this.thread = new Thread(() -> this.threadLoop());
        this.thread.setName(name);
        this.thread.setDaemon(false);
        this.thread.start();
    }

    @Override
    public void close() {
        this.isRunning = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void threadLoop() {
        try {
            while (this.isRunning) {
                Runnable task = this.queue.poll(500L, TimeUnit.MILLISECONDS);
                if (task == null) continue;
                task.run();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void launch(Runnable task) {
        if (Thread.currentThread() == this.thread) {
            throw new IllegalArgumentException("can't launch new tasks from the bottleneck thread itself!");
        }
        try {
            boolean wasAdded;
            do {
                if (this.isRunning) continue;
                throw new IllegalStateException("BottleneckThread is not running");
            } while (!(wasAdded = this.queue.offer(task, 500L, TimeUnit.MILLISECONDS)));
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void exec(Runnable task) {
        CountDownLatch latch = new CountDownLatch(1);
        this.launch(() -> {
            try {
                task.run();
            }
            finally {
                latch.countDown();
            }
        });
        try {
            boolean finished;
            while (!(finished = latch.await(500L, TimeUnit.MILLISECONDS))) {
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> T get(Supplier<T> task) {
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        this.exec(() -> ref.set(task.get()));
        return ref.get();
    }
}

