/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.multistatekstar.KStarScoreMinimized;
import edu.duke.cs.osprey.multistatekstar.MSKStarSettings;
import edu.duke.cs.osprey.multistatekstar.MSSearchProblem;
import edu.duke.cs.osprey.multistatekstar.PartitionFunctionDiscrete;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.math.BigDecimal;

public class KStarScoreDiscrete
extends KStarScoreMinimized {
    public KStarScoreDiscrete(MSKStarSettings settings) {
        super(settings);
    }

    @Override
    public BigDecimal getLowerBoundScore() {
        return this.getScore();
    }

    @Override
    public BigDecimal getUpperBoundScore() {
        return this.getScore();
    }

    @Override
    protected void compute(int state, int maxNumConfs) {
        super.compute(state, maxNumConfs);
        if (!this.settings.search[state].isFullyAssigned()) {
            PartitionFunctionDiscrete pf = (PartitionFunctionDiscrete)this.partitionFunctions[state];
            pf.getValues().qstar = pf.getValues().qstar.multiply(this.numUndefinedConfs(state));
        }
    }

    private BigDecimal numUndefinedConfs(int state) {
        BigDecimal ans = BigDecimal.ONE;
        MSSearchProblem search2 = this.settings.search[state];
        boolean minConfs = !search2.settings.energyLBs;
        PruningMatrix pmat = search2.pruneMat;
        for (int pos : search2.getPosNums(false)) {
            long unPrunedConfs = minConfs ? Long.MAX_VALUE : Long.MIN_VALUE;
            long prunedConfs = minConfs ? Long.MAX_VALUE : Long.MIN_VALUE;
            for (String AAType : search2.settings.AATypeOptions.get(pos)) {
                long numAARCs = search2.unprunedAtPos(pmat, pos, AAType).size();
                long l = unPrunedConfs = minConfs ? Math.min(unPrunedConfs, numAARCs) : Math.max(unPrunedConfs, numAARCs);
                if (minConfs) continue;
                numAARCs = search2.unprunedAtPos(this.partitionFunctions[state].invmat, pos, AAType).size();
                prunedConfs = Math.max(prunedConfs, numAARCs);
            }
            if (minConfs) {
                prunedConfs = 0L;
            }
            ans = ans.multiply(BigDecimal.valueOf(unPrunedConfs + prunedConfs));
        }
        return ans;
    }
}

