/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.molscope.view;

import cuchaz.kludge.tools.LangKt;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.view.MoleculeRenderInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00030\fj\b\u0012\u0004\u0012\u00020\u0003`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Ledu/duke/cs/osprey/molscope/view/MoleculeRenderStack;", "", "originalMol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "info", "Ledu/duke/cs/osprey/molscope/view/MoleculeRenderInfo;", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/molscope/view/MoleculeRenderInfo;)V", "getInfo", "()Ledu/duke/cs/osprey/molscope/view/MoleculeRenderInfo;", "getOriginalMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "overrideMols", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "size", "", "getSize", "()I", "push", "Ledu/duke/cs/osprey/molscope/view/MoleculeRenderStack$StackedMol;", "mol", "StackedMol", "osprey3"})
public final class MoleculeRenderStack {
    @NotNull
    private final Molecule originalMol;
    @NotNull
    private final MoleculeRenderInfo info;
    @NotNull
    private final ArrayList<Molecule> overrideMols;

    public MoleculeRenderStack(@NotNull Molecule originalMol, @NotNull MoleculeRenderInfo info2) {
        Intrinsics.checkNotNullParameter((Object)originalMol, (String)"originalMol");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        this.originalMol = originalMol;
        this.info = info2;
        this.overrideMols = new ArrayList();
    }

    @NotNull
    public final Molecule getOriginalMol() {
        return this.originalMol;
    }

    @NotNull
    public final MoleculeRenderInfo getInfo() {
        return this.info;
    }

    @NotNull
    public final StackedMol push(@NotNull Molecule mol) {
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        this.overrideMols.add(mol);
        this.info.setMol(mol);
        return new StackedMol(mol);
    }

    public final int getSize() {
        return this.overrideMols.size();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ledu/duke/cs/osprey/molscope/view/MoleculeRenderStack$StackedMol;", "", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "(Ledu/duke/cs/osprey/molscope/view/MoleculeRenderStack;Ledu/duke/cs/osprey/molscope/molecule/Molecule;)V", "<set-?>", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "pop", "", "replace", "osprey3"})
    public final class StackedMol {
        @NotNull
        private Molecule mol;

        public StackedMol(Molecule mol) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            this.mol = mol;
        }

        @NotNull
        public final Molecule getMol() {
            return this.mol;
        }

        public final void replace(@NotNull Molecule mol) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Integer n = LangKt.indexOfOrNull((List)MoleculeRenderStack.this.overrideMols, (Object)this.mol);
            if (n == null) {
                throw new NoSuchElementException("molecule was already popped from the stack");
            }
            int i = n;
            MoleculeRenderStack.this.overrideMols.set(i, mol);
            this.mol = mol;
            MoleculeRenderStack.this.getInfo().setMol(mol);
        }

        public final void pop() {
            MoleculeRenderStack.this.overrideMols.remove(this.mol);
            MoleculeRenderInfo moleculeRenderInfo = MoleculeRenderStack.this.getInfo();
            Molecule molecule = (Molecule)CollectionsKt.lastOrNull((List)MoleculeRenderStack.this.overrideMols);
            if (molecule == null) {
                molecule = MoleculeRenderStack.this.getOriginalMol();
            }
            moleculeRenderInfo.setMol(molecule);
        }
    }
}

