/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import edu.duke.cs.osprey.minimization.LineSearcher;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;

public class IntervalLineSearcher
implements LineSearcher {
    private static final double Tau = (Math.sqrt(5.0) + 1.0) / 2.0;
    private static final double MinIntervalWidth = 0.001;
    private ObjectiveFunction.OneDof f;

    @Override
    public void init(ObjectiveFunction.OneDof f) {
        this.f = f;
    }

    @Override
    public double search(double xd) {
        double a = this.f.getXMin();
        double b = this.f.getXMax();
        while (Math.abs(a - b) > 0.001) {
            double fd;
            double step = (b - a) / Tau;
            double c = b - step;
            double d = a + step;
            double fc = this.f.getValue(d);
            if (fc < (fd = this.f.getValue(d))) {
                b = d;
                continue;
            }
            a = c;
        }
        double x = (a + b) / 2.0;
        this.f.setX(x);
        return x;
    }
}

