/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.FreeDihedral;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.forcefield.BigForcefieldEnergy;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldInteractions;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.energy.forcefield.GpuForcefieldEnergy;
import edu.duke.cs.osprey.gpu.BufferTools;
import edu.duke.cs.osprey.gpu.cuda.GpuStreamPool;
import edu.duke.cs.osprey.gpu.cuda.Gpus;
import edu.duke.cs.osprey.gpu.opencl.GpuQueuePool;
import edu.duke.cs.osprey.minimization.ConfMinimizer;
import edu.duke.cs.osprey.minimization.CudaCCDMinimizer;
import edu.duke.cs.osprey.minimization.Minimizer;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.minimization.SimpleCCDMinimizer;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.tools.Factory;

public class GpuConfMinimizer
extends ConfMinimizer {
    private Type.Context context;

    private static boolean hasAllDihedralDofs(ConfSpace confSpace) {
        for (int pos = 0; pos < confSpace.numPos; ++pos) {
            for (RC rc : confSpace.posFlex.get((int)pos).RCs) {
                for (DegreeOfFreedom dof : rc.DOFs) {
                    if (dof instanceof FreeDihedral) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public GpuConfMinimizer(Type type, int numGpus, int streamsPerGpu, final ForcefieldParams ffparams, final Factory<ForcefieldInteractions, Molecule> interactions, ConfSpace confSpace) {
        if (type == null) {
            type = Type.pickBestOrThrow(confSpace);
        }
        this.context = type.makeContext(numGpus, streamsPerGpu);
        Factory<EnergyFunction, Molecule> efuncs = new Factory<EnergyFunction, Molecule>(){

            @Override
            public EnergyFunction make(Molecule mol) {
                return GpuConfMinimizer.this.context.makeEfunc(ffparams, (ForcefieldInteractions)interactions.make(mol));
            }
        };
        this.init(this.context.getNumStreams(), (Factory<? extends EnergyFunction, Molecule>)efuncs, this.context.minimizers, confSpace);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.context.cleanup();
    }

    public static enum Type {
        Cuda{

            @Override
            public boolean isSupported() {
                return !Gpus.get().getGpus().isEmpty();
            }

            @Override
            public Context makeContext(final int numGpus, final int streamsPerGpu) {
                return new Context(this){
                    private GpuStreamPool pool;
                    {
                        this.pool = new GpuStreamPool(numGpus, streamsPerGpu);
                        this.minimizers = mof -> new SimpleCCDMinimizer((ObjectiveFunction)mof);
                    }

                    @Override
                    public int getNumStreams() {
                        return this.pool.getNumStreams();
                    }

                    @Override
                    public EnergyFunction makeEfunc(ForcefieldParams ffparams, ForcefieldInteractions interactions) {
                        return new GpuForcefieldEnergy(ffparams, interactions, this.pool);
                    }

                    @Override
                    public void cleanup() {
                        this.pool.cleanup();
                    }
                };
            }
        }
        ,
        CudaCCD{

            @Override
            public boolean isSupported() {
                return Cuda.isSupported();
            }

            @Override
            public Context makeContext(final int numGpus, final int streamsPerGpu) {
                return new Context(this){
                    private GpuStreamPool pool;
                    {
                        this.pool = new GpuStreamPool(numGpus, streamsPerGpu);
                        this.minimizers = mof -> new CudaCCDMinimizer(this.pool, (ObjectiveFunction)mof);
                    }

                    @Override
                    public int getNumStreams() {
                        return this.pool.getNumStreams();
                    }

                    @Override
                    public EnergyFunction makeEfunc(ForcefieldParams ffparams, ForcefieldInteractions interactions) {
                        return new BigForcefieldEnergy(ffparams, interactions, BufferTools.Type.Direct);
                    }

                    @Override
                    public void cleanup() {
                        this.pool.cleanup();
                    }
                };
            }
        }
        ,
        OpenCL{

            @Override
            public boolean isSupported() {
                return !edu.duke.cs.osprey.gpu.opencl.Gpus.get().getGpus().isEmpty();
            }

            @Override
            public Context makeContext(final int numGpus, final int streamsPerGpu) {
                return new Context(this){
                    private GpuQueuePool pool;
                    {
                        this.pool = new GpuQueuePool(numGpus, streamsPerGpu);
                        this.minimizers = mof -> new SimpleCCDMinimizer((ObjectiveFunction)mof);
                    }

                    @Override
                    public int getNumStreams() {
                        return this.pool.getNumQueues();
                    }

                    @Override
                    public EnergyFunction makeEfunc(ForcefieldParams ffparams, ForcefieldInteractions interactions) {
                        return new GpuForcefieldEnergy(ffparams, interactions, this.pool);
                    }

                    @Override
                    public void cleanup() {
                        this.pool.cleanup();
                    }
                };
            }
        };


        public abstract boolean isSupported();

        public abstract Context makeContext(int var1, int var2);

        public static Type pickBest(ConfSpace confSpace) {
            if (Cuda.isSupported()) {
                if (GpuConfMinimizer.hasAllDihedralDofs(confSpace)) {
                    return CudaCCD;
                }
                return Cuda;
            }
            if (OpenCL.isSupported()) {
                return OpenCL;
            }
            return null;
        }

        public static Type pickBestOrThrow(ConfSpace confSpace) {
            Type type = Type.pickBest(confSpace);
            if (type == null) {
                throw new Error("GPU computation is not supported on this machine. Use CPU computation instead.");
            }
            return type;
        }

        private static abstract class Context {
            public Factory<? extends EnergyFunction, Molecule> efuncs = null;
            public Factory<? extends Minimizer, MoleculeModifierAndScorer> minimizers = null;

            public abstract int getNumStreams();

            public abstract EnergyFunction makeEfunc(ForcefieldParams var1, ForcefieldInteractions var2);

            public abstract void cleanup();
        }
    }

    public static class Builder {
        public final ForcefieldParams ffparams;
        public final Factory<ForcefieldInteractions, Molecule> interactions;
        public final ConfSpace confSpace;
        public Type type;
        public int numGpus;
        public int numStreamsPerGpu;

        public Builder(ForcefieldParams ffparams, Factory<ForcefieldInteractions, Molecule> interactions, ConfSpace confSpace) {
            this.ffparams = ffparams;
            this.interactions = interactions;
            this.confSpace = confSpace;
            this.type = null;
            this.numGpus = 1;
            this.numStreamsPerGpu = 1;
        }

        public Builder setGpuInfo(Type type, int numGpus, int numStreamsPerGpu) {
            this.type = type;
            this.numGpus = numGpus;
            this.numStreamsPerGpu = numStreamsPerGpu;
            return this;
        }

        public GpuConfMinimizer build() {
            return new GpuConfMinimizer(this.type, this.numGpus, this.numStreamsPerGpu, this.ffparams, this.interactions, this.confSpace);
        }
    }
}

