/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.markstar.framework;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.order.AStarOrder;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class StaticLowestEntropyOrder
implements AStarOrder {
    public final MathTools.Optimizer optimizer;
    private List<Integer> posOrder;
    private BoltzmannCalculator calculator = new BoltzmannCalculator(PartitionFunction.decimalPrecision);
    private AStarScorer gscorer;
    private AStarScorer hscorer;

    public StaticLowestEntropyOrder() {
        this(MathTools.Optimizer.Maximize);
    }

    public StaticLowestEntropyOrder(MathTools.Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    @Override
    public void setScorers(AStarScorer gscorer, AStarScorer hscorer) {
        this.gscorer = gscorer;
        this.hscorer = hscorer;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public int getNextPos(ConfIndex confIndex, RCs rcs) {
        if (this.posOrder == null) {
            this.posOrder = this.calcPosOrder(confIndex, rcs);
        }
        return this.posOrder.get(confIndex.node.getLevel());
    }

    private List<Integer> calcPosOrder(ConfIndex confIndex, RCs rcs) {
        ArrayList<Integer> undefinedOrder = new ArrayList<Integer>();
        TreeMap<Integer, Double> scores = new TreeMap<Integer, Double>();
        for (int posi = 0; posi < confIndex.numUndefined; ++posi) {
            int pos = confIndex.undefinedPos[posi];
            undefinedOrder.add(pos);
            scores.put(pos, this.scorePos(confIndex, rcs, pos));
        }
        Collections.sort(undefinedOrder, Comparator.comparingDouble(undefinedOrder::get));
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int posi = 0; posi < confIndex.numDefined; ++posi) {
            int pos = confIndex.definedPos[posi];
            order.add(pos);
        }
        order.addAll(undefinedOrder);
        return order;
    }

    private void putResidueInPosition(List<Integer> order, int residueIndex, int orderIndex) {
        this.swapPos(order, residueIndex, order.get(orderIndex));
    }

    private void swapPos(List<Integer> order, int a, int b) {
        int aIndex = order.indexOf(a);
        int bIndex = order.indexOf(b);
        order.set(bIndex, a);
        order.set(aIndex, b);
    }

    double scorePos(ConfIndex confIndex, RCs rcs, int pos) {
        double childScore;
        BigDecimal sum = BigDecimal.ZERO;
        double entropy = 0.0;
        for (int rc : rcs.get(pos)) {
            childScore = this.gscorer.calcDifferential(confIndex, rcs, pos, rc) + this.hscorer.calcDifferential(confIndex, rcs, pos, rc);
            sum = sum.add(this.calculator.calc(childScore));
        }
        if (sum.compareTo(BigDecimal.ZERO) == 0) {
            sum = BigDecimal.ONE;
        }
        for (int rc : rcs.get(pos)) {
            childScore = this.gscorer.calcDifferential(confIndex, rcs, pos, rc) + this.hscorer.calcDifferential(confIndex, rcs, pos, rc);
            BigDecimal childWeightedScore = this.calculator.calc(childScore);
            double p = childWeightedScore.divide(sum, new MathContext(4)).doubleValue();
            double plogp = -p * Math.log(p) / Math.log(2.0);
            entropy += plogp;
        }
        return entropy;
    }
}

