/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.markstar.framework;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.order.AStarOrder;
import edu.duke.cs.osprey.astar.conf.pruning.AStarPruner;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.astar.conf.scoring.MPLPPairwiseHScorer;
import edu.duke.cs.osprey.astar.conf.scoring.PairwiseGScorer;
import edu.duke.cs.osprey.astar.conf.scoring.TraditionalPairwiseHScorer;
import edu.duke.cs.osprey.astar.conf.scoring.mplp.EdgeUpdater;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TupE;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.NegatedEnergyMatrix;
import edu.duke.cs.osprey.ematrix.UpdatingEnergyMatrix;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.ResidueForcefieldBreakdown;
import edu.duke.cs.osprey.gmec.ConfAnalyzer;
import edu.duke.cs.osprey.kstar.BBKStar;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.markstar.MARKStarProgress;
import edu.duke.cs.osprey.markstar.framework.MARKStarNode;
import edu.duke.cs.osprey.markstar.framework.StaticBiggestLowerboundDifferenceOrder;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.ObjectPool;
import edu.duke.cs.osprey.tools.Stopwatch;
import edu.duke.cs.osprey.tools.TimeTools;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;

public class MARKStarBound
implements PartitionFunction.WithConfDB {
    protected double targetEpsilon = 1.0;
    public boolean debug = false;
    public boolean profileOutput = false;
    private PartitionFunction.Status status = null;
    private Values values = null;
    private int numConfsEnergied = 0;
    private int maxNumConfs = -1;
    protected int maxMinimizations = 1;
    private int numConfsScored = 0;
    protected int numInternalNodesProcessed = 0;
    private boolean printMinimizedConfs;
    private MARKStarProgress progress;
    public String stateName = String.format("%4f", Math.random());
    private int numPartialMinimizations;
    private ArrayList<Integer> minList;
    protected double internalTimeAverage;
    protected double leafTimeAverage;
    private double cleanupTime;
    private boolean nonZeroLower;
    protected static TaskExecutor loopTasks;
    private ConfDB confDB;
    private ConfDB.Key confDBKey;
    protected MARKStarNode rootNode;
    protected final Queue<MARKStarNode> queue;
    protected double epsilonBound = Double.POSITIVE_INFINITY;
    private ConfIndex confIndex;
    public final AStarOrder order;
    public final AStarPruner pruner;
    protected RCs RCs;
    protected Parallelism parallelism;
    private ObjectPool<ScoreContext> contexts;
    private MARKStarNode.ScorerFactory gscorerFactory;
    private MARKStarNode.ScorerFactory hscorerFactory;
    public boolean reduceMinimizations = true;
    private ConfAnalyzer confAnalyzer;
    EnergyMatrix minimizingEmat;
    EnergyMatrix rigidEmat;
    UpdatingEnergyMatrix correctionMatrix;
    ConfEnergyCalculator minimizingEcalc;
    private Stopwatch stopwatch = new Stopwatch().start();
    BigDecimal startUpperBound = null;
    BigDecimal startLowerBound = BigDecimal.ZERO;
    BigDecimal lowerReduction_FullMin = BigDecimal.ZERO;
    BigDecimal lowerReduction_ConfUpperBound = BigDecimal.ZERO;
    BigDecimal upperReduction_FullMin = BigDecimal.ZERO;
    BigDecimal upperReduction_PartialMin = BigDecimal.ZERO;
    BigDecimal upperReduction_ConfLowerBound = BigDecimal.ZERO;
    BigDecimal cumulativeZCorrection = BigDecimal.ZERO;
    BigDecimal ZReductionFromMin = BigDecimal.ZERO;
    BoltzmannCalculator bc = new BoltzmannCalculator(PartitionFunction.decimalPrecision);
    private boolean computedCorrections = false;
    private long loopPartialTime = 0L;
    private Set<String> correctedTuples = Collections.synchronizedSet(new HashSet());
    private BigDecimal stabilityThreshold;
    private double leafTimeSum = 0.0;
    private double internalTimeSum = 0.0;
    private int numLeavesScored = 0;
    private int numInternalScored = 0;

    public void setCorrections(UpdatingEnergyMatrix cachedCorrections) {
        this.correctionMatrix = cachedCorrections;
    }

    public void setRCs(RCs rcs) {
        this.RCs = rcs;
    }

    @Override
    public void setReportProgress(boolean showPfuncProgress) {
        this.printMinimizedConfs = true;
    }

    @Override
    public void setConfListener(PartitionFunction.ConfListener val) {
    }

    @Override
    public void setStabilityThreshold(BigDecimal threshold) {
        this.stabilityThreshold = threshold;
    }

    public void setMaxNumConfs(int maxNumConfs) {
        this.maxNumConfs = maxNumConfs;
    }

    @Override
    public void setConfDB(ConfDB confDB, ConfDB.Key key) {
        this.confDB = confDB;
        this.confDBKey = key;
    }

    private ConfDB.ConfTable confTable() {
        if (this.confDB == null || this.confDBKey == null) {
            return null;
        }
        return this.confDB.get(this.confDBKey);
    }

    @Override
    public void init(double targetEpsilon) {
        this.targetEpsilon = targetEpsilon;
        this.status = PartitionFunction.Status.Estimating;
        this.values = new Values();
    }

    public void init(double epsilon, BigDecimal stabilityThreshold) {
        this.targetEpsilon = epsilon;
        this.status = PartitionFunction.Status.Estimating;
        this.values = new Values();
        this.stabilityThreshold = stabilityThreshold;
    }

    @Override
    public PartitionFunction.Status getStatus() {
        return this.status;
    }

    @Override
    public PartitionFunction.Values getValues() {
        return this.values;
    }

    @Override
    public int getParallelism() {
        return 0;
    }

    @Override
    public int getNumConfsEvaluated() {
        return this.numConfsEnergied;
    }

    public int getNumConfsScored() {
        return this.numConfsScored;
    }

    private int workDone() {
        return this.numInternalNodesProcessed + this.numConfsEnergied + this.numConfsScored + this.numPartialMinimizations;
    }

    @Override
    public void compute(int maxNumConfs) {
        this.debugPrint("Num conformations: " + String.valueOf(this.rootNode.getConfSearchNode().getNumConformations()));
        double lastEps = 1.0;
        int previousConfCount = this.workDone();
        if (!this.nonZeroLower) {
            this.runUntilNonZero();
            this.updateBound();
        }
        while (this.epsilonBound > this.targetEpsilon && this.workDone() - previousConfCount < maxNumConfs && this.isStable(this.stabilityThreshold)) {
            this.debugPrint("Tightening from epsilon of " + this.epsilonBound);
            if (this.debug) {
                this.debugHeap(this.queue);
            }
            this.tightenBoundInPhases();
            this.debugPrint("Errorbound is now " + this.epsilonBound);
            if (lastEps < this.epsilonBound && this.epsilonBound - lastEps > 0.01) {
                System.err.println("Error. Bounds got looser.");
            }
            lastEps = this.epsilonBound;
        }
        if (!this.isStable(this.stabilityThreshold)) {
            this.status = PartitionFunction.Status.Unstable;
        }
        loopTasks.waitForFinish();
        this.minimizingEcalc.tasks.waitForFinish();
        BigDecimal averageReduction = BigDecimal.ZERO;
        int totalMinimizations = this.numConfsEnergied + this.numPartialMinimizations;
        if (totalMinimizations > 0) {
            averageReduction = this.cumulativeZCorrection.divide(new BigDecimal(totalMinimizations), new MathContext(4));
        }
        this.debugPrint(String.format("Average Z reduction per minimization: %12.6e", averageReduction));
        this.values.pstar = this.rootNode.getUpperBound();
        this.values.qstar = this.rootNode.getLowerBound();
        this.values.qprime = this.rootNode.getUpperBound();
        if (this.epsilonBound < this.targetEpsilon) {
            this.status = PartitionFunction.Status.Estimated;
            if (this.values.qstar.compareTo(BigDecimal.ZERO) == 0) {
                this.status = PartitionFunction.Status.Unstable;
            }
        }
    }

    protected void debugPrint(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    protected void profilePrint(String s) {
        if (this.profileOutput) {
            System.out.println(s);
        }
    }

    @Override
    public void compute() {
        this.compute(Integer.MAX_VALUE);
    }

    @Override
    public PartitionFunction.Result makeResult() {
        this.lowerReduction_ConfUpperBound = this.rootNode.getLowerBound().subtract(this.startLowerBound).subtract(this.lowerReduction_FullMin);
        this.upperReduction_ConfLowerBound = this.startUpperBound.subtract(this.rootNode.getUpperBound()).subtract(this.upperReduction_FullMin).subtract(this.upperReduction_PartialMin);
        PartitionFunction.Result result = new PartitionFunction.Result(this.getStatus(), this.getValues(), this.getNumConfsEvaluated());
        return result;
    }

    public static MARKStarBound makeFromConfSpaceInfo(BBKStar.ConfSpaceInfo info2, RCs rcs) {
        throw new UnsupportedOperationException("MARK* is not yet integrated into BBK*. Coming soon!");
    }

    public MARKStarBound(SimpleConfSpace confSpace, EnergyMatrix rigidEmat, EnergyMatrix minimizingEmat, ConfEnergyCalculator minimizingConfEcalc, RCs rcs, Parallelism parallelism) {
        this.queue = new PriorityQueue<MARKStarNode>();
        this.minimizingEcalc = minimizingConfEcalc;
        this.gscorerFactory = emats -> new PairwiseGScorer(emats);
        EdgeUpdater updater = new EdgeUpdater();
        MPLPPairwiseHScorer scorer = new MPLPPairwiseHScorer(updater, minimizingEmat, 1, 1.0E-4);
        this.hscorerFactory = emats -> new MPLPPairwiseHScorer(updater, emats, 1, 1.0E-4);
        this.rootNode = MARKStarNode.makeRoot(confSpace, rigidEmat, minimizingEmat, rcs, this.gscorerFactory.make(minimizingEmat), this.hscorerFactory.make(minimizingEmat), this.gscorerFactory.make(rigidEmat), new TraditionalPairwiseHScorer(new NegatedEnergyMatrix(confSpace, rigidEmat), rcs), true);
        this.confIndex = new ConfIndex(rcs.getNumPos());
        this.minimizingEmat = minimizingEmat;
        this.rigidEmat = rigidEmat;
        this.RCs = rcs;
        this.order = new StaticBiggestLowerboundDifferenceOrder();
        this.order.setScorers(this.gscorerFactory.make(minimizingEmat), this.hscorerFactory.make(minimizingEmat));
        this.pruner = null;
        this.contexts = new ObjectPool<ScoreContext>(lingored -> {
            ScoreContext context = new ScoreContext();
            context.index = new ConfIndex(rcs.getNumPos());
            context.gscorer = this.gscorerFactory.make(minimizingEmat);
            context.hscorer = this.hscorerFactory.make(minimizingEmat);
            context.rigidscorer = this.gscorerFactory.make(rigidEmat);
            context.negatedhscorer = new TraditionalPairwiseHScorer(new NegatedEnergyMatrix(confSpace, rigidEmat), rcs);
            context.ecalc = minimizingConfEcalc;
            return context;
        });
        this.progress = new MARKStarProgress(this.RCs.getNumPos());
        this.confAnalyzer = new ConfAnalyzer(minimizingConfEcalc);
        this.setParallelism(parallelism);
        this.updateBound();
        this.startLowerBound = this.rootNode.getLowerBound();
        this.startUpperBound = this.rootNode.getUpperBound();
        this.minList = new ArrayList<Integer>(Collections.nCopies(rcs.getNumPos(), 0));
    }

    public void setParallelism(Parallelism val) {
        if (val == null) {
            val = Parallelism.makeCpu(1);
        }
        this.parallelism = val;
        if (loopTasks == null) {
            loopTasks = this.parallelism.makeTaskExecutor(1000);
        }
        this.contexts.allocate(this.parallelism.getParallelism());
    }

    private void debugEpsilon(double curEpsilon) {
        if (this.debug && curEpsilon < this.epsilonBound) {
            System.err.println("Epsilon just got bigger.");
        }
    }

    protected boolean shouldMinimize(MARKStarNode.Node node) {
        return node.getLevel() == this.RCs.getNumPos() && !node.isMinimized();
    }

    protected void recordCorrection(double lowerBound, double correction) {
        BigDecimal upper = this.bc.calc(lowerBound);
        BigDecimal corrected = this.bc.calc(lowerBound + correction);
        this.cumulativeZCorrection = this.cumulativeZCorrection.add(upper.subtract(corrected));
        this.upperReduction_PartialMin = this.upperReduction_PartialMin.add(upper.subtract(corrected));
    }

    private void recordReduction(double lowerBound, double upperBound, double energy) {
        BigDecimal lowerBoundWeight = this.bc.calc(lowerBound);
        BigDecimal upperBoundWeight = this.bc.calc(upperBound);
        BigDecimal energyWeight = this.bc.calc(energy);
        this.ZReductionFromMin = this.ZReductionFromMin.add(lowerBoundWeight.subtract(upperBoundWeight));
        this.upperReduction_FullMin = this.upperReduction_FullMin.add(lowerBoundWeight.subtract(energyWeight));
        this.lowerReduction_FullMin = this.lowerReduction_FullMin.add(energyWeight.subtract(upperBoundWeight));
    }

    private void debugBreakOnConf(int[] conf) {
        int[] confOfInterest = new int[]{4, 5, 8, 18};
        if (conf.length != confOfInterest.length) {
            return;
        }
        boolean match = true;
        for (int i = 0; i < confOfInterest.length; ++i) {
            if (conf[i] == confOfInterest[i]) continue;
            match = false;
            break;
        }
        if (match) {
            System.out.println("Matched " + SimpleConfSpace.formatConfRCs(conf));
        }
    }

    private void runUntilNonZero() {
        System.out.println("Running until leaf is found...");
        double bestConfUpper = Double.POSITIVE_INFINITY;
        ArrayList<MARKStarNode> newNodes = new ArrayList<MARKStarNode>();
        ArrayList leafNodes = new ArrayList();
        boolean numNodes = false;
        Stopwatch leafLoop = new Stopwatch().start();
        Stopwatch overallLoop = new Stopwatch().start();
        this.boundLowestBoundConfUnderNode(this.rootNode, newNodes);
        this.queue.addAll(newNodes);
        newNodes.clear();
        System.out.println("Found a leaf!");
        this.nonZeroLower = true;
    }

    protected void tightenBoundInPhases() {
        System.out.println(String.format("Current overall error bound: %12.10f, spread of [%12.6e, %12.6e]", this.epsilonBound, this.rootNode.getLowerBound(), this.rootNode.getUpperBound()));
        ArrayList<MARKStarNode> internalNodes = new ArrayList<MARKStarNode>();
        ArrayList<MARKStarNode> leafNodes = new ArrayList<MARKStarNode>();
        List<MARKStarNode> newNodes = Collections.synchronizedList(new ArrayList());
        BigDecimal internalZ = BigDecimal.ONE;
        BigDecimal leafZ = BigDecimal.ONE;
        int numNodes = 0;
        Stopwatch loopWatch = new Stopwatch();
        loopWatch.start();
        Stopwatch internalTime = new Stopwatch();
        Stopwatch leafTime = new Stopwatch();
        double leafTimeSum = 0.0;
        double internalTimeSum = 0.0;
        BigDecimal[] ZSums = new BigDecimal[]{internalZ, leafZ};
        this.populateQueues(this.queue, internalNodes, leafNodes, internalZ, leafZ, ZSums);
        this.updateBound();
        this.debugPrint(String.format("After corrections, bounds are now [%12.6e,%12.6e]", this.rootNode.getLowerBound(), this.rootNode.getUpperBound()));
        internalZ = ZSums[0];
        leafZ = ZSums[1];
        System.out.println(String.format("Z Comparison: %12.6e, %12.6e", internalZ, leafZ));
        if (MathTools.isLessThan(internalZ, leafZ)) {
            numNodes = leafNodes.size();
            System.out.println("Processing " + numNodes + " leaf nodes...");
            leafTime.reset();
            leafTime.start();
            for (MARKStarNode leafNode : leafNodes) {
                this.processFullConfNode(newNodes, leafNode, leafNode.getConfSearchNode());
                leafNode.markUpdated();
                this.debugPrint("Processing Node: " + leafNode.getConfSearchNode().toString());
            }
            loopTasks.waitForFinish();
            leafTime.stop();
            this.leafTimeAverage = leafTime.getTimeS();
            System.out.println("Processed " + numNodes + " leaves in " + this.leafTimeAverage + " seconds.");
            this.queue.addAll(internalNodes);
            if (this.maxMinimizations < this.parallelism.numThreads) {
                ++this.maxMinimizations;
            }
        } else {
            numNodes = internalNodes.size();
            System.out.println("Processing " + numNodes + " internal nodes...");
            internalTime.reset();
            internalTime.start();
            for (MARKStarNode internalNode : internalNodes) {
                if (!MathTools.isGreaterThan(internalNode.getLowerBound(), BigDecimal.ONE) && MathTools.isGreaterThan(MathTools.bigDivide(internalNode.getUpperBound(), this.rootNode.getUpperBound(), PartitionFunction.decimalPrecision), new BigDecimal(1.0 - this.targetEpsilon))) {
                    loopTasks.submit(() -> {
                        this.boundLowestBoundConfUnderNode(internalNode, newNodes);
                        return null;
                    }, ignored -> {});
                } else {
                    this.processPartialConfNode(newNodes, internalNode, internalNode.getConfSearchNode());
                }
                internalNode.markUpdated();
            }
            loopTasks.waitForFinish();
            internalTime.stop();
            internalTimeSum = internalTime.getTimeS();
            this.internalTimeAverage = internalTimeSum / (double)Math.max(1, internalNodes.size());
            this.debugPrint("Internal node time :" + internalTimeSum + ", average " + this.internalTimeAverage);
            this.queue.addAll(leafNodes);
            this.numInternalNodesProcessed += internalNodes.size();
        }
        if (this.epsilonBound <= this.targetEpsilon) {
            return;
        }
        this.loopCleanup(newNodes, loopWatch, numNodes);
    }

    protected void debugHeap(Queue<MARKStarNode> queue) {
        int maxNodes = 10;
        System.out.println("Node heap:");
        ArrayList<MARKStarNode> nodes = new ArrayList<MARKStarNode>();
        while (!queue.isEmpty() && nodes.size() < 10) {
            MARKStarNode node = queue.poll();
            System.out.println(node.getConfSearchNode());
            nodes.add(node);
        }
        queue.addAll(nodes);
    }

    boolean isStable(BigDecimal stabilityThreshold) {
        return this.numConfsEnergied <= 0 || stabilityThreshold == null || MathTools.isGreaterThanOrEqual(this.rootNode.getUpperBound(), stabilityThreshold);
    }

    protected void populateQueues(Queue<MARKStarNode> queue, List<MARKStarNode> internalNodes, List<MARKStarNode> leafNodes, BigDecimal internalZ, BigDecimal leafZ, BigDecimal[] ZSums) {
        ArrayList<MARKStarNode> leftoverLeaves = new ArrayList<MARKStarNode>();
        int maxNodes = 1000;
        if (this.leafTimeAverage > 0.0) {
            maxNodes = Math.max(maxNodes, (int)Math.floor(0.1 * this.leafTimeAverage / this.internalTimeAverage));
        }
        while (!queue.isEmpty() && internalNodes.size() < maxNodes) {
            MARKStarNode curNode = queue.poll();
            MARKStarNode.Node node = curNode.getConfSearchNode();
            ConfIndex index = new ConfIndex(this.RCs.getNumPos());
            node.index(index);
            double correctgscore = this.correctionMatrix.confE(node.assignments);
            double hscore = node.getConfLowerBound() - node.gscore;
            double confCorrection = Math.min(correctgscore, node.rigidScore) + hscore;
            if (!node.isMinimized() && node.getConfLowerBound() < confCorrection && node.getConfLowerBound() - confCorrection > 1.0E-5) {
                if (confCorrection < node.getConfLowerBound()) {
                    System.out.println("huh!?");
                }
                this.recordCorrection(node.getConfLowerBound(), correctgscore - node.gscore);
                node.gscore = correctgscore;
                if (confCorrection > node.rigidScore) {
                    System.out.println("Overcorrected" + SimpleConfSpace.formatConfRCs(node.assignments) + ": " + confCorrection + " > " + node.rigidScore);
                    node.gscore = node.rigidScore;
                    confCorrection = node.rigidScore + hscore;
                }
                node.setBoundsFromConfLowerAndUpper(confCorrection, node.getConfUpperBound());
                curNode.markUpdated();
                leftoverLeaves.add(curNode);
                continue;
            }
            BigDecimal diff = curNode.getUpperBound().subtract(curNode.getLowerBound());
            if (node.getLevel() < this.RCs.getNumPos()) {
                internalNodes.add(curNode);
                internalZ = internalZ.add(diff);
                continue;
            }
            if (!this.shouldMinimize(node) || this.correctedNode(leftoverLeaves, curNode, node)) continue;
            if (leafNodes.size() < this.maxMinimizations) {
                leafNodes.add(curNode);
                leafZ = leafZ.add(diff);
                continue;
            }
            leftoverLeaves.add(curNode);
        }
        ZSums[0] = internalZ;
        ZSums[1] = leafZ;
        queue.addAll(leftoverLeaves);
    }

    protected void loopCleanup(List<MARKStarNode> newNodes, Stopwatch loopWatch, int numNodes) {
        for (MARKStarNode node : newNodes) {
            if (node == null) continue;
            this.queue.add(node);
        }
        loopWatch.stop();
        double loopTime = loopWatch.getTimeS();
        this.profilePrint("Processed " + numNodes + " this loop, spawning " + newNodes.size() + " in " + loopTime + ", " + this.stopwatch.getTime() + " so far");
        loopWatch.reset();
        loopWatch.start();
        this.processPreminimization(this.minimizingEcalc);
        this.profilePrint("Preminimization time : " + loopWatch.getTime(2));
        double curEpsilon = this.epsilonBound;
        this.updateBound();
        loopWatch.stop();
        this.cleanupTime = loopWatch.getTimeS();
        System.out.println(String.format("Loop complete. Bounds are now [%12.6e,%12.6e]", this.rootNode.getLowerBound(), this.rootNode.getUpperBound()));
    }

    protected boolean correctedNode(List<MARKStarNode> newNodes, MARKStarNode curNode, MARKStarNode.Node node) {
        assert (curNode != null && node != null);
        double confCorrection = this.correctionMatrix.confE(node.assignments);
        if (node.getLevel() == this.RCs.getNumPos() && node.getConfLowerBound() < confCorrection || node.gscore < confCorrection) {
            double oldg = node.gscore;
            node.gscore = confCorrection;
            this.recordCorrection(oldg, confCorrection - oldg);
            node.setBoundsFromConfLowerAndUpper(node.getConfLowerBound() - oldg + confCorrection, node.getConfUpperBound());
            curNode.markUpdated();
            newNodes.add(curNode);
            return true;
        }
        return false;
    }

    private MARKStarNode drillDown(List<MARKStarNode> newNodes, MARKStarNode curNode, MARKStarNode.Node node) {
        try (ObjectPool.Checkout<ScoreContext> checkout = this.contexts.autoCheckout();){
            ScoreContext context = checkout.get();
            ConfIndex confIndex = context.index;
            node.index(confIndex);
            int nextPos = this.order.getNextPos(confIndex, this.RCs);
            assert (!confIndex.isDefined(nextPos));
            assert (confIndex.isUndefined(nextPos));
            ArrayList<MARKStarNode> children = new ArrayList<MARKStarNode>();
            double bestChildLower = Double.POSITIVE_INFINITY;
            MARKStarNode bestChild = null;
            for (int nextRc : this.RCs.get(nextPos)) {
                if (this.hasPrunedPair(confIndex, nextPos, nextRc) || this.pruner != null && this.pruner.isPruned(node, nextPos, nextRc)) continue;
                Stopwatch partialTime = new Stopwatch().start();
                MARKStarNode.Node child = node.assign(nextPos, nextRc);
                double confLowerBound = Double.POSITIVE_INFINITY;
                if (child.getLevel() < this.RCs.getNumPos()) {
                    double confCorrection;
                    double diff = confCorrection = this.correctionMatrix.confE(child.assignments);
                    double rigiddiff = context.rigidscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    double hdiff = context.hscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    double maxhdiff = -context.negatedhscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    child.gscore = diff;
                    child.rigidScore = rigiddiff = rigiddiff - node.gscore + node.rigidScore;
                    confLowerBound = child.gscore + hdiff;
                    double confUpperbound = rigiddiff + maxhdiff;
                    child.computeNumConformations(this.RCs);
                    if (diff < confCorrection) {
                        this.recordCorrection(confLowerBound, confCorrection - diff);
                        confLowerBound = confCorrection + hdiff;
                    }
                    child.setBoundsFromConfLowerAndUpper(confLowerBound, confUpperbound);
                    this.progress.reportInternalNode(child.level, child.gscore, child.getHScore(), this.queue.size(), children.size(), this.epsilonBound);
                }
                if (child.getLevel() == this.RCs.getNumPos()) {
                    double confRigid = context.rigidscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    confRigid = confRigid - node.gscore + node.rigidScore;
                    child.computeNumConformations(this.RCs);
                    double confCorrection = this.correctionMatrix.confE(child.assignments);
                    double lowerbound = this.minimizingEmat.confE(child.assignments);
                    if (lowerbound < confCorrection) {
                        this.recordCorrection(lowerbound, confCorrection - lowerbound);
                    }
                    this.checkBounds(confCorrection, confRigid);
                    child.setBoundsFromConfLowerAndUpper(confCorrection, confRigid);
                    child.gscore = child.getConfLowerBound();
                    confLowerBound = lowerbound;
                    child.rigidScore = confRigid;
                    ++this.numConfsScored;
                    this.progress.reportLeafNode(child.gscore, this.queue.size(), this.epsilonBound);
                }
                partialTime.stop();
                this.loopPartialTime = (long)((double)this.loopPartialTime + partialTime.getTimeS());
                if (Double.isNaN(child.rigidScore)) {
                    System.out.println("Huh!?");
                }
                MARKStarNode MARKStarNodeChild = curNode.makeChild(child);
                MARKStarNodeChild.markUpdated();
                if (confLowerBound < bestChildLower) {
                    bestChild = MARKStarNodeChild;
                }
                if (MARKStarNodeChild.getConfSearchNode().getConfLowerBound() < 0.0) {
                    children.add(MARKStarNodeChild);
                }
                newNodes.add(MARKStarNodeChild);
            }
            int[] nArray = bestChild;
            return nArray;
        }
    }

    protected void boundLowestBoundConfUnderNode(MARKStarNode startNode, List<MARKStarNode> generatedNodes) {
        Comparator<MARKStarNode> confBoundComparator = Comparator.comparingDouble(o -> o.getConfSearchNode().getConfLowerBound());
        PriorityQueue<MARKStarNode> drillQueue = new PriorityQueue<MARKStarNode>(confBoundComparator);
        drillQueue.add(startNode);
        ArrayList<MARKStarNode> newNodes = new ArrayList<MARKStarNode>();
        int numNodes = 0;
        Stopwatch leafLoop = new Stopwatch().start();
        Stopwatch overallLoop = new Stopwatch().start();
        while (!drillQueue.isEmpty()) {
            ++numNodes;
            MARKStarNode curNode = drillQueue.poll();
            MARKStarNode.Node node = curNode.getConfSearchNode();
            ConfIndex index = new ConfIndex(this.RCs.getNumPos());
            node.index(index);
            if (node.getLevel() < this.RCs.getNumPos()) {
                MARKStarNode nextNode = this.drillDown(newNodes, curNode, node);
                newNodes.remove(nextNode);
                drillQueue.add(nextNode);
            } else if (this.RCs.getNumPos() == 0) {
                curNode.recomputeEpsilon();
            } else {
                newNodes.add(curNode);
            }
            if (!(leafLoop.getTimeS() > 1.0)) continue;
            leafLoop.stop();
            leafLoop.reset();
            leafLoop.start();
            System.out.println(String.format("Processed %d, %s so far. Bounds are now [%12.6e,%12.6e]", numNodes, overallLoop.getTime(2), this.rootNode.getLowerBound(), this.rootNode.getUpperBound()));
        }
        generatedNodes.addAll(newNodes);
    }

    protected void processPartialConfNode(List<MARKStarNode> newNodes, MARKStarNode curNode, MARKStarNode.Node node) {
        node.index(this.confIndex);
        int nextPos = this.order.getNextPos(this.confIndex, this.RCs);
        assert (!this.confIndex.isDefined(nextPos));
        assert (this.confIndex.isUndefined(nextPos));
        ArrayList children = new ArrayList();
        for (int nextRc : this.RCs.get(nextPos)) {
            if (this.hasPrunedPair(this.confIndex, nextPos, nextRc) || this.pruner != null && this.pruner.isPruned(node, nextPos, nextRc)) continue;
            loopTasks.submit(() -> {
                try (ObjectPool.Checkout<ScoreContext> checkout = this.contexts.autoCheckout();){
                    Stopwatch partialTime = new Stopwatch().start();
                    ScoreContext context = checkout.get();
                    node.index(context.index);
                    MARKStarNode.Node child = node.assign(nextPos, nextRc);
                    if (child.getLevel() < this.RCs.getNumPos()) {
                        double confCorrection;
                        double diff = confCorrection = this.correctionMatrix.confE(child.assignments);
                        double rigiddiff = context.rigidscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                        double hdiff = context.hscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                        double maxhdiff = -context.negatedhscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                        child.gscore = diff;
                        child.rigidScore = rigiddiff = rigiddiff - node.gscore + node.rigidScore;
                        double confLowerBound = child.gscore + hdiff;
                        double confUpperbound = rigiddiff + maxhdiff;
                        child.computeNumConformations(this.RCs);
                        double lowerbound = this.minimizingEmat.confE(child.assignments);
                        if (diff < confCorrection) {
                            this.recordCorrection(confLowerBound, confCorrection - diff);
                            confLowerBound = confCorrection + hdiff;
                        }
                        child.setBoundsFromConfLowerAndUpper(confLowerBound, confUpperbound);
                        this.progress.reportInternalNode(child.level, child.gscore, child.getHScore(), this.queue.size(), children.size(), this.epsilonBound);
                    }
                    if (child.getLevel() == this.RCs.getNumPos()) {
                        double confRigid = context.rigidscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                        confRigid = confRigid - node.gscore + node.rigidScore;
                        child.computeNumConformations(this.RCs);
                        double confCorrection = this.correctionMatrix.confE(child.assignments);
                        double lowerbound = this.minimizingEmat.confE(child.assignments);
                        if (lowerbound < confCorrection) {
                            this.recordCorrection(lowerbound, confCorrection - lowerbound);
                        }
                        this.checkBounds(confCorrection, confRigid);
                        child.setBoundsFromConfLowerAndUpper(confCorrection, confRigid);
                        child.gscore = confCorrection;
                        child.rigidScore = confRigid;
                        ++this.numConfsScored;
                        this.progress.reportLeafNode(child.gscore, this.queue.size(), this.epsilonBound);
                    }
                    partialTime.stop();
                    this.loopPartialTime = (long)((double)this.loopPartialTime + partialTime.getTimeS());
                    MARKStarNode.Node node2 = child;
                    return node2;
                }
            }, child -> {
                MARKStarNode MARKStarNodeChild;
                if (Double.isNaN(child.rigidScore)) {
                    System.out.println("Huh!?");
                }
                if ((MARKStarNodeChild = curNode.makeChild((MARKStarNode.Node)child)).getConfSearchNode().getConfLowerBound() < 0.0) {
                    children.add(MARKStarNodeChild);
                }
                if (!child.isMinimized()) {
                    newNodes.add(MARKStarNodeChild);
                } else {
                    MARKStarNodeChild.computeEpsilonErrorBounds();
                }
                curNode.markUpdated();
            });
        }
    }

    protected void processFullConfNode(List<MARKStarNode> newNodes, MARKStarNode curNode, MARKStarNode.Node node) {
        double confCorrection = this.correctionMatrix.confE(node.assignments);
        if (node.getConfLowerBound() < confCorrection || node.gscore < confCorrection) {
            double oldg = node.gscore;
            node.gscore = confCorrection;
            this.recordCorrection(oldg, confCorrection - oldg);
            node.setBoundsFromConfLowerAndUpper(confCorrection, node.getConfUpperBound());
            curNode.markUpdated();
            newNodes.add(curNode);
            return;
        }
        loopTasks.submit(() -> {
            try (ObjectPool.Checkout<ScoreContext> checkout = this.contexts.autoCheckout();){
                double energy;
                ScoreContext context = checkout.get();
                node.index(context.index);
                ConfSearch.ScoredConf conf = new ConfSearch.ScoredConf(node.assignments, node.getConfLowerBound());
                ConfAnalyzer.ConfAnalysis analysis = this.confAnalyzer.analyze(conf);
                ConfDB.ConfTable confTable = this.confTable();
                if (confTable != null) {
                    long timestamp = TimeTools.getTimestampNs();
                    confTable.setLowerBound(conf.getAssignments(), conf.getScore(), timestamp);
                    confTable.setUpperBound(conf.getAssignments(), analysis.epmol.energy, timestamp);
                }
                Stopwatch correctionTimer = new Stopwatch().start();
                this.computeEnergyCorrection(analysis, conf, context.ecalc);
                double newConfUpper = energy = analysis.epmol.energy;
                double newConfLower = energy;
                double oldConfUpper = node.getConfUpperBound();
                double oldConfLower = node.getConfLowerBound();
                this.checkConfLowerBound(node, energy);
                if (newConfUpper > oldConfUpper) {
                    System.err.println("Upper bounds got worse after minimization:" + newConfUpper + " > " + oldConfUpper + ". Rejecting minimized energy.");
                    System.err.println("Node info: " + String.valueOf(node));
                    newConfUpper = oldConfUpper;
                    newConfLower = oldConfUpper;
                }
                curNode.setBoundsFromConfLowerAndUpper(newConfLower, newConfUpper);
                double oldgscore = node.gscore;
                node.gscore = newConfLower;
                String out = "Energy = " + String.format("%6.3e", energy) + ", [" + node.getConfLowerBound() + "," + node.getConfUpperBound() + "]";
                this.debugPrint(out);
                curNode.markUpdated();
                MARKStarBound mARKStarBound = this;
                synchronized (mARKStarBound) {
                    ++this.numConfsEnergied;
                    this.minList.set(conf.getAssignments().length - 1, this.minList.get(conf.getAssignments().length - 1) + 1);
                    this.recordReduction(oldConfLower, oldConfUpper, energy);
                    this.printMinimizationOutput(node, newConfLower, oldgscore);
                }
            }
            return null;
        }, child -> {
            this.progress.reportLeafNode(node.gscore, this.queue.size(), this.epsilonBound);
            if (!node.isMinimized()) {
                newNodes.add(curNode);
            }
        });
    }

    private void printMinimizationOutput(MARKStarNode.Node node, double newConfLower, double oldgscore) {
        if (this.printMinimizedConfs) {
            System.out.println("[" + SimpleConfSpace.formatConfRCs(node.assignments) + "]" + String.format("conf:%4d, score:%12.6f, lower:%12.6f, corrected:%12.6f energy:%12.6f, bounds:[%12e, %12e], delta:%12.6f, time:%10s", this.numConfsEnergied, oldgscore, this.minimizingEmat.confE(node.assignments), this.correctionMatrix.confE(node.assignments), newConfLower, this.rootNode.getConfSearchNode().getSubtreeLowerBound(), this.rootNode.getConfSearchNode().getSubtreeUpperBound(), this.epsilonBound, this.stopwatch.getTime(2)));
        }
    }

    private void checkConfLowerBound(MARKStarNode.Node node, double energy) {
        if (energy < node.getConfLowerBound()) {
            System.err.println("Bounds are incorrect:" + node.getConfLowerBound() + " > " + energy);
            if (energy < 10.0) {
                System.err.println("The bounds are probably wrong.");
            }
        }
    }

    private void checkBounds(double lower, double upper) {
        if (upper < lower && upper - lower > 1.0E-5 && upper < 10.0) {
            this.debugPrint("Bounds incorrect.");
        }
    }

    private void computeEnergyCorrection(ConfAnalyzer.ConfAnalysis analysis, ConfSearch.ScoredConf conf, ConfEnergyCalculator ecalc) {
        if (conf.getAssignments().length < 3) {
            return;
        }
        EnergyMatrix energyAnalysis = analysis.breakdownEnergyByPosition(ResidueForcefieldBreakdown.Type.All);
        EnergyMatrix scoreAnalysis = analysis.breakdownScoreByPosition(this.minimizingEmat);
        Stopwatch correctionTime = new Stopwatch().start();
        EnergyMatrix diff = energyAnalysis.diff(scoreAnalysis);
        ArrayList<TupE> sortedPairwiseTerms2 = new ArrayList<TupE>();
        for (int pos = 0; pos < diff.getNumPos(); ++pos) {
            for (int rc = 0; rc < diff.getNumConfAtPos(pos); ++rc) {
                for (int pos2 = 0; pos2 < diff.getNumPos(); ++pos2) {
                    for (int rc2 = 0; rc2 < diff.getNumConfAtPos(pos2); ++rc2) {
                        if (pos >= pos2) continue;
                        double sum = 0.0;
                        sum += diff.getOneBody(pos, rc).doubleValue();
                        sum += diff.getPairwise(pos, rc, pos2, rc2).doubleValue();
                        TupE tupe = new TupE(new RCTuple(pos, rc, pos2, rc2), sum += diff.getOneBody(pos2, rc2).doubleValue());
                        sortedPairwiseTerms2.add(tupe);
                    }
                }
            }
        }
        Collections.sort(sortedPairwiseTerms2);
        double threshhold = 0.1;
        double minDifference = 0.9;
        double triplethreshhold = 0.3;
        double maxDiff = ((TupE)sortedPairwiseTerms2.get((int)0)).E;
        for (int i = 0; i < sortedPairwiseTerms2.size(); ++i) {
            TupE tupe = (TupE)sortedPairwiseTerms2.get(i);
            double pairDiff = tupe.E;
            if (pairDiff < minDifference && maxDiff - pairDiff > threshhold) continue;
            maxDiff = Math.max(maxDiff, tupe.E);
            int pos1 = tupe.tup.pos.get(0);
            int pos2 = tupe.tup.pos.get(1);
            int localMinimizations = 0;
            for (int pos3 = 0; pos3 < diff.getNumPos(); ++pos3) {
                if (pos3 == pos2 || pos3 == pos1) continue;
                RCTuple tuple = this.makeTuple(conf, pos1, pos2, pos3);
                double tupleBounds = this.rigidEmat.getInternalEnergy(tuple) - this.minimizingEmat.getInternalEnergy(tuple);
                if (tupleBounds < triplethreshhold) continue;
                this.minList.set(tuple.size() - 1, this.minList.get(tuple.size() - 1) + 1);
                this.computeDifference(tuple, this.minimizingEcalc);
                ++localMinimizations;
            }
            this.numPartialMinimizations += localMinimizations;
            this.progress.reportPartialMinimization(localMinimizations, this.epsilonBound);
        }
        correctionTime.stop();
        ecalc.tasks.waitForFinish();
    }

    private void computeDifference(RCTuple tuple, ConfEnergyCalculator ecalc) {
        this.computedCorrections = true;
        if (this.correctedTuples.contains(tuple.stringListing())) {
            return;
        }
        this.correctedTuples.add(tuple.stringListing());
        if (this.correctionMatrix.hasHigherOrderTermFor(tuple)) {
            return;
        }
        this.minimizingEcalc.calcEnergyAsync(tuple, minimizedTuple -> {
            double tripleEnergy = minimizedTuple.energy;
            double lowerbound = this.minimizingEmat.getInternalEnergy(tuple);
            if (tripleEnergy - lowerbound > 0.0) {
                double correction = tripleEnergy - lowerbound;
                this.correctionMatrix.setHigherOrder(tuple, correction);
            } else {
                System.err.println("Negative correction for " + tuple.stringListing());
            }
        });
    }

    private RCTuple makeTuple(ConfSearch.ScoredConf conf, int ... positions) {
        RCTuple out = new RCTuple();
        for (int pos : positions) {
            out = out.addRC(pos, conf.getAssignments()[pos]);
        }
        return out;
    }

    private void processPreminimization(ConfEnergyCalculator ecalc) {
        int maxMinimizations = 1;
        List<MARKStarNode> topConfs = this.getTopConfs(maxMinimizations);
        if (topConfs.size() < 2) {
            this.queue.addAll(topConfs);
            return;
        }
        RCTuple lowestBoundTuple = topConfs.get(0).toTuple();
        RCTuple overlap = this.findLargestOverlap(lowestBoundTuple, topConfs, 3);
        for (MARKStarNode conf : topConfs) {
            RCTuple confTuple = conf.toTuple();
            if (this.minimizingEmat.getInternalEnergy(confTuple) == this.rigidEmat.getInternalEnergy(confTuple)) continue;
            ++this.numPartialMinimizations;
            this.minList.set(confTuple.size() - 1, this.minList.get(confTuple.size() - 1) + 1);
            if (confTuple.size() <= 2 || confTuple.size() >= this.RCs.getNumPos()) continue;
            this.minimizingEcalc.tasks.submit(() -> {
                this.computeTupleCorrection(this.minimizingEcalc, conf.toTuple());
                return null;
            }, econf -> {});
        }
        ConfIndex index = new ConfIndex(this.RCs.getNumPos());
        if (overlap.size() > 3 && !this.correctionMatrix.hasHigherOrderTermFor(overlap) && this.minimizingEmat.getInternalEnergy(overlap) != this.rigidEmat.getInternalEnergy(overlap)) {
            this.minimizingEcalc.tasks.submit(() -> {
                this.computeTupleCorrection(ecalc, overlap);
                return null;
            }, econf -> {});
        }
        this.queue.addAll(topConfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTupleCorrection(ConfEnergyCalculator ecalc, RCTuple overlap) {
        if (this.correctionMatrix.hasHigherOrderTermFor(overlap)) {
            return;
        }
        double pairwiseLower = this.minimizingEmat.getInternalEnergy(overlap);
        double partiallyMinimizedLower = ecalc.calcEnergy((RCTuple)overlap).energy;
        this.progress.reportPartialMinimization(1, this.epsilonBound);
        if (partiallyMinimizedLower > pairwiseLower) {
            UpdatingEnergyMatrix updatingEnergyMatrix = this.correctionMatrix;
            synchronized (updatingEnergyMatrix) {
                this.correctionMatrix.setHigherOrder(overlap, partiallyMinimizedLower - pairwiseLower);
            }
        }
        this.progress.reportPartialMinimization(1, this.epsilonBound);
    }

    private List<MARKStarNode> getTopConfs(int numConfs) {
        ArrayList<MARKStarNode> topConfs = new ArrayList<MARKStarNode>();
        while (topConfs.size() < numConfs && !this.queue.isEmpty()) {
            MARKStarNode nextLowestConf = this.queue.poll();
            topConfs.add(nextLowestConf);
        }
        return topConfs;
    }

    private RCTuple findLargestOverlap(RCTuple conf, List<MARKStarNode> otherConfs, int minResidues) {
        MARKStarNode other;
        RCTuple overlap = conf;
        Iterator<MARKStarNode> iterator2 = otherConfs.iterator();
        while (iterator2.hasNext() && (overlap = overlap.intersect((other = iterator2.next()).toTuple())).size() >= minResidues) {
        }
        return overlap;
    }

    protected void updateBound() {
        double curEpsilon = this.epsilonBound;
        Stopwatch time = new Stopwatch().start();
        this.epsilonBound = this.rootNode.computeEpsilonErrorBounds();
        time.stop();
        this.debugEpsilon(curEpsilon);
    }

    private boolean hasPrunedPair(ConfIndex confIndex, int nextPos, int nextRc) {
        PruningMatrix pmat = this.RCs.getPruneMat();
        if (pmat == null) {
            return false;
        }
        for (int i = 0; i < confIndex.numDefined; ++i) {
            int pos = confIndex.definedPos[i];
            int rc = confIndex.definedRCs[i];
            assert (pos != nextPos || rc != nextRc);
            if (!pmat.getPairwise(pos, rc, nextPos, nextRc).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static class Values
    extends PartitionFunction.Values {
        public Values() {
            this.pstar = MathTools.BigPositiveInfinity;
        }

        @Override
        public BigDecimal calcUpperBound() {
            return this.pstar;
        }

        @Override
        public BigDecimal calcLowerBound() {
            return this.qstar;
        }

        @Override
        public double getEffectiveEpsilon() {
            return MathTools.bigDivide(this.pstar.subtract(this.qstar), this.pstar, PartitionFunction.decimalPrecision).doubleValue();
        }
    }

    protected static class ScoreContext {
        public ConfIndex index;
        public AStarScorer gscorer;
        public AStarScorer hscorer;
        public AStarScorer negatedhscorer;
        public AStarScorer rigidscorer;
        public ConfEnergyCalculator ecalc;

        protected ScoreContext() {
        }
    }
}

