/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.markstar.framework;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.order.AStarOrder;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.BigDecimal;

public class BiggestLowerboundDifferenceOrder
implements AStarOrder {
    public final MathTools.Optimizer optimizer;
    private BoltzmannCalculator calculator = new BoltzmannCalculator(PartitionFunction.decimalPrecision);
    private AStarScorer gscorer;
    private AStarScorer hscorer;

    public BiggestLowerboundDifferenceOrder() {
        this(MathTools.Optimizer.Maximize);
    }

    public BiggestLowerboundDifferenceOrder(MathTools.Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    @Override
    public void setScorers(AStarScorer gscorer, AStarScorer hscorer) {
        this.gscorer = gscorer;
        this.hscorer = hscorer;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public int getNextPos(ConfIndex confIndex, RCs rcs) {
        int bestPos = -1;
        BigDecimal bestScore = BigDecimal.ZERO;
        for (int i = 0; i < confIndex.numUndefined; ++i) {
            int pos = confIndex.undefinedPos[i];
            BigDecimal score = this.scorePos(confIndex, rcs, pos);
            if (score.compareTo(bestScore) <= 0) continue;
            bestPos = pos;
        }
        if (bestPos >= 0) {
            return bestPos;
        }
        return confIndex.undefinedPos[0];
    }

    BigDecimal scorePos(ConfIndex confIndex, RCs rcs, int pos) {
        double parentScore = confIndex.node.getScore();
        double reciprocalSum = 0.0;
        BigDecimal maxUpper = MathTools.BigNegativeInfinity;
        BigDecimal minUpper = MathTools.BigPositiveInfinity;
        for (int rc : rcs.get(pos)) {
            double childScore = this.gscorer.calcDifferential(confIndex, rcs, pos, rc) + this.hscorer.calcDifferential(confIndex, rcs, pos, rc);
            BigDecimal childWeightedScore = this.calculator.calc(childScore);
            if (MathTools.isLessThan(childWeightedScore, minUpper)) {
                minUpper = childWeightedScore;
            }
            if (!MathTools.isGreaterThan(childWeightedScore, maxUpper)) continue;
            maxUpper = childWeightedScore;
        }
        return maxUpper.subtract(minUpper);
    }
}

