/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.lute;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.confspace.Conf;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.lute.ConfSampler;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class RandomizedDFSConfSampler
extends ConfSampler {
    public RandomizedDFSConfSampler(SimpleConfSpace confSpace, PruningMatrix pmat, int randomSeed) {
        super(confSpace, pmat, randomSeed);
    }

    @Override
    public void sampleConfsForTuples(ConfSampler.Samples samples, int minSamplesPerTuple) {
        HashSet<RCTuple> unsampleableTuples = new HashSet<RCTuple>();
        boolean sampledSomething = false;
        while (true) {
            RCTuple tuple;
            if ((tuple = samples.getLeastSampledTuple(unsampleableTuples)) == null) {
                if (sampledSomething) {
                    return;
                }
                throw new ConfSampler.NoMoreSamplesException();
            }
            Set<int[]> confs = samples.getConfs(tuple);
            if (confs.size() >= minSamplesPerTuple) break;
            int[] conf = this.randomizedDFS(tuple, confs);
            if (conf == null) {
                unsampleableTuples.add(tuple);
                continue;
            }
            samples.addConf(conf);
            sampledSomething = true;
        }
    }

    private int[] randomizedDFS(RCTuple tuple, Set<int[]> except) {
        ArrayList<SimpleConfSpace.Position> positions = new ArrayList<SimpleConfSpace.Position>();
        Iterator<Serializable> iterator2 = tuple.pos.iterator();
        while (iterator2.hasNext()) {
            int pos = iterator2.next();
            positions.add(this.confSpace.positions.get(pos));
        }
        for (SimpleConfSpace.Position pos : this.confSpace.positions) {
            if (positions.contains(pos)) continue;
            positions.add(pos);
        }
        Collections.shuffle(positions.subList(tuple.size(), positions.size()), this.rand);
        Stack<ConfIndex> stack = new Stack<ConfIndex>();
        ConfIndex root = new ConfIndex(positions.size());
        root.numDefined = tuple.size();
        for (int i = 0; i < tuple.size(); ++i) {
            root.definedPos[i] = tuple.pos.get(i);
            root.definedRCs[i] = tuple.RCs.get(i);
        }
        root.sortDefined();
        root.updateUndefined();
        stack.push(root);
        while (!stack.isEmpty()) {
            ConfIndex node = (ConfIndex)stack.pop();
            if (node.numDefined == positions.size()) {
                int[] conf = Conf.make(node);
                if (except.contains(conf)) continue;
                return conf;
            }
            SimpleConfSpace.Position pos = (SimpleConfSpace.Position)positions.get(node.numDefined);
            ArrayList<SimpleConfSpace.ResidueConf> rcs = new ArrayList<SimpleConfSpace.ResidueConf>(pos.resConfs);
            Collections.shuffle(rcs, this.rand);
            for (SimpleConfSpace.ResidueConf rc : rcs) {
                if (this.isPruned(node, pos.index, rc.index)) continue;
                stack.push(node.assign(pos.index, rc.index));
            }
        }
        return null;
    }

    private boolean isPruned(ConfIndex confIndex, int nextPos, int nextRc) {
        for (int i = 0; i < confIndex.numDefined; ++i) {
            int pos = confIndex.definedPos[i];
            int rc = confIndex.definedRCs[i];
            assert (pos != nextPos || rc != nextRc);
            if (!this.pmat.getPairwise(pos, rc, nextPos, nextRc).booleanValue()) continue;
            return true;
        }
        if (this.pmat.hasHigherOrderTuples()) {
            RCTuple tuple = new RCTuple(0, 0, 0, 0, 0, 0);
            for (int i1 = 0; i1 < confIndex.numDefined; ++i1) {
                int pos1 = confIndex.definedPos[i1];
                int rc1 = confIndex.definedRCs[i1];
                assert (pos1 != nextPos || rc1 != nextRc);
                for (int i2 = 0; i2 < i1; ++i2) {
                    int pos2 = confIndex.definedPos[i2];
                    int rc2 = confIndex.definedRCs[i2];
                    assert (pos2 != nextPos || rc2 != nextRc);
                    tuple.set(pos1, rc1, pos2, rc2, nextPos, nextRc);
                    tuple.sortPositions();
                    if (!this.pmat.getTuple(tuple).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

