/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.lute;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.lute.LUTEState;
import edu.duke.cs.osprey.tools.FileTools;
import edu.duke.cs.osprey.tools.IntEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class LUTEIO {
    public static LUTEState read(File file) {
        return LUTEIO.read(FileTools.readFileBytes(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LUTEState read(byte[] data) {
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));){
            byte[] magic = new byte[4];
            in.read(magic);
            if (!new String(magic, StandardCharsets.US_ASCII).equals("LUTE")) {
                throw new IOException("not a LUTE file");
            }
            byte version = in.readByte();
            switch (version) {
                case 1: {
                    LUTEState lUTEState = LUTEIO.readV1(in);
                    return lUTEState;
                }
            }
            throw new IOException("unrecognized version: " + version);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void write(LUTEState state, File file) {
        FileTools.writeFileBytes(LUTEIO.write(state), file);
    }

    public static byte[] write(LUTEState state) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(bytes);){
            out.write("LUTE".getBytes(StandardCharsets.US_ASCII));
            out.writeByte(1);
            LUTEIO.writeV1(state, out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return bytes.toByteArray();
    }

    private static LUTEState readV1(DataInput in) throws IOException {
        IntEncoding sizeEncoding = IntEncoding.values()[in.readByte()];
        IntEncoding posEncoding = IntEncoding.values()[in.readByte()];
        IntEncoding rcEncoding = IntEncoding.values()[in.readByte()];
        int n = in.readInt();
        LUTEState state = new LUTEState(n);
        for (int i = 0; i < n; ++i) {
            int size = sizeEncoding.read(in);
            RCTuple tuple = new RCTuple();
            for (int j = 0; j < size; ++j) {
                tuple.pos.add(posEncoding.read(in));
                tuple.RCs.add(rcEncoding.read(in));
            }
            state.tuples[i] = tuple;
            state.tupleEnergies[i] = in.readDouble();
        }
        state.tupleEnergyOffset = in.readDouble();
        return state;
    }

    private static void writeV1(LUTEState state, DataOutput out) throws IOException {
        int maxSize = 0;
        int maxPos = 0;
        int maxRC = 0;
        for (RCTuple tuple : state.tuples) {
            maxSize = Math.max(maxSize, tuple.size());
            for (int i = 0; i < tuple.size(); ++i) {
                maxPos = Math.max(maxPos, tuple.pos.get(i));
                maxRC = Math.max(maxRC, tuple.RCs.get(i));
            }
        }
        IntEncoding sizeEncoding = IntEncoding.get(maxSize);
        IntEncoding posEncoding = IntEncoding.get(maxPos);
        IntEncoding rcEncoding = IntEncoding.get(maxRC);
        out.writeByte(sizeEncoding.ordinal());
        out.writeByte(posEncoding.ordinal());
        out.writeByte(rcEncoding.ordinal());
        out.writeInt(state.tuples.length);
        for (int i = 0; i < state.tuples.length; ++i) {
            RCTuple tuple = state.tuples[i];
            sizeEncoding.write(out, tuple.size());
            for (int j = 0; j < tuple.size(); ++j) {
                posEncoding.write(out, (int)tuple.pos.get(j));
                rcEncoding.write(out, (int)tuple.RCs.get(j));
            }
            out.writeDouble(state.tupleEnergies[i]);
        }
        out.writeDouble(state.tupleEnergyOffset);
    }
}

