/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pruning;

import edu.duke.cs.osprey.astar.comets.UpdatedPruningMatrix;
import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import edu.duke.cs.osprey.kstar.pruning.ReducedPruningMatrix;

public class UnprunedPruningMatrix
extends ReducedPruningMatrix {
    public UnprunedPruningMatrix(KSSearchProblem sp, UpdatedPruningMatrix upm, double pruningInterval) {
        super(sp, upm);
        this.setPruningInterval(pruningInterval);
    }

    @Override
    public Boolean getOneBody(int res, int index) {
        Integer pos = this.sp.posNums.get(res);
        String rcAAType = this.sp.confSpace.posFlex.get((int)pos.intValue()).RCs.get((int)index).AAType;
        if (this.sp.reducedAllowedAAs.get(res).contains(rcAAType)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean getPairwise(int res1, int index1, int res2, int index2) {
        Integer pos1 = this.sp.posNums.get(res1);
        Integer pos2 = this.sp.posNums.get(res2);
        String rcAAType1 = this.sp.confSpace.posFlex.get((int)pos1.intValue()).RCs.get((int)index1).AAType;
        String rcAAType2 = this.sp.confSpace.posFlex.get((int)pos2.intValue()).RCs.get((int)index2).AAType;
        if (this.sp.reducedAllowedAAs.get(res1).contains(rcAAType1) && this.sp.reducedAllowedAAs.get(res2).contains(rcAAType2)) {
            return false;
        }
        return true;
    }

    @Override
    public HigherTupleFinder<Boolean> getHigherOrderTerms(int res1, int index1, int res2, int index2) {
        Integer pos1 = this.sp.posNums.get(res1);
        Integer pos2 = this.sp.posNums.get(res2);
        String rcAAType1 = this.sp.confSpace.posFlex.get((int)pos1.intValue()).RCs.get((int)index1).AAType;
        String rcAAType2 = this.sp.confSpace.posFlex.get((int)pos2.intValue()).RCs.get((int)index2).AAType;
        if (this.sp.reducedAllowedAAs.get(res1).contains(rcAAType1) && this.sp.reducedAllowedAAs.get(res2).contains(rcAAType2)) {
            return this.upm.getHigherOrderTerms(pos1, index1, pos2, index2);
        }
        return null;
    }
}

