/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pruning;

import edu.duke.cs.osprey.astar.comets.UpdatedPruningMatrix;
import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import edu.duke.cs.osprey.pruning.PruningMatrix;

public class ReducedPruningMatrix
extends PruningMatrix {
    protected UpdatedPruningMatrix upm;
    protected KSSearchProblem sp;

    public ReducedPruningMatrix(KSSearchProblem sp) {
        this.upm = new UpdatedPruningMatrix(sp.pruneMat);
        this.sp = sp;
        this.setPruningInterval(sp.pruneMat.getPruningInterval());
    }

    public ReducedPruningMatrix(KSSearchProblem sp, UpdatedPruningMatrix upm) {
        this.sp = sp;
        this.upm = upm;
        this.setPruningInterval(sp.pruneMat.getPruningInterval());
    }

    public UpdatedPruningMatrix getUpdatedPruningMatrix() {
        return this.upm;
    }

    @Override
    public Boolean getOneBody(int res, int index) {
        Integer pos = this.sp.posNums.get(res);
        return this.upm.getOneBody(pos, index);
    }

    @Override
    public Boolean getPairwise(int res1, int index1, int res2, int index2) {
        Integer pos1 = this.sp.posNums.get(res1);
        Integer pos2 = this.sp.posNums.get(res2);
        return this.upm.getPairwise(pos1, index1, pos2, index2);
    }

    @Override
    public HigherTupleFinder<Boolean> getHigherOrderTerms(int res1, int index1, int res2, int index2) {
        Integer pos1 = this.sp.posNums.get(res1);
        Integer pos2 = this.sp.posNums.get(res2);
        return this.upm.getHigherOrderTerms(pos1, index1, pos2, index2);
    }

    @Override
    public int getNumConfAtPos(int pos) {
        Integer pos1 = this.sp.posNums.get(pos);
        return this.sp.pruneMat.getNumConfAtPos(pos1);
    }

    @Override
    public int getNumPos() {
        return this.sp.posNums.size();
    }

    public int countUpdates() {
        return this.upm.countUpdates();
    }
}

