/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.handlempi;

import edu.duke.cs.osprey.handlempi.MPISlaveTask;
import java.util.ArrayList;

public class MPIMaster {
    static int processRank = 0;

    private MPIMaster() {
    }

    public static void printIfMaster(String output) {
        if (processRank == 0) {
            System.out.println(output);
        }
    }

    public static MPIMaster getInstance() {
        if (processRank > 0) {
            throw new RuntimeException("ERROR: Slave nodes can't get the MPIMaster instance");
        }
        return MPIMasterHolder.INSTANCE;
    }

    public ArrayList<Object> handleTasks(ArrayList<MPISlaveTask> tasks) {
        ArrayList<Object> ans = new ArrayList<Object>();
        for (MPISlaveTask task : tasks) {
            ans.add(task.doCalculation());
        }
        return ans;
    }

    private static class MPIMasterHolder {
        private static final MPIMaster INSTANCE = new MPIMaster();

        private MPIMasterHolder() {
        }
    }
}

