/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.prep;

import edu.duke.cs.osprey.gui.io.ConfLib;
import edu.duke.cs.osprey.gui.prep.Anchor;
import edu.duke.cs.osprey.gui.prep.Assignments;
import edu.duke.cs.osprey.gui.prep.DesignPosition;
import edu.duke.cs.osprey.gui.prep.IllegalAlignmentException;
import edu.duke.cs.osprey.gui.tools.UnsupportedClassException;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.MoleculeKt;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0012R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001e\u0010$\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Ledu/duke/cs/osprey/gui/prep/ConfSwitcher;", "", "pos", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "molInfo", "Ledu/duke/cs/osprey/gui/prep/Assignments$MolInfo;", "(Ledu/duke/cs/osprey/gui/prep/DesignPosition;Ledu/duke/cs/osprey/gui/prep/Assignments$MolInfo;)V", "<set-?>", "Ledu/duke/cs/osprey/gui/prep/DesignPosition$AnchorMatch;", "anchorMatch", "getAnchorMatch", "()Ledu/duke/cs/osprey/gui/prep/DesignPosition$AnchorMatch;", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer$Resolver;", "atomResolver", "getAtomResolver", "()Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer$Resolver;", "atomResolverOrThrow", "getAtomResolverOrThrow", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "conf", "getConf", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "currentAtoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getCurrentAtoms", "()Ljava/util/Set;", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "frag", "getFrag", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "getMolInfo", "()Ledu/duke/cs/osprey/gui/prep/Assignments$MolInfo;", "getPos", "()Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "", "type", "getType", "()Ljava/lang/String;", "setConf", "", "IllegalConformationException", "osprey3"})
@SourceDebugExtension(value={"SMAP\nConfSwitcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfSwitcher.kt\nedu/duke/cs/osprey/gui/prep/ConfSwitcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1549#2:155\n1620#2,3:156\n*S KotlinDebug\n*F\n+ 1 ConfSwitcher.kt\nedu/duke/cs/osprey/gui/prep/ConfSwitcher\n*L\n21#1:155\n21#1:156,3\n*E\n"})
public final class ConfSwitcher {
    @NotNull
    private final DesignPosition pos;
    @NotNull
    private final Assignments.MolInfo molInfo;
    @NotNull
    private final Set<Atom> currentAtoms;
    @NotNull
    private String type;
    @Nullable
    private ConfLib.Fragment frag;
    @Nullable
    private ConfLib.Conf conf;
    @Nullable
    private DesignPosition.AnchorMatch anchorMatch;
    @Nullable
    private ConfLib.AtomPointer.Resolver atomResolver;

    /*
     * WARNING - void declaration
     */
    public ConfSwitcher(@NotNull DesignPosition pos, @NotNull Assignments.MolInfo molInfo) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)molInfo, (String)"molInfo");
        this.pos = pos;
        this.molInfo = molInfo;
        Iterable iterable = this.pos.getSourceAtoms();
        ConfSwitcher confSwitcher = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Atom atom = (Atom)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.molInfo.getAssignedAtomOrThrow((Atom)it));
        }
        confSwitcher.currentAtoms = MoleculeKt.toIdentitySet((List)destination$iv$iv);
        this.type = this.pos.getType();
    }

    @NotNull
    public final DesignPosition getPos() {
        return this.pos;
    }

    @NotNull
    public final Assignments.MolInfo getMolInfo() {
        return this.molInfo;
    }

    @NotNull
    public final Set<Atom> getCurrentAtoms() {
        return this.currentAtoms;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @Nullable
    public final ConfLib.Fragment getFrag() {
        return this.frag;
    }

    @Nullable
    public final ConfLib.Conf getConf() {
        return this.conf;
    }

    @Nullable
    public final DesignPosition.AnchorMatch getAnchorMatch() {
        return this.anchorMatch;
    }

    @Nullable
    public final ConfLib.AtomPointer.Resolver getAtomResolver() {
        return this.atomResolver;
    }

    @NotNull
    public final ConfLib.AtomPointer.Resolver getAtomResolverOrThrow() {
        ConfLib.AtomPointer.Resolver resolver = this.atomResolver;
        if (resolver == null) {
            throw new NoSuchElementException("design position currently has no atom resolver");
        }
        return resolver;
    }

    public final void setConf(@NotNull ConfLib.Fragment frag, @NotNull ConfLib.Conf conf) {
        ConfLib.Anchor fragAnchor;
        Anchor posAnchor;
        DesignPosition.AnchorMatch anchorMatch;
        DesignPosition.AnchorMatch anchorMatch2;
        Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.frag = frag;
        this.conf = conf;
        DesignPosition.AnchorMatch anchorMatch3 = this.pos.findAnchorMatch(frag);
        if (anchorMatch3 == null || (anchorMatch2 = anchorMatch3.copyToMol(this.molInfo.getAssignedMol(), this.molInfo.getMaps().getAtoms())) == null) {
            throw new DesignPosition.IncompatibleAnchorsException(this.pos, frag);
        }
        this.anchorMatch = anchorMatch = anchorMatch2;
        for (Atom atom : this.currentAtoms) {
            Object object;
            this.molInfo.getAssignedMol().getAtoms().remove(atom);
            if (this.molInfo.getAssignedMol() instanceof Polymer && (object = ((Polymer)this.molInfo.getAssignedMol()).findResidue(atom)) != null && (object = ((Polymer.Residue)object).getAtoms()) != null) {
                object.remove(atom);
            }
            this.molInfo.getMaps().getAtoms().removeB(atom);
        }
        this.currentAtoms.clear();
        this.type = frag.getType();
        IdentityHashMap<ConfLib.AtomInfo, Atom> atomsByInfo = new IdentityHashMap<ConfLib.AtomInfo, Atom>();
        for (Pair<Anchor, ConfLib.Anchor> pair : anchorMatch.getPairs()) {
            Polymer.Residue res;
            posAnchor = (Anchor)pair.component1();
            fragAnchor = (ConfLib.Anchor)pair.component2();
            Polymer.Residue residue = res = posAnchor.findResidue();
            if (residue != null) {
                residue.setType(frag.getType());
            }
            for (ConfLib.AtomInfo atomInfo : frag.getAtomsFor(fragAnchor)) {
                Atom atom = new Atom(atomInfo.getElement(), atomInfo.getName(), new Vector3d((Vector3dc)conf.getCoords().get(atomInfo)));
                ((Map)atomsByInfo).put(atomInfo, atom);
                this.molInfo.getAssignedMol().getAtoms().add(atom);
                Object object = res;
                if (object != null && (object = ((Polymer.Residue)object).getAtoms()) != null) {
                    object.add(atom);
                }
                this.currentAtoms.add(atom);
            }
        }
        for (ConfLib.Bond bond : frag.getBonds()) {
            Atom atoma = (Atom)MapsKt.getValue((Map)atomsByInfo, (Object)bond.getA());
            Atom atomb = (Atom)MapsKt.getValue((Map)atomsByInfo, (Object)bond.getB());
            Molecule.Bonds bonds2 = this.molInfo.getAssignedMol().getBonds();
            Intrinsics.checkNotNullExpressionValue((Object)atoma, (String)"atoma");
            Intrinsics.checkNotNullExpressionValue((Object)atomb, (String)"atomb");
            bonds2.add(atoma, atomb);
        }
        try {
            for (Pair<Anchor, ConfLib.Anchor> pair : anchorMatch.getPairs()) {
                posAnchor = (Anchor)pair.component1();
                fragAnchor = (ConfLib.Anchor)pair.component2();
                posAnchor.bondToAnchors(fragAnchor, (Function2<? super List<ConfLib.AtomInfo>, ? super Atom, Unit>)((Function2)new Function2<List<? extends ConfLib.AtomInfo>, Atom, Unit>(atomsByInfo, this){
                    final /* synthetic */ IdentityHashMap<ConfLib.AtomInfo, Atom> $atomsByInfo;
                    final /* synthetic */ ConfSwitcher this$0;
                    {
                        this.$atomsByInfo = $atomsByInfo;
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull List<ConfLib.AtomInfo> atomInfos, @NotNull Atom anchorAtom) {
                        Intrinsics.checkNotNullParameter(atomInfos, (String)"atomInfos");
                        Intrinsics.checkNotNullParameter((Object)anchorAtom, (String)"anchorAtom");
                        for (ConfLib.AtomInfo bondedInfo : atomInfos) {
                            Atom atom = (Atom)MapsKt.getValue((Map)this.$atomsByInfo, (Object)bondedInfo);
                            Molecule.Bonds bonds2 = this.this$0.getMolInfo().getAssignedMol().getBonds();
                            Intrinsics.checkNotNullExpressionValue((Object)atom, (String)"atom");
                            bonds2.add(anchorAtom, atom);
                        }
                    }
                }));
                posAnchor.align(this.currentAtoms, (ConfLib.AnchorCoords)MapsKt.getValue(conf.getAnchorCoords(), (Object)fragAnchor));
            }
        }
        catch (IllegalAlignmentException illegalAlignmentException) {
            throw new IllegalConformationException(this, frag, conf, "Can't set conformation, bad alignment", illegalAlignmentException);
        }
        this.atomResolver = new ConfLib.AtomPointer.Resolver(atomsByInfo, anchorMatch){
            final /* synthetic */ IdentityHashMap<ConfLib.AtomInfo, Atom> $atomsByInfo;
            final /* synthetic */ DesignPosition.AnchorMatch $anchorMatch;
            {
                this.$atomsByInfo = $atomsByInfo;
                this.$anchorMatch = $anchorMatch;
            }

            @Nullable
            public Atom resolve(@NotNull ConfLib.AtomPointer p) {
                Atom atom;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                ConfLib.AtomPointer atomPointer = p;
                if (atomPointer instanceof ConfLib.AtomInfo) {
                    atom = this.$atomsByInfo.get(p);
                } else if (atomPointer instanceof ConfLib.AnchorAtomPointer) {
                    List<Atom> list;
                    Anchor anchor = this.$anchorMatch.findPosAnchor(((ConfLib.AnchorAtomPointer)p).getAnchor());
                    atom = anchor != null && (list = anchor.getAnchorAtoms()) != null ? list.get(((ConfLib.AnchorAtomPointer)p).getIndex()) : null;
                } else {
                    throw new UnsupportedClassException("unrecognized atom pointer type", p);
                }
                return atom;
            }

            @NotNull
            public Atom resolveOrThrow(@NotNull ConfLib.AtomPointer p) {
                return ConfLib.AtomPointer.Resolver.DefaultImpls.resolveOrThrow(this, p);
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\u0018\u00002\u00060\u0001j\u0002`\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ledu/duke/cs/osprey/gui/prep/ConfSwitcher$IllegalConformationException;", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "switcher", "Ledu/duke/cs/osprey/gui/prep/ConfSwitcher;", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "conf", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "msg", "", "cause", "", "(Ledu/duke/cs/osprey/gui/prep/ConfSwitcher;Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;Ljava/lang/String;Ljava/lang/Throwable;)V", "getConf", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "getFrag", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "getSwitcher", "()Ledu/duke/cs/osprey/gui/prep/ConfSwitcher;", "osprey3"})
    public static final class IllegalConformationException
    extends IllegalArgumentException {
        @NotNull
        private final ConfSwitcher switcher;
        @NotNull
        private final ConfLib.Fragment frag;
        @NotNull
        private final ConfLib.Conf conf;

        public IllegalConformationException(@NotNull ConfSwitcher switcher, @NotNull ConfLib.Fragment frag, @NotNull ConfLib.Conf conf, @NotNull String msg, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)switcher, (String)"switcher");
            Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super("Design position " + switcher.getPos().getName() + " can't set conformation:\n\tfragment = " + frag.getId() + "\n\tconformation = " + conf.getId() + "\n" + msg, cause);
            this.switcher = switcher;
            this.frag = frag;
            this.conf = conf;
        }

        public /* synthetic */ IllegalConformationException(ConfSwitcher confSwitcher, ConfLib.Fragment fragment, ConfLib.Conf conf, String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                throwable = null;
            }
            this(confSwitcher, fragment, conf, string, throwable);
        }

        @NotNull
        public final ConfSwitcher getSwitcher() {
            return this.switcher;
        }

        @NotNull
        public final ConfLib.Fragment getFrag() {
            return this.frag;
        }

        @NotNull
        public final ConfLib.Conf getConf() {
            return this.conf;
        }
    }
}

