/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.io;

import edu.duke.cs.osprey.gui.io.OMOLKt;
import edu.duke.cs.osprey.gui.io.OMOLMapped;
import edu.duke.cs.osprey.gui.io.TomlKt;
import edu.duke.cs.osprey.gui.io.TomlParseException;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.AtomPair;
import edu.duke.cs.osprey.molscope.molecule.Element;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlPosition;
import org.tomlj.TomlTable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0001\u001a\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\b\u001a\u00020\u0001\u001a:\u0010\u000b\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f0\u0003*\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\b\u001a\u00020\u0001\u001a\f\u0010\u0010\u001a\u00020\u0007*\u00020\u0007H\u0002\u001a\n\u0010\u0011\u001a\u00020\u0007*\u00020\u0004\u001a\u0010\u0010\u0011\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u001a\u0010\u0012\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"DefaultThrowOnMissingAtoms", "", "fromOMOL", "", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "Ledu/duke/cs/osprey/molscope/molecule/Molecule$Companion;", "toml", "", "throwOnMissingAtoms", "doc", "Lorg/tomlj/TomlParseResult;", "fromOMOLWithAtoms", "Lkotlin/Pair;", "", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "quote", "toOMOL", "toOMOLMapped", "Ledu/duke/cs/osprey/gui/io/OMOLMapped;", "flattenAtomIndices", "osprey3"})
@SourceDebugExtension(value={"SMAP\nOMOL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OMOL.kt\nedu/duke/cs/osprey/gui/io/OMOLKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n1864#2,2:276\n1549#2:278\n1620#2,3:279\n1866#2:282\n1549#2:284\n1620#2,3:285\n1549#2:288\n1620#2,3:289\n1603#2,9:292\n1855#2:301\n1856#2:303\n1612#2:304\n1#3:283\n1#3:302\n*S KotlinDebug\n*F\n+ 1 OMOL.kt\nedu/duke/cs/osprey/gui/io/OMOLKt\n*L\n36#1:276,2\n105#1:278\n105#1:279,3\n36#1:282\n152#1:284\n152#1:285,3\n161#1:288\n161#1:289,3\n264#1:292,9\n264#1:301\n264#1:303\n264#1:304\n264#1:302\n*E\n"})
public final class OMOLKt {
    private static final boolean DefaultThrowOnMissingAtoms = true;

    @NotNull
    public static final String toOMOL(@NotNull List<? extends Molecule> $this$toOMOL) {
        Intrinsics.checkNotNullParameter($this$toOMOL, (String)"<this>");
        return OMOLKt.toOMOLMapped$default($this$toOMOL, false, 1, null).getToml();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final OMOLMapped toOMOLMapped(@NotNull List<? extends Molecule> $this$toOMOLMapped, boolean flattenAtomIndices) {
        Intrinsics.checkNotNullParameter($this$toOMOLMapped, (String)"<this>");
        StringBuilder buf = new StringBuilder();
        HashMap indicesByAtom = new HashMap();
        Iterable $this$forEachIndexed$iv = $this$toOMOLMapped;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object object;
            void mol;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Molecule molecule = (Molecule)item$iv;
            int moli = n;
            boolean bl = false;
            if (moli > 0) {
                OMOLKt.toOMOLMapped$write(buf, "\n", new Object[0]);
            }
            OMOLKt.toOMOLMapped$write(buf, "[molecule." + moli + "]\n", new Object[0]);
            Object[] objectArray = new Object[]{OMOLKt.quote(mol.getName())};
            OMOLKt.toOMOLMapped$write(buf, "name = %s\n", objectArray);
            if (mol.getType() != null) {
                String type;
                boolean bl2 = false;
                object = new Object[]{OMOLKt.quote(type)};
                OMOLKt.toOMOLMapped$write(buf, "type = %s\n", object);
            }
            Integer n2 = mol.getNetCharge();
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                object = new Object[]{it};
                OMOLKt.toOMOLMapped$write(buf, "netCharge = %d\n", object);
            }
            OMOLKt.toOMOLMapped$write(buf, "\n", new Object[0]);
            OMOLKt.toOMOLMapped$write(buf, "atoms = [\n", new Object[0]);
            int atomi = flattenAtomIndices ? indicesByAtom.size() : 0;
            for (Atom atom : mol.getAtoms()) {
                Object[] bl3 = new Object[]{atomi, OMOLKt.quote(atom.getName()), atom.getPos().x, atom.getPos().y, atom.getPos().z, OMOLKt.quote(atom.getElement().getSymbol())};
                OMOLKt.toOMOLMapped$write(buf, "\t{ i=%5d, name=%7s, x=%12.6f, y=%12.6f, z=%12.6f, elem=%3s },\n", bl3);
                object = atomi;
                ((Map)indicesByAtom).put(atom, object);
                ++atomi;
            }
            OMOLKt.toOMOLMapped$write(buf, "]\n", new Object[0]);
            OMOLKt.toOMOLMapped$write(buf, "\n", new Object[0]);
            OMOLKt.toOMOLMapped$write(buf, "bonds = [\n", new Object[0]);
            for (AtomPair atom : mol.getBonds().toSet()) {
                Atom a1 = atom.component1();
                Atom a2 = atom.component2();
                Object v = indicesByAtom.get(a1);
                Intrinsics.checkNotNull(v);
                int i1 = ((Number)v).intValue();
                Object v2 = indicesByAtom.get(a2);
                Intrinsics.checkNotNull(v2);
                int i2 = ((Number)v2).intValue();
                Object[] objectArray2 = new Object[]{i1, i2, a1.getName(), a2.getName()};
                OMOLKt.toOMOLMapped$write(buf, "\t[%5d,%5d], # %6s - %-6s\n", objectArray2);
            }
            OMOLKt.toOMOLMapped$write(buf, "]\n", new Object[0]);
            if (!(mol instanceof Polymer)) continue;
            OMOLKt.toOMOLMapped$write(buf, "\n", new Object[0]);
            OMOLKt.toOMOLMapped$write(buf, "[molecule." + moli + ".polymer]\n", new Object[0]);
            for (Polymer.Chain chain : ((Polymer)mol).getChains()) {
                Object[] objectArray3 = new Object[]{OMOLKt.quote(chain.getId())};
                OMOLKt.toOMOLMapped$write(buf, "%s = [\n", objectArray3);
                for (Polymer.Residue res : chain.getResidues()) {
                    Collection<Integer> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Object[] objectArray4 = new Object[3];
                    objectArray4[0] = OMOLKt.quote(res.getId());
                    objectArray4[1] = OMOLKt.quote(res.getType());
                    Iterable i2 = res.getAtoms();
                    int n3 = 2;
                    Object[] objectArray5 = objectArray4;
                    String string = "\t{ id=%7s, type=%6s, atoms=[%s] },\n";
                    StringBuilder stringBuilder = buf;
                    boolean $i$f$map = false;
                    void var25_36 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void atom;
                        Atom atom2 = (Atom)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add((Integer)indicesByAtom.get(atom));
                    }
                    collection = (List)destination$iv$iv;
                    objectArray5[n3] = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, (Function1)toOMOLMapped.1.4.INSTANCE, (int)30, null);
                    OMOLKt.toOMOLMapped$write(stringBuilder, string, objectArray4);
                }
                OMOLKt.toOMOLMapped$write(buf, "]\n", new Object[0]);
            }
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return new OMOLMapped(string, indicesByAtom);
    }

    public static /* synthetic */ OMOLMapped toOMOLMapped$default(List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return OMOLKt.toOMOLMapped(list, bl);
    }

    @NotNull
    public static final String toOMOL(@NotNull Molecule $this$toOMOL) {
        Intrinsics.checkNotNullParameter((Object)$this$toOMOL, (String)"<this>");
        return OMOLKt.toOMOL(CollectionsKt.listOf((Object)$this$toOMOL));
    }

    private static final String quote(String $this$quote) {
        String str = StringsKt.replace$default((String)StringsKt.replace$default((String)$this$quote, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        boolean bl = false;
        return "\"" + str + "\"";
    }

    @NotNull
    public static final List<Molecule> fromOMOL(@NotNull Molecule.Companion $this$fromOMOL, @NotNull String toml, boolean throwOnMissingAtoms) {
        Intrinsics.checkNotNullParameter((Object)$this$fromOMOL, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toml, (String)"toml");
        TomlParseResult doc = Toml.parse((String)toml);
        if (doc.hasErrors()) {
            List list = doc.errors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"doc.errors()");
            throw new TomlParseException("TOML parsing failure:\n" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, 2, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
        return OMOLKt.fromOMOL($this$fromOMOL, doc, throwOnMissingAtoms);
    }

    public static /* synthetic */ List fromOMOL$default(Molecule.Companion companion, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return OMOLKt.fromOMOL(companion, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Molecule> fromOMOL(@NotNull Molecule.Companion $this$fromOMOL, @NotNull TomlParseResult doc, boolean throwOnMissingAtoms) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$fromOMOL, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Iterable $this$map$iv = OMOLKt.fromOMOLWithAtoms($this$fromOMOL, doc, throwOnMissingAtoms);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Molecule mol = (Molecule)pair.component1();
            collection.add(mol);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List fromOMOL$default(Molecule.Companion companion, TomlParseResult tomlParseResult, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return OMOLKt.fromOMOL(companion, tomlParseResult, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<Molecule, Map<Integer, Atom>>> fromOMOLWithAtoms(@NotNull Molecule.Companion $this$fromOMOLWithAtoms, @NotNull TomlParseResult doc, boolean throwOnMissingAtoms) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$fromOMOLWithAtoms, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        TomlTable molsTable = TomlKt.getTableOrThrow$default((TomlTable)doc, "molecule", null, 2, null);
        Set set = molsTable.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"molsTable.keySet()");
        Iterable iterable = set;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Integer n = StringsKt.toIntOrNull((String)it);
            if (n == null) {
                throw new TomlParseException("molecule index " + (String)it + " is not a number", null, 2, null);
            }
            collection.add(Integer.valueOf(n));
        }
        List molIndices = (List)destination$iv$iv;
        ArrayList<Pair> out = new ArrayList<Pair>();
        Iterator iterator2 = molIndices.iterator();
        while (iterator2.hasNext()) {
            TomlTable polymerTable;
            TomlTable molTable;
            int moli = ((Number)iterator2.next()).intValue();
            Intrinsics.checkNotNull((Object)molsTable.getTable(String.valueOf(moli)));
            String name = TomlKt.getStringOrThrow$default(molTable, "name", null, 2, null);
            String type = molTable.getString("type");
            Molecule mol = molTable.contains("polymer") ? (Molecule)new Polymer(name) : new Molecule(name, type, null, 4, null);
            mol.setNetCharge(TomlKt.getInt(molTable, "netCharge"));
            HashMap atoms = new HashMap();
            out.add(TuplesKt.to((Object)mol, atoms));
            TomlArray atomsArray = TomlKt.getArrayOrThrow$default(molTable, "atoms", null, 2, null);
            if (!atomsArray.containsTables()) {
                throw new TomlParseException("atoms does not contain tables", molTable.inputPositionOf("atoms"));
            }
            int n = atomsArray.size();
            for (int i = 0; i < n; ++i) {
                TomlTable atomTable = atomsArray.getTable(i);
                TomlPosition pos = atomsArray.inputPositionOf(i);
                Intrinsics.checkNotNullExpressionValue((Object)atomTable, (String)"atomTable");
                Atom atom = new Atom(Element.Companion.get(TomlKt.getStringOrThrow(atomTable, "elem", pos)), TomlKt.getStringOrThrow(atomTable, "name", pos), TomlKt.getDoubleOrThrow(atomTable, "x", pos), TomlKt.getDoubleOrThrow(atomTable, "y", pos), TomlKt.getDoubleOrThrow(atomTable, "z", pos));
                mol.getAtoms().add(atom);
                int index = TomlKt.getIntOrThrow(atomTable, "i", pos);
                Object object = index;
                if (((Map)atoms).containsKey(object)) {
                    throw new TomlParseException("duplicate atom index: " + i, pos);
                }
                object = index;
                ((Map)atoms).put(object, atom);
            }
            TomlArray bondsArray = TomlKt.getArrayOrThrow$default(molTable, "bonds", null, 2, null);
            if (!bondsArray.containsArrays()) {
                throw new TomlParseException("bonds does not contain arrays", molTable.inputPositionOf("bonds"));
            }
            int n2 = bondsArray.size();
            for (int i = 0; i < n2; ++i) {
                Atom a2;
                Atom a1;
                TomlArray bondArray = bondsArray.getArray(i);
                TomlPosition pos = bondsArray.inputPositionOf(i);
                if (!bondArray.containsLongs()) {
                    throw new TomlParseException("bond does not contain integers", pos);
                }
                if (OMOLKt.fromOMOLWithAtoms$getAtom$default(atoms, throwOnMissingAtoms, (int)bondArray.getLong(0), null, 8, null) == null || OMOLKt.fromOMOLWithAtoms$getAtom$default(atoms, throwOnMissingAtoms, (int)bondArray.getLong(1), null, 8, null) == null) continue;
                mol.getBonds().add(a1, a2);
            }
            if (molTable.getTable("polymer") == null) continue;
            boolean bl = false;
            Polymer polymer = (Polymer)mol;
            TomlPosition pos = molTable.inputPositionOf("polymer");
            for (String chainId : polymerTable.keySet()) {
                Polymer.Chain chain;
                Intrinsics.checkNotNullExpressionValue((Object)chainId, (String)"chainId");
                TomlArray chainArray = TomlKt.getArrayOrThrow(polymerTable, chainId, pos);
                if (!chainArray.containsTables()) {
                    throw new TomlParseException("chain does not contain tables", pos);
                }
                Polymer.Chain chain2 = chain = new Polymer.Chain(chainId);
                List<Polymer.Chain> list = polymer.getChains();
                boolean bl2 = false;
                int n3 = chainArray.size();
                for (int i = 0; i < n3; ++i) {
                    void $this$mapNotNullTo$iv$iv;
                    void resAtomsArray;
                    void chain3;
                    TomlTable residueTable = chainArray.getTable(i);
                    TomlPosition resPos = chainArray.inputPositionOf(i);
                    List<Polymer.Residue> list2 = chain3.getResidues();
                    Intrinsics.checkNotNullExpressionValue((Object)residueTable, (String)"residueTable");
                    TomlArray tomlArray = TomlKt.getArrayOrThrow(residueTable, "atoms", resPos);
                    String string = TomlKt.getStringOrThrow(residueTable, "type", resPos);
                    String string2 = TomlKt.getStringOrThrow(residueTable, "id", resPos);
                    List<Polymer.Residue> list3 = list2;
                    boolean bl3 = false;
                    if (!resAtomsArray.containsLongs()) {
                        throw new TomlParseException("field \"atoms\" doesn't contain integers", resPos);
                    }
                    Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)resAtomsArray.size());
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator3.hasNext()) {
                        Atom it$iv$iv;
                        int element$iv$iv$iv;
                        int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator3).nextInt();
                        boolean bl4 = false;
                        int it = element$iv$iv;
                        boolean bl5 = false;
                        if (OMOLKt.fromOMOLWithAtoms$getAtom$default(atoms, throwOnMissingAtoms, (int)resAtomsArray.getLong(it), null, 8, null) == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    List list4 = (List)destination$iv$iv2;
                    List list5 = list4;
                    String string3 = string;
                    String string4 = string2;
                    list3.add(new Polymer.Residue(string4, string3, list5));
                }
                list.add(chain);
            }
        }
        return out;
    }

    public static /* synthetic */ List fromOMOLWithAtoms$default(Molecule.Companion companion, TomlParseResult tomlParseResult, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return OMOLKt.fromOMOLWithAtoms(companion, tomlParseResult, bl);
    }

    private static final StringBuilder toOMOLMapped$write(StringBuilder buf, String str, Object ... args) {
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(str, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
        return buf.append(string);
    }

    private static final Atom fromOMOLWithAtoms$getAtom(HashMap<Integer, Atom> atoms, boolean $throwOnMissingAtoms, int i, TomlPosition pos) {
        Atom atom = atoms.get(i);
        if (atom == null) {
            if ($throwOnMissingAtoms) {
                throw new TomlParseException("atom not found at index " + i, pos);
            }
            atom = null;
        }
        return atom;
    }

    static /* synthetic */ Atom fromOMOLWithAtoms$getAtom$default(HashMap hashMap, boolean bl, int n, TomlPosition tomlPosition, int n2, Object object) {
        if ((n2 & 8) != 0) {
            tomlPosition = null;
        }
        return OMOLKt.fromOMOLWithAtoms$getAtom(hashMap, bl, n, tomlPosition);
    }
}

