/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.io;

import edu.duke.cs.osprey.gui.io.MOL2Kt;
import edu.duke.cs.osprey.gui.io.Mol2Metadata;
import edu.duke.cs.osprey.gui.io.Mol2ParseException;
import edu.duke.cs.osprey.gui.io.Section;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.AtomPair;
import edu.duke.cs.osprey.molscope.molecule.Element;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u001a#\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a/\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\t*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000b\u001a\u0016\u0010\f\u001a\u00020\u0004*\u00020\u00012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n\u001a\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f*\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"fromMol2", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "Ledu/duke/cs/osprey/molscope/molecule/Molecule$Companion;", "mol2", "", "isPolymer", "", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule$Companion;Ljava/lang/String;Ljava/lang/Boolean;)Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "fromMol2WithMetadata", "Lkotlin/Pair;", "Ledu/duke/cs/osprey/gui/io/Mol2Metadata;", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule$Companion;Ljava/lang/String;Ljava/lang/Boolean;)Lkotlin/Pair;", "toMol2", "metadata", "tokenize", "", "osprey3"})
@SourceDebugExtension(value={"SMAP\nMOL2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MOL2.kt\nedu/duke/cs/osprey/gui/io/MOL2Kt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,420:1\n1864#2,3:421\n1864#2,3:425\n766#2:428\n857#2,2:429\n1#3:424\n*S KotlinDebug\n*F\n+ 1 MOL2.kt\nedu/duke/cs/osprey/gui/io/MOL2Kt\n*L\n88#1:421,3\n178#1:425,3\n401#1:428\n401#1:429,2\n*E\n"})
public final class MOL2Kt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toMol2(@NotNull Molecule $this$toMol2, @Nullable Mol2Metadata metadata) {
        Object it2;
        int n;
        Object $this$toMol2_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)$this$toMol2, (String)"<this>");
        Molecule mol = $this$toMol2;
        StringBuffer buf = new StringBuffer();
        Polymer.Residue smallMoleculeRes = null;
        List chains = null;
        if (mol instanceof Polymer) {
            smallMoleculeRes = null;
            chains = ((Polymer)mol).getChains();
        } else {
            String string = mol.getType();
            if (string == null) {
                string = "MOL";
            }
            smallMoleculeRes = new Polymer.Residue("1", string, mol.getAtoms());
            Polymer.Chain chain = new Polymer.Chain("A");
            $this$toMol2_u24lambda_u240 = chain;
            boolean bl = false;
            ((Polymer.Chain)$this$toMol2_u24lambda_u240).getResidues().add(smallMoleculeRes);
            chains = CollectionsKt.listOf((Object)chain);
        }
        $this$toMol2_u24lambda_u240 = new IdentityHashMap<Atom, Polymer.Residue>();
        IdentityHashMap<Atom, Polymer.Residue> $this$toMol2_u24lambda_u241 = $this$toMol2_u24lambda_u240;
        boolean bl = false;
        int i = 1;
        for (Iterator chain : chains) {
            for (Polymer.Residue res : ((Polymer.Chain)((Object)chain)).getResidues()) {
                $this$toMol2_u24lambda_u241.put((Atom)((Object)res), (Polymer.Residue)((Object)Integer.valueOf(i)));
                ++i;
            }
        }
        Object resIds = $this$toMol2_u24lambda_u240;
        IdentityHashMap<Atom, Polymer.Residue> $this$toMol2_u24lambda_u242 = $this$toMol2_u24lambda_u241 = new IdentityHashMap();
        boolean bl2 = false;
        for (Iterator chain : chains) {
            for (Polymer.Residue res : ((Polymer.Chain)((Object)chain)).getResidues()) {
                for (Atom atom : res.getAtoms()) {
                    $this$toMol2_u24lambda_u242.put(atom, res);
                }
            }
        }
        IdentityHashMap<Atom, Polymer.Residue> residuesByAtom = $this$toMol2_u24lambda_u241;
        IdentityHashMap indicesByAtom = new IdentityHashMap();
        Iterable $this$forEachIndexed$iv = mol.getAtoms();
        boolean $i$f$forEachIndexed22 = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void atom;
            int res;
            if ((res = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Atom atom2 = (Atom)item$iv;
            int i2 = res;
            boolean bl3 = false;
            ((Map)indicesByAtom).put(atom, i2 + 1);
        }
        List bonds2 = CollectionsKt.toList((Iterable)mol.getBonds().toSet());
        MOL2Kt.toMol2$write(buf, "@<TRIPOS>MOLECULE\n", new Object[0]);
        MOL2Kt.toMol2$write(buf, StringsKt.replace$default((String)mol.getName(), (String)"\n", (String)" ", (boolean)false, (int)4, null) + "\n", new Object[0]);
        Iterable $i$f$forEachIndexed22 = chains;
        int n2 = bonds2.size();
        int n3 = mol.getAtoms().size();
        StringBuffer stringBuffer = buf;
        index$iv = 0;
        for (Object item$iv : $i$f$forEachIndexed22) {
            void it2;
            Polymer.Chain res = (Polymer.Chain)item$iv;
            n = index$iv;
            boolean bl4 = false;
            int n4 = it2.getResidues().size();
            index$iv = n + n4;
        }
        n = index$iv;
        MOL2Kt.toMol2$write(stringBuffer, "  " + n3 + " " + n2 + " " + n + "\n", new Object[0]);
        if ($this$toMol2 instanceof Polymer) {
            MOL2Kt.toMol2$write(buf, "BIOPOLYMER\n", new Object[0]);
        } else {
            MOL2Kt.toMol2$write(buf, "SMALL\n", new Object[0]);
        }
        MOL2Kt.toMol2$write(buf, "NO_CHARGES\n", new Object[0]);
        MOL2Kt.toMol2$write(buf, "\n", new Object[0]);
        MOL2Kt.toMol2$write(buf, "\n", new Object[0]);
        Mol2Metadata mol2Metadata = metadata;
        Map<Atom, String> types2 = mol2Metadata != null ? mol2Metadata.getAtomTypes() : null;
        Mol2Metadata mol2Metadata2 = metadata;
        Map<Atom, String> charges = mol2Metadata2 != null ? mol2Metadata2.getAtomCharges() : null;
        DecimalFormat coordsFormat = new DecimalFormat("#.000000");
        try {
            Class<?> $this$toMol2_u24lambda_u246 = Class.forName("java.text.DontCareFieldPosition");
            boolean bl5 = false;
            Field $this$toMol2_u24lambda_u246_u24lambda_u245 = $this$toMol2_u24lambda_u246.getDeclaredField("INSTANCE");
            boolean bl6 = false;
            $this$toMol2_u24lambda_u246_u24lambda_u245.setAccessible(true);
            Object object = $this$toMol2_u24lambda_u246_u24lambda_u245.get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.text.FieldPosition");
            it2 = (FieldPosition)object;
        }
        catch (Throwable t) {
            it2 = null;
        }
        Iterator<Atom> dontCareFieldPosition = it2;
        MOL2Kt.toMol2$write(buf, "@<TRIPOS>ATOM\n", new Object[0]);
        for (Atom atom : $this$toMol2.getAtoms()) {
            Polymer.Residue res = MOL2Kt.toMol2$getResidue(atom, residuesByAtom, mol);
            buf.append(' ');
            buf.append(' ');
            buf.append(indicesByAtom.get(atom));
            buf.append(' ');
            buf.append(atom.getName());
            buf.append(' ');
            MOL2Kt.toMol2$appendCoord(buf, dontCareFieldPosition, coordsFormat, atom.getPos().x);
            buf.append(' ');
            MOL2Kt.toMol2$appendCoord(buf, dontCareFieldPosition, coordsFormat, atom.getPos().y);
            buf.append(' ');
            MOL2Kt.toMol2$appendCoord(buf, dontCareFieldPosition, coordsFormat, atom.getPos().z);
            buf.append(' ');
            buf.append(MOL2Kt.toMol2$getType(atom, types2, residuesByAtom, mol));
            buf.append(' ');
            buf.append(((IdentityHashMap)resIds).get(res));
            buf.append(' ');
            buf.append(res.getType());
            buf.append(' ');
            buf.append(MOL2Kt.toMol2$getCharge(atom, charges, residuesByAtom, mol));
            buf.append('\n');
        }
        MOL2Kt.toMol2$write(buf, "@<TRIPOS>BOND\n", new Object[0]);
        Iterable $this$forEachIndexed$iv2 = bonds2;
        boolean $i$f$forEachIndexed = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv2) {
            void bond;
            int n5;
            if ((n5 = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AtomPair atomPair = (AtomPair)item$iv;
            int i3 = n5;
            boolean bl7 = false;
            buf.append(' ');
            buf.append(' ');
            buf.append(i3 + 1);
            buf.append(' ');
            Object object = MapsKt.getValue((Map)indicesByAtom, (Object)bond.getA());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"indicesByAtom.getValue(bond.a)");
            buf.append(((Number)object).intValue());
            buf.append(' ');
            Object object2 = MapsKt.getValue((Map)indicesByAtom, (Object)bond.getB());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"indicesByAtom.getValue(bond.b)");
            buf.append(((Number)object2).intValue());
            buf.append(' ');
            Object object3 = metadata;
            if (object3 == null || (object3 = ((Mol2Metadata)object3).getBondTypes()) == null || (object3 = (String)MapsKt.getValue((Map)object3, (Object)bond)) == null) {
                object3 = "1";
            }
            buf.append((String)object3);
            buf.append('\n');
        }
        MOL2Kt.toMol2$write(buf, "@<TRIPOS>SUBSTRUCTURE\n", new Object[0]);
        for (Polymer.Chain chain : chains) {
            for (Polymer.Residue res : chain.getResidues()) {
                Object object;
                buf.append(' ');
                buf.append(' ');
                buf.append(((IdentityHashMap)resIds).get(res));
                buf.append(' ');
                buf.append(res.getId());
                buf.append(' ');
                buf.append(indicesByAtom.get(CollectionsKt.first(res.getAtoms())));
                buf.append(" RESIDUE ");
                if (res == smallMoleculeRes) {
                    object = metadata;
                    if (object == null || (object = ((Mol2Metadata)object).getSmallMoleculeDictionaryType()) == null) {
                        object = Mol2Metadata.Companion.getDefaultSmallMoleculeDictionaryType();
                    }
                } else {
                    object = metadata;
                    if (object == null || (object = ((Mol2Metadata)object).getDictionaryTypes()) == null || (object = (String)MapsKt.getValue((Map)object, (Object)res)) == null) {
                        object = Mol2Metadata.Companion.getDefaultPolymerDictionaryType();
                    }
                }
                buf.append((String)object);
                buf.append(' ');
                buf.append(chain.getId());
                buf.append(' ');
                buf.append(res.getType());
                buf.append('\n');
            }
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return string;
    }

    public static /* synthetic */ String toMol2$default(Molecule molecule, Mol2Metadata mol2Metadata, int n, Object object) {
        if ((n & 1) != 0) {
            mol2Metadata = null;
        }
        return MOL2Kt.toMol2(molecule, mol2Metadata);
    }

    @NotNull
    public static final Molecule fromMol2(@NotNull Molecule.Companion $this$fromMol2, @NotNull String mol2, @Nullable Boolean isPolymer) {
        Intrinsics.checkNotNullParameter((Object)$this$fromMol2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mol2, (String)"mol2");
        return (Molecule)MOL2Kt.fromMol2WithMetadata($this$fromMol2, mol2, isPolymer).getFirst();
    }

    public static /* synthetic */ Molecule fromMol2$default(Molecule.Companion companion, String string, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return MOL2Kt.fromMol2(companion, string, bl);
    }

    @NotNull
    public static final Pair<Molecule, Mol2Metadata> fromMol2WithMetadata(@NotNull Molecule.Companion $this$fromMol2WithMetadata, @NotNull String mol2, @Nullable Boolean isPolymer) {
        List<String> parts;
        String type;
        Molecule molecule;
        boolean makePolymer;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$fromMol2WithMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mol2, (String)"mol2");
        List lines = StringsKt.lines((CharSequence)mol2);
        HashMap sections = new HashMap();
        Ref.IntRef i = new Ref.IntRef();
        while (i.element < lines.size()) {
            Section section;
            String line = MOL2Kt.fromMol2WithMetadata$next(lines, i);
            if (!StringsKt.startsWith$default((String)line, (String)"@", (boolean)false, (int)2, null)) continue;
            String string = ((Object)StringsKt.trim((CharSequence)line)).toString().substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            if (Section.Companion.get(StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"<", (String)"", (boolean)false, (int)4, null), (String)">", (String)"_", (boolean)false, (int)4, null)) == null) continue;
            ArrayList<String> sectionLines = new ArrayList<String>();
            while (i.element < lines.size() && !StringsKt.startsWith$default((String)MOL2Kt.fromMol2WithMetadata$peek(lines, i), (String)"@", (boolean)false, (int)2, null)) {
                String string3;
                String it = string3 = MOL2Kt.fromMol2WithMetadata$next(lines, i);
                boolean bl2 = false;
                String string4 = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
                if (string4 == null) continue;
                it = string4;
                boolean bl3 = false;
                sectionLines.add(it);
            }
            ((Map)sections).put(section, sectionLines);
        }
        Mol2Metadata metadata = new Mol2Metadata();
        List list = (List)sections.get((Object)Section.TRIPOS_MOLECULE);
        if (list == null) {
            throw new NoSuchElementException("missing MOLECULE section");
        }
        List sectionMol = list;
        String molName = ((Object)StringsKt.trim((CharSequence)((String)sectionMol.get(0)))).toString();
        List list2 = (List)sections.get((Object)Section.TRIPOS_SUBSTRUCTURE);
        if (list2 == null) {
            throw new NoSuchElementException("missing SUBSTRUCTURE section");
        }
        List sectionSub = list2;
        Molecule.Companion $this$fromMol2WithMetadata_u24lambda_u2411 = $this$fromMol2WithMetadata;
        boolean bl4 = false;
        if (isPolymer != null) {
            bl = isPolymer;
        } else if (sectionSub.size() > 1) {
            bl = true;
        } else {
            String dictType;
            Object object = (String)CollectionsKt.getOrNull((List)sectionSub, (int)0);
            String string = object != null && (object = MOL2Kt.tokenize((String)object)) != null ? (String)CollectionsKt.getOrNull((List)object, (int)4) : (dictType = null);
            bl = Intrinsics.areEqual((Object)dictType, (Object)Mol2Metadata.DictionaryType.Protein.getId());
        }
        if (makePolymer = bl) {
            molecule = new Polymer(molName);
        } else {
            Object object = (String)CollectionsKt.getOrNull((List)sectionSub, (int)0);
            String resType = object != null && (object = MOL2Kt.tokenize((String)object)) != null ? (String)CollectionsKt.getOrNull((List)object, (int)6) : null;
            molecule = new Molecule(molName, resType, null, 4, null);
        }
        Molecule mol = molecule;
        List list3 = (List)sections.get((Object)Section.TRIPOS_ATOM);
        if (list3 == null) {
            throw new NoSuchElementException("missing ATOM section");
        }
        List sectionAtoms = list3;
        HashMap atomsById = new HashMap();
        HashMap<Object, ArrayList> atomsBySub = new HashMap<Object, ArrayList>();
        for (String line : sectionAtoms) {
            List<String> parts2 = MOL2Kt.tokenize(line);
            String id = parts2.get(0);
            String name = parts2.get(1);
            Double d = StringsKt.toDoubleOrNull((String)parts2.get(2));
            if (d == null) {
                throw new Mol2ParseException(line, "\"" + parts2.get(2) + "\" doesn't seem to be a number");
            }
            Double d2 = StringsKt.toDoubleOrNull((String)parts2.get(3));
            if (d2 == null) {
                throw new Mol2ParseException(line, "\"" + parts2.get(3) + "\" doesn't seem to be a number");
            }
            Double d3 = StringsKt.toDoubleOrNull((String)parts2.get(4));
            if (d3 == null) {
                throw new Mol2ParseException(line, "\"" + parts2.get(4) + "\" doesn't seem to be a number");
            }
            Vector3d pos = new Vector3d(d.doubleValue(), d2.doubleValue(), d3.doubleValue());
            type = parts2.get(5);
            String subId = (String)CollectionsKt.getOrNull(parts2, (int)6);
            String charge = (String)CollectionsKt.getOrNull(parts2, (int)8);
            Element element = Element.Companion.findByPrefixMatch(type);
            if (element == null && (element = Element.Companion.findByPrefixMatch(name)) == null) {
                throw new NoSuchElementException("can't determine element for atom " + name + " " + type);
            }
            Element element2 = element;
            Atom atom = new Atom(element2, name, pos);
            ((Map)atomsById).put(id, atom);
            mol.getAtoms().add(atom);
            if (subId != null) {
                atomsBySub.computeIfAbsent(subId, arg_0 -> MOL2Kt.fromMol2WithMetadata$lambda$12(fromMol2WithMetadata.3.INSTANCE, arg_0)).add(atom);
            }
            metadata.getAtomTypes().put(atom, type);
            if (charge == null) continue;
            metadata.getAtomCharges().put(atom, charge);
        }
        List list4 = (List)sections.get((Object)Section.TRIPOS_BOND);
        if (list4 == null) {
            throw new NoSuchElementException("missing BOND section");
        }
        List sectionBonds = list4;
        for (String line : sectionBonds) {
            Atom a2;
            Atom a1;
            parts = MOL2Kt.tokenize(line);
            String i1 = parts.get(1);
            String i2 = parts.get(2);
            type = parts.get(3);
            if ((Atom)atomsById.get(i1) == null) {
                throw new NoSuchElementException("no atom with id " + i1);
            }
            if ((Atom)atomsById.get(i2) == null) {
                throw new NoSuchElementException("no atom with id " + i2);
            }
            AtomPair bond = new AtomPair(a1, a2);
            mol.getBonds().add(bond);
            metadata.getBondTypes().put(bond, type);
        }
        if (mol instanceof Polymer) {
            for (String line : sectionSub) {
                ArrayList arrayList;
                Polymer.Chain chain;
                Polymer.Chain chain2;
                Object v17;
                String subType;
                String chainId;
                String dictionaryType;
                String name;
                String id;
                block28: {
                    String string;
                    parts = MOL2Kt.tokenize(line);
                    id = parts.get(0);
                    name = parts.get(1);
                    dictionaryType = (String)CollectionsKt.getOrNull(parts, (int)4);
                    String string5 = (String)CollectionsKt.getOrNull(parts, (int)5);
                    if (string5 == null) {
                        string5 = chainId = "A";
                    }
                    if ((string = (String)CollectionsKt.getOrNull(parts, (int)6)) == null) {
                        string = "MOL";
                    }
                    subType = string;
                    Iterable iterable = ((Polymer)mol).getChains();
                    for (Object t : iterable) {
                        Polymer.Chain it = (Polymer.Chain)t;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)chainId)) continue;
                        v17 = t;
                        break block28;
                    }
                    v17 = null;
                }
                if ((chain2 = (Polymer.Chain)v17) == null) {
                    Polymer.Chain chain3;
                    Polymer.Chain $this$fromMol2WithMetadata_u24lambda_u2414 = chain3 = new Polymer.Chain(chainId);
                    boolean bl6 = false;
                    ((Polymer)mol).getChains().add($this$fromMol2WithMetadata_u24lambda_u2414);
                    chain2 = chain = chain3;
                }
                if ((arrayList = (ArrayList)atomsBySub.get(id)) == null) {
                    arrayList = new ArrayList();
                }
                ArrayList atoms = arrayList;
                Polymer.Residue res = new Polymer.Residue(name, subType, atoms);
                chain.getResidues().add(res);
                if (dictionaryType == null) continue;
                metadata.getDictionaryTypes().put(res, dictionaryType);
            }
        }
        return TuplesKt.to((Object)mol, (Object)metadata);
    }

    public static /* synthetic */ Pair fromMol2WithMetadata$default(Molecule.Companion companion, String string, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return MOL2Kt.fromMol2WithMetadata(companion, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> tokenize(String $this$tokenize) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{" "};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)$this$tokenize, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final StringBuffer toMol2$write(StringBuffer buf, String str, Object ... args) {
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(str, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
        return buf.append(string);
    }

    private static final Polymer.Residue toMol2$getResidue(Atom $this$toMol2_u24getResidue, IdentityHashMap<Atom, Polymer.Residue> residuesByAtom, Molecule mol) {
        Polymer.Residue residue = residuesByAtom.get($this$toMol2_u24getResidue);
        if (residue == null) {
            throw new NoSuchElementException("No residue found for atom " + $this$toMol2_u24getResidue + " in " + mol);
        }
        return residue;
    }

    private static final String toMol2$getType(Atom $this$toMol2_u24getType, Map<Atom, String> types2, IdentityHashMap<Atom, Polymer.Residue> residuesByAtom, Molecule mol) {
        String string;
        if (types2 != null) {
            string = types2.get($this$toMol2_u24getType);
            if (string == null) {
                throw new NoSuchElementException("No atom type found for atom " + $this$toMol2_u24getType + " @ " + residuesByAtom.get($this$toMol2_u24getType) + " in " + mol);
            }
        } else {
            string = $this$toMol2_u24getType.getElement().getSymbol();
        }
        return string;
    }

    private static final String toMol2$getCharge(Atom $this$toMol2_u24getCharge, Map<Atom, String> charges, IdentityHashMap<Atom, Polymer.Residue> residuesByAtom, Molecule mol) {
        String string;
        if (charges != null) {
            string = charges.get($this$toMol2_u24getCharge);
            if (string == null) {
                throw new NoSuchElementException("No charge found for atom " + $this$toMol2_u24getCharge + " @ " + residuesByAtom.get($this$toMol2_u24getCharge) + " in " + mol);
            }
        } else {
            string = "0.0";
        }
        return string;
    }

    private static final StringBuffer toMol2$appendCoord(StringBuffer $this$toMol2_u24appendCoord, FieldPosition dontCareFieldPosition, DecimalFormat coordsFormat, double value2) {
        return dontCareFieldPosition != null ? coordsFormat.format(value2, $this$toMol2_u24appendCoord, dontCareFieldPosition) : $this$toMol2_u24appendCoord.append(coordsFormat.format(value2));
    }

    private static final String fromMol2WithMetadata$peek(List<String> lines, Ref.IntRef i) {
        String string = (String)CollectionsKt.getOrNull(lines, (int)i.element);
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final String fromMol2WithMetadata$next(List<String> lines, Ref.IntRef i) {
        String string;
        String it = string = MOL2Kt.fromMol2WithMetadata$peek(lines, i);
        boolean bl = false;
        ++i.element;
        return string;
    }

    private static final ArrayList fromMol2WithMetadata$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ArrayList)$tmp0.invoke(p0);
    }
}

