/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield.amber;

import edu.duke.cs.osprey.gui.forcefield.amber.ForcefieldName;
import edu.duke.cs.osprey.gui.forcefield.amber.MolPartitioningKt;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0001\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0018"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/MoleculeType;", "", "isPolymer", "", "forcefieldNames", "", "Ledu/duke/cs/osprey/gui/forcefield/amber/ForcefieldName;", "(Ljava/lang/String;IZLjava/util/List;)V", "defaultForcefieldName", "getDefaultForcefieldName", "()Ledu/duke/cs/osprey/gui/forcefield/amber/ForcefieldName;", "defaultForcefieldNameOrThrow", "getDefaultForcefieldNameOrThrow", "getForcefieldNames", "()Ljava/util/List;", "()Z", "Protein", "DNA", "RNA", "Solvent", "AtomicIon", "Synthetic", "SmallMolecule", "Companion", "osprey3"})
public final class MoleculeType
extends Enum<MoleculeType> {
    @NotNull
    public static final Companion Companion;
    private final boolean isPolymer;
    @NotNull
    private final List<ForcefieldName> forcefieldNames;
    public static final /* enum */ MoleculeType Protein;
    public static final /* enum */ MoleculeType DNA;
    public static final /* enum */ MoleculeType RNA;
    public static final /* enum */ MoleculeType Solvent;
    public static final /* enum */ MoleculeType AtomicIon;
    public static final /* enum */ MoleculeType Synthetic;
    public static final /* enum */ MoleculeType SmallMolecule;
    private static final /* synthetic */ MoleculeType[] $VALUES;

    private MoleculeType(boolean isPolymer, List<ForcefieldName> forcefieldNames) {
        this.isPolymer = isPolymer;
        this.forcefieldNames = forcefieldNames;
    }

    public final boolean isPolymer() {
        return this.isPolymer;
    }

    @NotNull
    public final List<ForcefieldName> getForcefieldNames() {
        return this.forcefieldNames;
    }

    @Nullable
    public final ForcefieldName getDefaultForcefieldName() {
        return (ForcefieldName)CollectionsKt.firstOrNull(this.forcefieldNames);
    }

    @NotNull
    public final ForcefieldName getDefaultForcefieldNameOrThrow() {
        ForcefieldName forcefieldName = this.getDefaultForcefieldName();
        if (forcefieldName == null) {
            throw new NoSuchElementException("molecule type " + this + " has no default forcefield");
        }
        return forcefieldName;
    }

    public static MoleculeType[] values() {
        return (MoleculeType[])$VALUES.clone();
    }

    public static MoleculeType valueOf(String value2) {
        return Enum.valueOf(MoleculeType.class, value2);
    }

    static {
        Object[] objectArray = new ForcefieldName[]{ForcefieldName.Companion.getFf96(), ForcefieldName.Companion.getFf14SB()};
        Protein = new MoleculeType(true, CollectionsKt.listOf((Object[])objectArray));
        DNA = new MoleculeType(true, CollectionsKt.listOf((Object)ForcefieldName.Companion.getDNAOL15()));
        RNA = new MoleculeType(true, CollectionsKt.listOf((Object)ForcefieldName.Companion.getRNAOL15()));
        Solvent = new MoleculeType(false, CollectionsKt.listOf((Object)ForcefieldName.Companion.getTip3p()));
        AtomicIon = new MoleculeType(false, CollectionsKt.listOf((Object)ForcefieldName.Companion.getTip3p()));
        Synthetic = new MoleculeType(false, CollectionsKt.emptyList());
        objectArray = new ForcefieldName[]{ForcefieldName.Companion.getGaff2(), ForcefieldName.Companion.getGaff()};
        SmallMolecule = new MoleculeType(false, CollectionsKt.listOf((Object[])objectArray));
        $VALUES = moleculeTypeArray = new MoleculeType[]{MoleculeType.Protein, MoleculeType.DNA, MoleculeType.RNA, MoleculeType.Solvent, MoleculeType.AtomicIon, MoleculeType.Synthetic, MoleculeType.SmallMolecule};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/MoleculeType$Companion;", "", "()V", "get", "Ledu/duke/cs/osprey/gui/forcefield/amber/MoleculeType;", "resType", "", "osprey3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MoleculeType get(@NotNull String resType) {
            Intrinsics.checkNotNullParameter((Object)resType, (String)"resType");
            return MolPartitioningKt.access$getAminoAcidResTypes$p().contains(resType) ? Protein : (MolPartitioningKt.access$getDnaResTypes$p().contains(resType) ? DNA : (MolPartitioningKt.access$getRnaResTypes$p().contains(resType) ? RNA : (MolPartitioningKt.access$getSolventResTypes$p().contains(resType) ? Solvent : (MolPartitioningKt.access$getAtomicIonResTypes$p().contains(resType) ? AtomicIon : (MolPartitioningKt.access$getSyntheticResTypes$p().contains(resType) ? Synthetic : SmallMolecule)))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

