/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield;

import edu.duke.cs.osprey.molscope.molecule.Atom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0004H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\tH\u0086\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0086\u0002\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\tJ\u0019\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\tH\u0086\u0002J\u0019\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0086\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u000bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0004`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/AtomIndex;", "", "atoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "(Ljava/util/List;)V", "()V", "atomsToInts", "", "", "intsToAtoms", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "size", "getSize", "()I", "add", "", "atomi", "atom", "contains", "", "get", "(Ledu/duke/cs/osprey/molscope/molecule/Atom;)Ljava/lang/Integer;", "(Ljava/lang/Integer;)Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getOrThrow", "set", "toString", "", "osprey3"})
public final class AtomIndex {
    @NotNull
    private final Map<Atom, Integer> atomsToInts;
    @NotNull
    private final HashMap<Integer, Atom> intsToAtoms;

    public AtomIndex() {
        this.atomsToInts = Atom.Companion.identityMap();
        this.intsToAtoms = new HashMap();
    }

    public AtomIndex(@NotNull List<Atom> atoms) {
        Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
        this();
        Iterator<Atom> iterator2 = atoms.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int atomi = n++;
            Atom atom = iterator2.next();
            this.add(atomi, atom);
        }
    }

    public final int getSize() {
        return this.atomsToInts.size();
    }

    public final void add(int atomi, @NotNull Atom atom) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        Integer n = atomi;
        this.atomsToInts.put(atom, n);
        n = atomi;
        ((Map)this.intsToAtoms).put(n, atom);
    }

    @Nullable
    public final Integer get(@Nullable Atom atom) {
        return this.atomsToInts.get(atom);
    }

    public final int getOrThrow(@NotNull Atom atom) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        Integer n = this.get(atom);
        if (n == null) {
            throw new NoSuchElementException("doesn't have atom: " + atom);
        }
        return n;
    }

    @Nullable
    public final Atom get(@Nullable Integer atomi) {
        return (Atom)((Map)this.intsToAtoms).get(atomi);
    }

    @NotNull
    public final Atom getOrThrow(int atomi) {
        Atom atom = this.get(atomi);
        if (atom == null) {
            throw new NoSuchElementException("doesn't have atom index: " + atomi);
        }
        return atom;
    }

    public final void set(int atomi, @NotNull Atom atom) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        this.add(atomi, atom);
    }

    public final void set(@NotNull Atom atom, int atomi) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        this.add(atomi, atom);
    }

    public final boolean contains(@NotNull Atom atom) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        return this.atomsToInts.containsKey(atom);
    }

    public final boolean contains(int atomi) {
        return this.intsToAtoms.containsKey(atomi);
    }

    @NotNull
    public String toString() {
        String string = this.intsToAtoms.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intsToAtoms.toString()");
        return string;
    }
}

