/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.opencl;

import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLPlatform;
import edu.duke.cs.osprey.gpu.opencl.Gpu;
import edu.duke.cs.osprey.gpu.opencl.Gpus;
import java.util.Set;

public class Diagnostics {
    public static void main(String[] args) {
        try {
            System.out.println("Looking for OpenCL GPUs...");
            for (int i = 0; i < CLPlatform.listCLPlatforms().length; ++i) {
                CLPlatform platform2 = CLPlatform.listCLPlatforms()[i];
                System.out.println("\n" + platform2.getName());
                System.out.println("\tVendor:       " + platform2.getVendor());
                System.out.println("\tVersion:      " + String.valueOf(platform2.getVersion()));
                System.out.println("\tDevices:");
                for (CLDevice device : platform2.listCLDevices()) {
                    System.out.println("\n\t" + device.getName());
                    System.out.println(String.format("\t\t%-30s %b", "64-bit double support:", Diagnostics.supportsDoubles(device)));
                    System.out.println(String.format("\t\t%-30s %d", "compute units:", device.getMaxComputeUnits()));
                    System.out.println(String.format("\t\t%-30s %d", "work items per compute unit:", device.getMaxWorkGroupSize() / device.getMaxComputeUnits()));
                    System.out.println(String.format("\t\t%-30s %d", "max workgroup size:", device.getMaxWorkGroupSize()));
                    System.out.println(String.format("\t\t%-30s %d Mhz", "clock speed:", device.getMaxClockFrequency()));
                    System.out.println(String.format("\t\t%-30s %d MiB", "global memory:", device.getGlobalMemSize() / 1024L / 1024L));
                    System.out.println(String.format("\t\t%-30s %d KiB", "local memory:", device.getLocalMemSize() / 1024L));
                    System.out.println(String.format("\t\t%-30s %d MiB", "max allocation:", device.getMaxMemAllocSize() / 1024L / 1024L));
                }
            }
            System.out.println("\nOpenCL GPUs usable by Osprey:");
            Gpus gpus = Gpus.get();
            for (Gpu gpu : gpus.getGpus()) {
                System.out.println("\t" + String.valueOf(gpu));
            }
        }
        catch (UnsatisfiedLinkError ex) {
            System.out.println("OpenCL does not appear to be installed. No GPUs found.");
        }
        catch (CLException.CLPlatformNotFoundKhrException ex) {
            System.out.println("No OpenCL GPUs found.");
        }
    }

    public static boolean supportsDoubles(CLDevice device) {
        Set extensions = device.getExtensions();
        return extensions.contains("cl_khr_fp64") || extensions.contains("cl_amd_fp64");
    }
}

