/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gmec;

import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TupleEnumerator;
import edu.duke.cs.osprey.confspace.TupleMatrix;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.NewEPICMatrixCalculator;
import edu.duke.cs.osprey.ematrix.SimplerEnergyMatrixCalculator;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.ematrix.epic.NewEPICMatrix;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.gmec.PruningSettings;
import edu.duke.cs.osprey.pruning.NewPruner;
import edu.duke.cs.osprey.pruning.NewPruningControl;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tupexp.BasicEPICTupleExpander;
import edu.duke.cs.osprey.tupexp.LUTESettings;
import edu.duke.cs.osprey.tupexp.NewConfETupleExpander;
import edu.duke.cs.osprey.tupexp.TupExpChooser;
import edu.duke.cs.osprey.tupexp.TupleExpander;

public class PrecomputedMatrices {
    String name;
    EnergyMatrix emat;
    PruningMatrix competitorPruneMat = null;
    PruningMatrix pruneMat = null;
    NewEPICMatrix epicMat = null;
    EnergyMatrix luteMat = null;
    SimpleConfSpace confSpace;
    EnergyCalculator ecalc;
    ConfEnergyCalculator confECalc;
    boolean EFullConfOnly = false;
    EPICSettings epicSettings;
    LUTESettings luteSettings;
    PruningSettings pruningSettings;
    NewPruningControl pruningControl;
    double pruningInterval;
    double Ew;

    public PrecomputedMatrices(double pruningInterval, double Ew, String name, EnergyMatrix emat, SimpleConfSpace confSpace, EnergyCalculator ecalc, ConfEnergyCalculator confECalc, EPICSettings epicSettings, LUTESettings luteSettings, PruningSettings pruningSettings) {
        this.name = name;
        this.emat = emat;
        this.confSpace = confSpace;
        this.confECalc = confECalc;
        this.ecalc = ecalc;
        this.epicSettings = epicSettings;
        this.luteSettings = luteSettings;
        this.pruningSettings = pruningSettings;
        this.pruningInterval = pruningInterval;
        this.Ew = Ew;
        this.precompute();
    }

    private void precompute() {
        if (this.EFullConfOnly) {
            this.fullConfOnlyTupExp();
            return;
        }
        if (this.emat == null) {
            this.loadEnergyMatrix();
        }
        this.pruningControl = new NewPruningControl(this, 0.0, this.pruningSettings.typedep, this.pruningSettings.boundsThresh, this.pruningSettings.algOption, this.pruningSettings.useFlags, this.pruningSettings.useTriples, false, false, false, this.pruningSettings.stericThresh);
        if (this.competitorPruneMat == null) {
            System.out.println("PRECOMPUTING COMPETITOR PRUNING MATRIX");
            this.initPruning(0.0, false, false);
            this.pruningControl.prune();
            this.competitorPruneMat = this.pruneMat;
            this.pruneMat = null;
            System.out.println("COMPETITOR PRUNING DONE");
        }
        this.initPruning(this.pruningInterval, false, false);
        this.pruningControl.prune();
        if (this.epicSettings.shouldWeUseEPIC()) {
            this.loadEPICMatrix();
            if (this.epicSettings.useEPICPruning) {
                System.out.println("Beginning post-EPIC pruning.");
                this.initPruning(this.pruningInterval, true, false);
                this.pruningControl.prune();
                System.out.println("Finished post-EPIC pruning.");
            }
        }
        if (this.luteSettings.shouldWeUseLUTE()) {
            this.loadTupExpEMatrix();
            System.out.println("Beginning post-tup-exp pruning.");
            this.initPruning(this.Ew, false, true);
            this.pruningControl.prune();
            System.out.println("Finished post-tup-exp pruning.");
        }
    }

    private void initPruning(double localPruningInterval, boolean useEPIC, boolean useTupExp) {
        if (this.pruneMat == null || this.pruneMat.getPruningInterval() < this.pruningInterval) {
            this.pruneMat = new PruningMatrix(this.confSpace.getNumPos(), this.confSpace.getNumResConfsByPos(), this.pruningInterval);
        }
        this.pruningControl.setOnlyGoldstein(false);
        this.pruningControl.setPruningInterval(localPruningInterval);
        this.pruningControl.setUseEPIC(useEPIC);
        this.pruningControl.setUseTupExp(useTupExp);
    }

    private void fullConfOnlyTupExp() {
        if (!this.luteSettings.shouldWeUseLUTE()) {
            throw new RuntimeException("ERROR: Need tuple expansion to handle full-conf-only E-function");
        }
        if (this.epicSettings.shouldWeUseEPIC()) {
            throw new RuntimeException("ERROR: EPIC for full-conf-only E-function not yet supported");
        }
        this.loadEnergyMatrix();
        this.pruneMat = new PruningMatrix(this.confSpace.getNumPos(), this.confSpace.getNumResConfsByPos(), this.pruningInterval);
        NewPruner pruner = new NewPruner(this, false, 0.0, 0.0, false, false);
        pruner.pruneSteric(this.pruningSettings.stericThresh);
        this.loadTupExpEMatrix();
    }

    public void loadEnergyMatrix() {
        this.loadMatrix(MatrixType.EMAT);
    }

    public void loadTupExpEMatrix() {
        this.loadMatrix(MatrixType.TUPEXPEMAT);
    }

    public void loadEPICMatrix() {
        this.loadMatrix(MatrixType.EPICMAT);
    }

    public void loadMatrix(MatrixType type) {
        String matrixFileName = this.name + "." + type.name() + ".dat";
        if (!this.loadMatrixFromFile(type, matrixFileName)) {
            TupleMatrix<?> matrix = this.calcMatrix(type);
            if (matrix instanceof NewEPICMatrix) {
                this.epicMat = (NewEPICMatrix)matrix;
                return;
            }
            ObjectIO.writeObject(matrix, matrixFileName);
            this.loadMatrixFromFile(type, matrixFileName);
        }
    }

    public TupleMatrix<?> calcMatrix(MatrixType type) {
        TupleEnumerator tupEnum;
        if (type == MatrixType.EMAT) {
            return new SimplerEnergyMatrixCalculator.Builder(this.confSpace, this.ecalc).build().calcEnergyMatrix();
        }
        if (type == MatrixType.EPICMAT) {
            NewEPICMatrixCalculator emCalc = new NewEPICMatrixCalculator(this.confSpace, this.confECalc, this.pruneMat, this.epicSettings);
            emCalc.calcPEM();
            return emCalc.getEPICMatrix();
        }
        TupleExpander expander = this.epicSettings.shouldWeUseEPIC() ? new BasicEPICTupleExpander(this.confSpace, this.pruningInterval, this.luteSettings, this.epicMat, this.pruneMat) : new NewConfETupleExpander(this.confSpace, this.pruningInterval, this.luteSettings, this.confECalc, this.pruneMat);
        TupExpChooser chooser = new TupExpChooser(expander, tupEnum = new TupleEnumerator(this.pruneMat, this.emat, this.confSpace.getNumPos()));
        double curResid = chooser.calcPairwiseExpansion();
        if (curResid > this.luteSettings.goalResid) {
            System.out.println("EXPANDING PAIRWISE EXPANSION WITH STRONGLY PAIR-INTERACTING TRIPLES (2 PARTNERS)...");
            curResid = chooser.calcExpansionResTriples(2);
        }
        if (curResid > this.luteSettings.goalResid) {
            System.out.println("EXPANDING EXPANSION WITH STRONGLY PAIR-INTERACTING TRIPLES (5 PARTNERS)...");
            curResid = chooser.calcExpansionResTriples(5);
        }
        if (curResid > this.luteSettings.goalResid) {
            System.out.println("WARNING: Desired LUTE residual threshold " + this.luteSettings.goalResid + " not reached; best=" + curResid);
        }
        return expander.getEnergyMatrix();
    }

    boolean loadMatrixFromFile(MatrixType type, String matrixFileName) {
        Object matrixFromFile = ObjectIO.readObject(matrixFileName, true);
        if (type == MatrixType.EMAT) {
            this.emat = (EnergyMatrix)matrixFromFile;
        } else if (type == MatrixType.EPICMAT) {
            this.epicMat = (NewEPICMatrix)matrixFromFile;
        } else {
            this.luteMat = (EnergyMatrix)matrixFromFile;
        }
        if (matrixFromFile == null) {
            return false;
        }
        double matrixPruningInterval = ((TupleMatrix)matrixFromFile).getPruningInterval();
        if (matrixPruningInterval == Double.POSITIVE_INFINITY) {
            return true;
        }
        if (this.pruneMat == null) {
            throw new RuntimeException("ERROR: Trying to load pruning-dependent tuple matrix(EPIC or tup-exp) but haven't pruned yet");
        }
        return matrixPruningInterval >= this.pruneMat.getPruningInterval();
    }

    public EnergyMatrix getEmat() {
        return this.emat;
    }

    public PruningMatrix getPruneMat() {
        return this.pruneMat;
    }

    public NewEPICMatrix getEpicMat() {
        return this.epicMat;
    }

    public EnergyMatrix getLuteMat() {
        return this.luteMat;
    }

    public PruningMatrix getCompetitorPruneMat() {
        return this.competitorPruneMat;
    }

    public SimpleConfSpace getConfSpace() {
        return this.confSpace;
    }

    public boolean shouldWeUseLUTE() {
        return this.luteSettings.shouldWeUseLUTE();
    }

    public static enum MatrixType {
        EMAT,
        TUPEXPEMAT,
        EPICMAT;

    }
}

