/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gmec;

import edu.duke.cs.osprey.Queue;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.astar.conf.scoring.PairwiseGScorer;
import edu.duke.cs.osprey.confspace.Conf;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.ResidueForcefieldBreakdown;
import edu.duke.cs.osprey.structure.PDBIO;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConfAnalyzer {
    public final ConfEnergyCalculator confEcalc;

    public ConfAnalyzer(ConfEnergyCalculator confEcalc) {
        this.confEcalc = confEcalc;
    }

    public ConfAnalysis analyze(ConfSearch.ScoredConf conf) {
        return new ConfAnalysis(conf.getAssignments(), conf.getScore(), this.confEcalc.calcEnergy(new RCTuple(conf.getAssignments())));
    }

    public ConfAnalysis analyze(int[] assignments) {
        return new ConfAnalysis(assignments, Double.NaN, this.confEcalc.calcEnergy(new RCTuple(assignments)));
    }

    public ConfAnalysis analyze(int[] assignments, EnergyMatrix emat) {
        return this.analyze(assignments, new PairwiseGScorer(emat));
    }

    public ConfAnalysis analyze(int[] assignments, AStarScorer scorer) {
        return new ConfAnalysis(assignments, scorer.calc(Conf.index(assignments), new RCs(this.confEcalc.confSpace)), this.confEcalc.calcEnergy(new RCTuple(assignments)));
    }

    public EnsembleAnalysis analyzeGMECEnsembleFromConfDB(String confDBPath, int maxNumConfs) {
        return this.analyzeGMECEnsembleFromConfDB(new File(confDBPath), maxNumConfs);
    }

    public EnsembleAnalysis analyzeGMECEnsembleFromConfDB(File confDBFile, int maxNumConfs) {
        return this.analyzeEnsembleFromConfDB(confDBFile, "GMEC", maxNumConfs);
    }

    public EnsembleAnalysis analyzeEnsembleFromConfDB(File confDBFile, String tableName, int maxNumConfs) {
        try (ConfDB confdb = new ConfDB(this.confEcalc.confSpace, confDBFile);){
            ConfDB confDB = confdb;
            Objects.requireNonNull(confDB);
            ConfDB.ConfTable table = new ConfDB.ConfTable(confDB, tableName);
            EnsembleAnalysis ensembleAnalysis = this.analyzeEnsemble(table.energiedConfs(ConfDB.SortOrder.Energy).iterator(), maxNumConfs);
            return ensembleAnalysis;
        }
    }

    public EnsembleAnalysis analyzeEnsemble(Queue.FIFO<? extends ConfSearch.ScoredConf> confs, int maxNumConfs) {
        return this.analyzeEnsemble(confs.iterator(), maxNumConfs);
    }

    public EnsembleAnalysis analyzeEnsemble(HashMap<Double, ConfSearch.ScoredConf> sConfs, Iterator<? extends EnergyCalculator.EnergiedParametricMolecule> epmols, int maxNumConfs) {
        EnsembleAnalysis analysis = new EnsembleAnalysis();
        for (int i = 0; i < maxNumConfs; ++i) {
            int fi = i;
            if (!epmols.hasNext()) break;
            EnergyCalculator.EnergiedParametricMolecule epmol = epmols.next();
            ConfSearch.ScoredConf conf = sConfs.get(epmol.energy);
            while (analysis.analyses.size() <= fi) {
                analysis.analyses.add(null);
            }
            analysis.analyses.set(fi, new ConfAnalysis(conf.getAssignments(), conf.getScore(), epmol));
        }
        this.confEcalc.tasks.waitForFinish();
        return analysis;
    }

    public EnsembleAnalysis analyzeEnsemble(Iterator<? extends ConfSearch.ScoredConf> confs, int maxNumConfs) {
        EnsembleAnalysis analysis = new EnsembleAnalysis();
        int i = 0;
        while (i < maxNumConfs) {
            int fi = i++;
            if (!confs.hasNext()) break;
            ConfSearch.ScoredConf conf = confs.next();
            this.confEcalc.tasks.submit(() -> this.confEcalc.calcEnergy(new RCTuple(conf.getAssignments())), epmol -> {
                while (analysis.analyses.size() <= fi) {
                    analysis.analyses.add(null);
                }
                analysis.analyses.set(fi, new ConfAnalysis(conf.getAssignments(), conf.getScore(), (EnergyCalculator.EnergiedParametricMolecule)epmol));
            });
        }
        this.confEcalc.tasks.waitForFinish();
        return analysis;
    }

    public class ConfAnalysis {
        public final int[] assignments;
        public final double score;
        public final EnergyCalculator.EnergiedParametricMolecule epmol;

        public ConfAnalysis(int[] assignments, double score, EnergyCalculator.EnergiedParametricMolecule epmol) {
            this.assignments = assignments;
            this.score = score;
            this.epmol = epmol;
        }

        public ResidueForcefieldBreakdown.ByResidue breakdownEnergyByResidue() {
            return new ResidueForcefieldBreakdown.ByResidue(ConfAnalyzer.this.confEcalc, this.epmol);
        }

        public EnergyMatrix breakdownEnergyByPosition(ResidueForcefieldBreakdown.Type type) {
            return new ResidueForcefieldBreakdown.ByPosition(ConfAnalyzer.this.confEcalc, this.assignments, this.epmol).breakdownForcefield(type);
        }

        public EnergyMatrix breakdownScoreByPosition(EnergyMatrix emat) {
            return new ResidueForcefieldBreakdown.ByPosition(ConfAnalyzer.this.confEcalc, this.assignments, this.epmol).breakdownScore(emat);
        }

        public String toString() {
            return String.format("Residues           %s\nSequence           %s\nRotamers           %s\nResidue Conf IDs   %s\nEnergy             %-12.6f\nScore              %-12.6f (gap: %.6f)\n", ConfAnalyzer.this.confEcalc.confSpace.formatResidueNumbers(), ConfAnalyzer.this.confEcalc.confSpace.formatConfSequence(this.assignments), ConfAnalyzer.this.confEcalc.confSpace.formatConfRotamers(this.assignments), SimpleConfSpace.formatConfRCs(this.assignments), this.epmol.energy, this.score, this.epmol.energy - this.score);
        }
    }

    public class EnsembleAnalysis {
        public final List<ConfAnalysis> analyses = new ArrayList<ConfAnalysis>();

        public void writePdbs(String filePattern) {
            List<EnergyCalculator.EnergiedParametricMolecule> epmols = this.analyses.stream().map(analysis -> analysis.epmol).collect(Collectors.toList());
            PDBIO.writeEnsemble(epmols, filePattern);
        }

        public void writePdb(String path2, String comment) {
            List<EnergyCalculator.EnergiedParametricMolecule> epmols = this.analyses.stream().map(analysis -> analysis.epmol).collect(Collectors.toList());
            PDBIO.writeFile(epmols, path2, comment);
        }

        public String writePdbString(String comment) {
            List<EnergyCalculator.EnergiedParametricMolecule> epmols = this.analyses.stream().map(analysis -> analysis.epmol).collect(Collectors.toList());
            return PDBIO.write(epmols, comment);
        }

        public String toString() {
            int indexSize = 1 + (int)Math.log10(this.analyses.size());
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("Ensemble of %d conformations:\n", this.analyses.size()));
            buf.append("\tResidues: ");
            buf.append(ConfAnalyzer.this.confEcalc.confSpace.formatResidueNumbers());
            buf.append("\n");
            for (int i = 0; i < this.analyses.size(); ++i) {
                ConfAnalysis analysis = this.analyses.get(i);
                buf.append("\t");
                buf.append(String.format("%" + indexSize + "d/%" + indexSize + "d", i + 1, this.analyses.size()));
                buf.append(String.format("     Energy: %-12.6f     Score: %-12.6f", analysis.epmol.energy, analysis.score));
                buf.append("     Sequence: ");
                buf.append(ConfAnalyzer.this.confEcalc.confSpace.formatConfSequence(analysis.assignments));
                buf.append("     Rotamers: ");
                buf.append(ConfAnalyzer.this.confEcalc.confSpace.formatConfRotamers(analysis.assignments));
                buf.append("     Residue Conf IDs: ");
                buf.append(SimpleConfSpace.formatConfRCs(analysis.assignments));
                buf.append("\n");
            }
            return buf.toString();
        }
    }
}

