/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ewakstar;

import edu.duke.cs.osprey.confspace.SeqSpace;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EwakstarLimitedSequenceTrie {
    private static final TrieNode[] EMPTYNODES = new TrieNode[0];
    private final TrieNode root = new TrieNode("null");
    public final SeqSpace seqSpace;
    private int size = 0;

    public EwakstarLimitedSequenceTrie(SeqSpace ss) {
        this.seqSpace = ss;
    }

    public void addSeq(String sequence) {
        TrieNode node = this.root;
        for (String aa : sequence.split(" ")) {
            node = node.getOrCreateChild(aa);
        }
        if (!node.isSeq()) {
            node.setSeq();
            ++this.size;
        }
    }

    public void printSize() {
        System.out.println(this.size);
    }

    public boolean containsSeq(String sequence) {
        String aa;
        TrieNode node = this.root;
        String[] stringArray = sequence.split(" ");
        int n = stringArray.length;
        for (int i = 0; i < n && (node = node.get(aa = stringArray[i])) != null; ++i) {
        }
        return node != null;
    }

    public Set<String> getFirstPos() {
        HashSet<String> resTypes = new HashSet<String>();
        for (TrieNode n : this.root.getChildNodes()) {
            resTypes.add(n.getAA().split("=")[1].toUpperCase());
        }
        return resTypes;
    }

    public Set<String> getSeq(String sequence) {
        TrieNode node = this.root;
        for (String aa : sequence.split(" ")) {
            node = node.get(aa);
        }
        HashSet<String> resTypes = new HashSet<String>();
        for (TrieNode n : node.getChildNodes()) {
            resTypes.add(n.getAA().split("=")[1].toUpperCase());
        }
        return resTypes;
    }

    private static final class TrieNode {
        private final String aminoAcid;
        private boolean isSeq = false;
        private Map<String, TrieNode> children = null;

        public TrieNode(String aa) {
            this.aminoAcid = aa;
        }

        public TrieNode getOrCreateChild(String aa) {
            TrieNode kid;
            if (this.children == null) {
                this.children = new HashMap<String, TrieNode>();
            }
            if ((kid = this.children.get(aa)) == null) {
                kid = new TrieNode(aa);
                this.children.put(aa, kid);
            }
            return kid;
        }

        public TrieNode get(String aa) {
            return this.children != null ? this.children.get(aa) : null;
        }

        public void setSeq() {
            this.isSeq = true;
        }

        public boolean isSeq() {
            return this.isSeq;
        }

        public String getAA() {
            return this.aminoAcid;
        }

        public TrieNode[] getChildNodes() {
            if (this.children == null) {
                return EMPTYNODES;
            }
            TrieNode[] result = this.children.values().toArray(new TrieNode[this.children.size()]);
            return result;
        }
    }
}

