/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class ForcefieldInteractions
extends ArrayList<AtomGroup[]> {
    private static final long serialVersionUID = -2052346528544825763L;
    private Map<Integer, AtomGroup> groupsById = new HashMap<Integer, AtomGroup>();

    public ForcefieldInteractions() {
    }

    public ForcefieldInteractions(ResidueInteractions inters, Molecule mol) {
        this();
        for (ResidueInteractions.Pair pair : inters) {
            ResidueAtomGroup group2;
            if (pair.weight != 1.0 || pair.offset != 0.0) {
                throw new UnsupportedOperationException("weights and offsets not supported by ForcefieldInteractions");
            }
            ResidueAtomGroup group1 = this.makeResidueAtomGroup(mol.getResByPDBResNumber(pair.resNum1));
            this.groupsById.put(group1.getId(), group1);
            if (pair.resNum1.equals(pair.resNum2)) {
                group2 = group1;
            } else {
                group2 = this.makeResidueAtomGroup(mol.getResByPDBResNumber(pair.resNum2));
                this.groupsById.put(group2.getId(), group2);
            }
            this.add(new AtomGroup[]{group1, group2});
        }
    }

    private ResidueAtomGroup makeResidueAtomGroup(Residue res) {
        int id = ResidueAtomGroup.getId(res);
        ResidueAtomGroup group = (ResidueAtomGroup)this.groupsById.get(id);
        if (group == null) {
            group = new ResidueAtomGroup(res);
            this.groupsById.put(id, group);
        }
        return group;
    }

    public void addResidue(Residue res) {
        ResidueAtomGroup group = this.makeResidueAtomGroup(res);
        this.groupsById.put(group.getId(), group);
        this.add(new AtomGroup[]{group, group});
    }

    public void addResiduePair(Residue res1, Residue res2) {
        ResidueAtomGroup group1 = this.makeResidueAtomGroup(res1);
        ResidueAtomGroup group2 = this.makeResidueAtomGroup(res2);
        this.groupsById.put(group1.getId(), group1);
        this.groupsById.put(group2.getId(), group2);
        this.add(new AtomGroup[]{group1, group2});
    }

    public ForcefieldInteractions makeSubsetByResidue(Residue res) {
        ForcefieldInteractions subInteractions = new ForcefieldInteractions();
        for (AtomGroup[] groupPair : this) {
            if (groupPair[0].getId() != res.indexInMolecule && groupPair[1].getId() != res.indexInMolecule) continue;
            subInteractions.add(groupPair);
        }
        return subInteractions;
    }

    public ResidueAtomGroup getResidueAtomGroup(Residue res) {
        AtomGroup group = this.groupsById.get(res.indexInMolecule);
        if (group instanceof ResidueAtomGroup) {
            return (ResidueAtomGroup)group;
        }
        return null;
    }

    public static class ResidueAtomGroup
    implements AtomGroup {
        private Residue res;
        private ResidueTemplate template;
        private int sequenceNumber;

        public ResidueAtomGroup(Residue res) {
            this.res = res;
            this.template = res.template;
            this.sequenceNumber = 0;
        }

        public Residue getResidue() {
            return this.res;
        }

        public static int getId(Residue res) {
            return res.indexInMolecule;
        }

        @Override
        public int getId() {
            return ResidueAtomGroup.getId(this.res);
        }

        @Override
        public List<Atom> getAtoms() {
            return this.res.atoms;
        }

        @Override
        public double[] getCoords() {
            return this.res.coords;
        }

        @Override
        public int getSequenceNumber() {
            if (this.template != this.res.template) {
                this.template = this.res.template;
                ++this.sequenceNumber;
            }
            return this.sequenceNumber;
        }

        @Override
        public boolean isBroken() {
            return !this.res.confProblems.isEmpty();
        }
    }

    public static interface AtomGroup {
        public int getId();

        public List<Atom> getAtoms();

        public double[] getCoords();

        public int getSequenceNumber();

        public boolean isBroken();
    }
}

