/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.restypes.DAminoAcidHandler;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.Residues;
import edu.duke.cs.osprey.tools.HashCalculator;
import edu.duke.cs.osprey.tools.StringParsing;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class EEF1
implements Serializable {
    private static final long serialVersionUID = -4783417295676415124L;
    public static final double trigConst = 2.0 / (Math.PI * 4 * Math.sqrt(Math.PI));
    final int numAtTypesEEF1 = 17;
    String[] groupEEF1names = new String[17];
    String[] atTypeEEF1names = new String[17];
    double[] atEEF1Vol = new double[17];
    double[] dGiRef = new double[17];
    double[] dGiFree = new double[17];
    double[] dHiRef = new double[17];
    double[] dCpiRef = new double[17];
    double[] lambdai = new double[17];
    double[] vdWri = new double[17];
    private static HashMap<SolvGroupKey, Integer> solvGroupIndices = new HashMap();
    private static final Map<ResidueTemplate, ResInfo> resInfoCache = new HashMap<ResidueTemplate, ResInfo>();

    public void readEEF1parm() throws Exception {
        try (BufferedReader bufread = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/config/eef1parm.dat")));){
            String curLine = null;
            int tmpInt = 0;
            curLine = bufread.readLine();
            curLine = bufread.readLine();
            tmpInt = 0;
            while (curLine != null) {
                this.groupEEF1names[tmpInt] = StringParsing.getToken(curLine, 1);
                this.atTypeEEF1names[tmpInt] = StringParsing.getToken(curLine, 2);
                this.atEEF1Vol[tmpInt] = Double.parseDouble(StringParsing.getToken(curLine, 3));
                this.dGiRef[tmpInt] = Double.parseDouble(StringParsing.getToken(curLine, 4));
                this.dGiFree[tmpInt] = Double.parseDouble(StringParsing.getToken(curLine, 5));
                this.dHiRef[tmpInt] = Double.parseDouble(StringParsing.getToken(curLine, 6));
                this.dCpiRef[tmpInt] = Double.parseDouble(StringParsing.getToken(curLine, 7));
                this.lambdai[tmpInt] = Double.parseDouble(StringParsing.getToken(curLine, 8));
                this.vdWri[tmpInt] = Double.parseDouble(StringParsing.getToken(curLine, 9));
                ++tmpInt;
                curLine = bufread.readLine();
            }
        }
    }

    public boolean getSolvationParameters(Atom at1, SolvParams solvparams) {
        int solvGroupIndex = this.getSolvGroupIndex(at1);
        if (solvGroupIndex == -1) {
            return false;
        }
        solvparams.dGref = this.dGiRef[solvGroupIndex];
        solvparams.dGfree = this.dGiFree[solvGroupIndex];
        solvparams.volume = this.atEEF1Vol[solvGroupIndex];
        solvparams.lambda = this.lambdai[solvGroupIndex];
        solvparams.radius = this.vdWri[solvGroupIndex];
        return true;
    }

    private static void warnAtom(Atom atom) {
        System.err.println(String.format("WARNING: couldn't find solvation parameters for atom %s @ %s, using default values", atom.name, atom.res != null ? atom.res.getPDBResNumber() : "(no residue)"));
    }

    public void getSolvationParametersOrDefaults(Atom atom, SolvParams solvparams) {
        boolean success = this.getSolvationParameters(atom, solvparams);
        if (!success) {
            EEF1.warnAtom(atom);
            solvparams.dGref = 0.0;
            solvparams.dGfree = 0.0;
            solvparams.volume = 0.0;
            solvparams.lambda = 1.0;
            solvparams.radius = 0.0;
        }
    }

    private int getSolvGroupIndex(Atom atom) {
        SolvGroupKey key = new SolvGroupKey(this, atom);
        Integer index = solvGroupIndices.get(key);
        if (index == null) {
            index = this.getSolvGroupIndex(key);
            solvGroupIndices.put(key, index);
        }
        return index;
    }

    private int getSolvGroupIndex(SolvGroupKey key) {
        return this.getSolvGroupIndex(key.atomName, key.elementType, key.AAname, key.numBoundH, key.isCarboxylO);
    }

    private int getSolvGroupIndex(String atomName, String elementType, String AAname, int numBoundH, boolean isCarboxylO) {
        if (DAminoAcidHandler.isDAminoAcidName(AAname)) {
            AAname = DAminoAcidHandler.getLEquivalent(AAname);
        }
        boolean aromatic = this.isAromatic(atomName, elementType, AAname);
        if (elementType.equalsIgnoreCase("C")) {
            if (atomName.equalsIgnoreCase("CG") && (AAname.equalsIgnoreCase("TYR") || AAname.equalsIgnoreCase("PHE") || AAname.equalsIgnoreCase("HIS") || AAname.equalsIgnoreCase("HIP") || AAname.equalsIgnoreCase("HID") || AAname.equalsIgnoreCase("HIE"))) {
                return this.findSolvGroup("CR");
            }
            if ((atomName.equalsIgnoreCase("CG") || atomName.equalsIgnoreCase("CD2") || atomName.equalsIgnoreCase("CE2")) && AAname.equalsIgnoreCase("TRP")) {
                return this.findSolvGroup("CR");
            }
            if (atomName.equalsIgnoreCase("CZ") && AAname.equalsIgnoreCase("ARG")) {
                return this.findSolvGroup("CR");
            }
            if (aromatic && numBoundH == 1) {
                return this.findSolvGroup("CR1E");
            }
            if (!aromatic && numBoundH == 1) {
                return this.findSolvGroup("CH1E");
            }
            if (!aromatic && numBoundH == 2) {
                return this.findSolvGroup("CH2E");
            }
            if (!aromatic && numBoundH == 3) {
                return this.findSolvGroup("CH3E");
            }
            return this.findSolvGroup("C");
        }
        if (elementType.equalsIgnoreCase("N")) {
            if (AAname.equalsIgnoreCase("PRO")) {
                return this.findSolvGroup("N");
            }
            if (numBoundH == 1) {
                return this.findSolvGroup("NH1");
            }
            if (AAname.equalsIgnoreCase("ARG") && numBoundH == 2) {
                return this.findSolvGroup("NC2");
            }
            if (aromatic && numBoundH == 0) {
                return this.findSolvGroup("NR");
            }
            if (numBoundH == 2) {
                return this.findSolvGroup("NH2");
            }
            if (numBoundH == 3) {
                return this.findSolvGroup("NH3");
            }
            return -1;
        }
        if (elementType.equalsIgnoreCase("O")) {
            if (numBoundH == 1) {
                return this.findSolvGroup("OH1");
            }
            if (isCarboxylO) {
                return this.findSolvGroup("OC");
            }
            return this.findSolvGroup("O");
        }
        if (elementType.equalsIgnoreCase("S")) {
            if (numBoundH == 1) {
                return this.findSolvGroup("SH1E");
            }
            return this.findSolvGroup("S");
        }
        return -1;
    }

    private int findSolvGroup(String grName) {
        for (int i = 0; i < this.groupEEF1names.length; ++i) {
            if (!this.groupEEF1names[i].equalsIgnoreCase(grName)) continue;
            return i;
        }
        return -1;
    }

    private boolean isCarboxylO(Atom atom) {
        if (!atom.isOxygen()) {
            return false;
        }
        Atom boundC = null;
        for (Atom bondedAtom : atom.bonds) {
            if (!bondedAtom.isCarbon()) continue;
            if (boundC != null) {
                return false;
            }
            boundC = bondedAtom;
        }
        return this.isCarboxylC(boundC);
    }

    private boolean isCarboxylC(Atom atom) {
        if (atom == null || !atom.isCarbon()) {
            return false;
        }
        int numO = 0;
        for (Atom bondedAtom : atom.bonds) {
            if (!bondedAtom.isOxygen()) continue;
            ++numO;
        }
        return numO == 2;
    }

    private boolean isAromatic(String atomName, String elementType, String AAname) {
        boolean isHis;
        if (DAminoAcidHandler.isDAminoAcidName(AAname)) {
            AAname = DAminoAcidHandler.getLEquivalent(AAname);
        }
        boolean bl = isHis = AAname.equalsIgnoreCase("HIS") || AAname.equalsIgnoreCase("HIP") || AAname.equalsIgnoreCase("HID") || AAname.equalsIgnoreCase("HIE");
        if (!(AAname.equalsIgnoreCase("PHE") || AAname.equalsIgnoreCase("TYR") || AAname.equalsIgnoreCase("TRP") || isHis)) {
            return false;
        }
        if (!elementType.equalsIgnoreCase("C")) {
            return elementType.equalsIgnoreCase("N") && !atomName.equalsIgnoreCase("N") && (AAname.equalsIgnoreCase("TRP") || isHis);
        }
        return !atomName.equalsIgnoreCase("CA") && !atomName.equalsIgnoreCase("CB") && !atomName.equalsIgnoreCase("C");
    }

    private int getNumBoundH(Atom atom) {
        int numBoundH = 0;
        for (Atom bondedAtom : atom.bonds) {
            if (!bondedAtom.isHydrogen()) continue;
            ++numBoundH;
        }
        return numBoundH;
    }

    public static class SolvParams {
        public double dGref;
        public double dGfree;
        public double volume;
        public double lambda;
        public double radius;
    }

    private class SolvGroupKey {
        public final String atomName;
        public final String elementType;
        public final String AAname;
        public final int numBoundH;
        public final boolean isCarboxylO;
        private final int hashCode;

        public SolvGroupKey(EEF1 eEF1, Atom atom) {
            this.atomName = atom.name;
            this.elementType = atom.elementType;
            this.AAname = atom.res.template.name;
            this.numBoundH = eEF1.getNumBoundH(atom);
            this.isCarboxylO = eEF1.isCarboxylO(atom);
            this.hashCode = HashCalculator.combineHashes(this.atomName.hashCode(), this.elementType.hashCode(), this.AAname.hashCode(), this.numBoundH, this.isCarboxylO ? 2 : 1);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            SolvGroupKey other = (SolvGroupKey)obj;
            return this.isCarboxylO == other.isCarboxylO && this.numBoundH == other.numBoundH && this.AAname.equals(other.AAname) && this.elementType.equals(other.elementType) && this.atomName.equals(other.atomName);
        }
    }

    public class ResiduesInfo
    implements ForcefieldParams.SolvationForcefield.ResiduesInfo {
        public final Residues residues;
        private final Map<Residue, ResInfo> infos;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResiduesInfo(Residues residues) {
            this.residues = residues;
            this.infos = new IdentityHashMap<Residue, ResInfo>();
            for (Residue res : residues) {
                Map<ResidueTemplate, ResInfo> map = resInfoCache;
                synchronized (map) {
                    this.infos.put(res, resInfoCache.computeIfAbsent(res.template, template -> {
                        ResInfo info2 = new ResInfo();
                        info2.indices = new int[res.atoms.size()];
                        info2.internalEnergy = 0.0;
                        for (int i = 0; i < res.atoms.size(); ++i) {
                            Atom atom = res.atoms.get(i);
                            if (atom.isHydrogen()) {
                                info2.indices[i] = -1;
                                continue;
                            }
                            int index = EEF1.this.getSolvGroupIndex(atom);
                            if (index >= 0) {
                                info2.internalEnergy += EEF1.this.dGiRef[index];
                            } else {
                                EEF1.warnAtom(atom);
                            }
                            info2.indices[i] = index;
                        }
                        return info2;
                    }));
                }
            }
        }

        @Override
        public int getNumPrecomputedPerAtomPair() {
            return 6;
        }

        @Override
        public double getResPairEnergy(Residue res1, Residue res2) {
            if (res1 == res2) {
                return this.infos.get((Object)res1).internalEnergy;
            }
            return 0.0;
        }

        @Override
        public void putPrecomputed(double[] out, int i, Residue res1, int atomIndex1, Residue res2, int atomIndex2, double scale) {
            int index2;
            ResInfo info1 = this.infos.get(res1);
            Atom atom1 = res1.atoms.get(atomIndex1);
            ResInfo info2 = this.infos.get(res2);
            Atom atom2 = res2.atoms.get(atomIndex2);
            if (atom1.isHydrogen() || atom2.isHydrogen()) {
                return;
            }
            double dGfree1 = 0.0;
            double volume1 = 0.0;
            double lambda1 = 1.0;
            double radius1 = 0.0;
            double dGfree2 = 0.0;
            double volume2 = 0.0;
            double lambda2 = 1.0;
            double radius2 = 0.0;
            int index1 = info1.indices[atomIndex1];
            if (index1 != -1) {
                dGfree1 = EEF1.this.dGiFree[index1];
                volume1 = EEF1.this.atEEF1Vol[index1];
                lambda1 = EEF1.this.lambdai[index1];
                radius1 = EEF1.this.vdWri[index1];
            }
            if ((index2 = info2.indices[atomIndex2]) != -1) {
                dGfree2 = EEF1.this.dGiFree[index2];
                volume2 = EEF1.this.atEEF1Vol[index2];
                lambda2 = EEF1.this.lambdai[index2];
                radius2 = EEF1.this.vdWri[index2];
            }
            double alpha1 = (scale *= trigConst) * dGfree1 * volume2 / lambda1;
            double alpha2 = scale * dGfree2 * volume1 / lambda2;
            out[i++] = radius1;
            out[i++] = lambda1;
            out[i++] = alpha1;
            out[i++] = radius2;
            out[i++] = lambda2;
            out[i++] = alpha2;
        }
    }

    private static class ResInfo {
        int[] indices;
        double internalEnergy;

        private ResInfo() {
        }
    }
}

