/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class PoissonBoltzmannEnergy
implements EnergyFunction {
    Molecule m;
    static String delphiFolder = "OSPREY_delphi";
    public static double constRT = 0.593050165;

    public PoissonBoltzmannEnergy(Molecule m) {
        this.m = m;
    }

    @Override
    public double getEnergy() {
        PDBIO.writeFile(this.m, delphiFolder + "/struct.pdb");
        double E = 0.0;
        try {
            Process p = Runtime.getRuntime().exec(delphiFolder + "/getE");
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            p.waitFor();
            E = Double.valueOf(br.readLine().trim());
            br.close();
        }
        catch (Exception ex) {
            throw new Error("can't compute Poisson-Boltzmann energy", ex);
        }
        return E *= constRT;
    }
}

