/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix.epic;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.math.Functions;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.ematrix.epic.EPolyPC;
import edu.duke.cs.osprey.ematrix.epic.SAPE;
import edu.duke.cs.osprey.ematrix.epic.SeriesFitter;
import java.io.Serializable;
import java.util.ArrayList;

public class EPoly
implements Serializable {
    int numDOFs;
    DoubleMatrix1D DOFmax;
    DoubleMatrix1D DOFmin;
    ArrayList<String> DOFNames;
    double[] coeffs;
    int order;
    DoubleMatrix1D center;
    double minE;
    String fitDescription = "N/A";
    SAPE sapeTerm = null;
    double baseSAPE = 0.0;

    public EPoly(int numDOFs, ArrayList<DegreeOfFreedom> DOFs, DoubleMatrix1D DOFmax, DoubleMatrix1D DOFmin, DoubleMatrix1D center, double minE, double[] coeffs, int order) {
        this.numDOFs = numDOFs;
        this.DOFmax = DOFmax;
        this.DOFmin = DOFmin;
        this.center = center;
        this.minE = minE;
        this.coeffs = coeffs;
        this.order = order;
        this.DOFNames = new ArrayList();
        for (DegreeOfFreedom dof : DOFs) {
            this.DOFNames.add(dof.getName());
        }
    }

    public EPoly(int numDOFs, DoubleMatrix1D DOFmax, DoubleMatrix1D DOFmin, DoubleMatrix1D center, double minE, double[] coeffs, int order, ArrayList<String> DOFNames) {
        this.numDOFs = numDOFs;
        this.DOFmax = DOFmax;
        this.DOFmin = DOFmin;
        this.center = center;
        this.minE = minE;
        this.coeffs = coeffs;
        this.order = order;
        this.DOFNames = DOFNames;
    }

    public double evaluate(DoubleMatrix1D x, boolean includeMinE, boolean useSharedMolec) {
        DoubleMatrix1D z = this.toRelCoords(x);
        double serVal = this.evalSeries(z);
        if (includeMinE) {
            serVal += this.minE;
        }
        if (this.sapeTerm != null) {
            if (useSharedMolec) {
                return serVal + this.sapeTerm.getEnergySharedMolec() - this.baseSAPE;
            }
            return serVal + this.sapeTerm.getEnergyStandalone(x) - this.baseSAPE;
        }
        return serVal;
    }

    double evalSeries(DoubleMatrix1D z) {
        return SeriesFitter.evalSeries(this.coeffs, z, this.numDOFs, false, this.order);
    }

    public DoubleMatrix1D gradient(DoubleMatrix1D x) {
        DoubleMatrix1D z = this.toRelCoords(x);
        if (this instanceof EPolyPC) {
            throw new RuntimeException("ERROR: gradient for EPolyPC not currently supported");
        }
        DoubleMatrix1D grad = this.seriesGradient(z);
        if (this.sapeTerm != null) {
            throw new RuntimeException("ERROR: SVE gradient not currently supported");
        }
        return grad;
    }

    public DoubleMatrix2D hessian(DoubleMatrix1D x) {
        DoubleMatrix1D z = this.toRelCoords(x);
        if (this instanceof EPolyPC) {
            throw new RuntimeException("ERROR: Hessian for EPolyPC not currently supported");
        }
        DoubleMatrix2D hess = this.seriesHessian(z);
        if (this.sapeTerm != null) {
            throw new RuntimeException("ERROR: SVE Hessian not currently supported");
        }
        return hess;
    }

    DoubleMatrix1D seriesGradient(DoubleMatrix1D z) {
        return SeriesFitter.evalSeriesGradient(this.coeffs, z, this.numDOFs, false, this.order, this.order, null);
    }

    DoubleMatrix2D seriesHessian(DoubleMatrix1D z) {
        return SeriesFitter.evalSeriesHessian(this.coeffs, z, this.numDOFs, false, this.order, this.order, null);
    }

    DoubleMatrix1D toRelCoords(DoubleMatrix1D x) {
        DoubleMatrix1D ans = x.copy();
        ans.assign(this.center, Functions.minus);
        return ans;
    }

    DoubleMatrix1D toAbsCoords(DoubleMatrix1D z) {
        DoubleMatrix1D ans = z.copy();
        ans.assign(this.center, Functions.plus);
        return ans;
    }

    public boolean valuesInRange(DoubleMatrix1D x) {
        for (int dof = 0; dof < this.numDOFs; ++dof) {
            if (!(x.get(dof) > this.DOFmax.get(dof)) && !(x.get(dof) < this.DOFmin.get(dof))) continue;
            return false;
        }
        return true;
    }

    public void setMinE(double minE) {
        this.minE = minE;
    }

    public double getMinE() {
        return this.minE;
    }

    public void deleteMOFStandalone() {
        if (this.sapeTerm != null) {
            this.sapeTerm.mofStandalone = null;
        }
    }
}

