/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix.compiled;

import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.PosInter;
import edu.duke.cs.osprey.confspace.compiled.PosInterDist;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimpleReferenceEnergies;
import edu.duke.cs.osprey.energy.compiled.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.PosInterGen;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.Progress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class EmatCalculator {
    public final ConfEnergyCalculator confEcalc;
    public final PosInterGen posInterGen;
    public final boolean minimize;
    public final boolean includeStaticStatic;
    public final File cacheFile;

    private EmatCalculator(ConfEnergyCalculator confEcalc, PosInterGen posInterGen, boolean minimize2, boolean includeStaticStatic, File cacheFile) {
        this.confEcalc = confEcalc;
        this.posInterGen = posInterGen;
        this.minimize = minimize2;
        this.includeStaticStatic = includeStaticStatic;
        this.cacheFile = cacheFile;
    }

    public EnergyMatrix calc() {
        return this.calc(new TaskExecutor());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EnergyMatrix calc(TaskExecutor tasks) {
        if (this.cacheFile == null) {
            return this.reallyCalc(tasks);
        }
        EmatKey key = new EmatKey();
        key.version = 1;
        key.confSpaceHash = this.confEcalc.confSpace().hashCode();
        key.posInterDistId = this.posInterGen.dist.ordinal();
        key.erefHash = this.posInterGen.eref.hashCode();
        key.minimize = this.minimize;
        key.includeStaticStatic = this.includeStaticStatic;
        if (this.cacheFile.exists()) {
            Log.log("reading energy matrix from file: %s", this.cacheFile);
            try (DataInputStream in = new DataInputStream(new FileInputStream(this.cacheFile));){
                if (EmatKey.read(in).equals(key)) {
                    EnergyMatrix emat = new EnergyMatrix(this.confEcalc.confSpace());
                    emat.read(in);
                    EnergyMatrix energyMatrix = emat;
                    return energyMatrix;
                }
                Log.log("cached energy matrix is out of date, ignoring", new Object[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException("can't open emat cache file", ex);
            }
        }
        EnergyMatrix emat = this.reallyCalc(tasks);
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.cacheFile));){
            key.write(out);
            emat.write(out);
            Log.log("wrote energy matrix to file: %s", this.cacheFile);
            return emat;
        }
        catch (IOException ex) {
            throw new RuntimeException("can't write emat cache file", ex);
        }
    }

    private EnergyMatrix reallyCalc(TaskExecutor tasks) {
        long pairCost;
        long singleCost;
        EnergyMatrix emat = new EnergyMatrix(this.confEcalc.confSpace());
        ConfSpace confSpace = this.confEcalc.confSpace();
        long staticCost = confSpace.avgAtomPairs(this.posInterGen.staticStatic());
        if (confSpace.numPos() > 0) {
            singleCost = confSpace.avgAtomPairs(this.posInterGen.single(confSpace, 0, 0));
            pairCost = confSpace.avgAtomPairs(this.posInterGen.pair(confSpace, 0, 0, 0, 0));
        } else {
            singleCost = 0L;
            pairCost = 0L;
        }
        int numSingles = confSpace.countSingles();
        int numPairs = confSpace.countPairs();
        Progress progress2 = new Progress(staticCost + (long)numSingles * singleCost + (long)numPairs * pairCost);
        Log.log("Calculating energy matrix with %d entries", 1 + numSingles + numPairs);
        if (this.includeStaticStatic) {
            List<PosInter> inters = this.posInterGen.staticStatic();
            int[] conf = confSpace.assign();
            double energy2 = this.confEcalc.calcOrMinimizeEnergy(conf, inters, this.minimize);
            emat.setConstTerm(energy2);
        }
        progress2.incrementProgress(staticCost);
        for (int posi1 = 0; posi1 < confSpace.numPos(); ++posi1) {
            int fposi1 = posi1;
            for (int confi1 = 0; confi1 < confSpace.numConf(posi1); ++confi1) {
                int fconfi1 = confi1;
                tasks.submit(() -> {
                    int[] assignments = confSpace.assign(fposi1, fconfi1);
                    List<PosInter> inters = this.posInterGen.single(confSpace, fposi1, fconfi1);
                    return this.confEcalc.calcOrMinimizeEnergy(assignments, inters, this.minimize);
                }, energy -> {
                    emat.setOneBody(fposi1, fconfi1, (Double)energy);
                    progress2.incrementProgress(singleCost);
                });
                for (int posi2 = 0; posi2 < posi1; ++posi2) {
                    int fposi2 = posi2;
                    int confi2 = 0;
                    while (confi2 < confSpace.numConf(fposi2)) {
                        int fconfi2 = confi2++;
                        tasks.submit(() -> {
                            int[] assignments = confSpace.assign(fposi1, fconfi1, fposi2, fconfi2);
                            List<PosInter> inters = this.posInterGen.pair(confSpace, fposi1, fconfi1, fposi2, fconfi2);
                            return this.confEcalc.calcOrMinimizeEnergy(assignments, inters, this.minimize);
                        }, energy -> {
                            emat.setPairwise(fposi1, fconfi1, fposi2, fconfi2, (Double)energy);
                            progress2.incrementProgress(pairCost);
                        });
                    }
                }
            }
        }
        tasks.waitForFinish();
        return emat;
    }

    private static class EmatKey {
        static final int CurrentVersion = 1;
        int version;
        int confSpaceHash;
        int posInterDistId;
        int erefHash;
        boolean minimize;
        boolean includeStaticStatic;

        private EmatKey() {
        }

        void write(DataOutputStream out) throws IOException {
            out.writeInt(this.version);
            out.writeInt(this.confSpaceHash);
            out.writeInt(this.posInterDistId);
            out.writeInt(this.erefHash);
            out.writeBoolean(this.minimize);
            out.writeBoolean(this.includeStaticStatic);
        }

        static EmatKey read(DataInputStream in) throws IOException {
            EmatKey key = new EmatKey();
            key.version = in.readInt();
            key.confSpaceHash = in.readInt();
            key.posInterDistId = in.readInt();
            key.erefHash = in.readInt();
            key.minimize = in.readBoolean();
            key.includeStaticStatic = in.readBoolean();
            return key;
        }

        public boolean equals(Object other) {
            return this.equals((EmatKey)other);
        }

        boolean equals(EmatKey other) {
            return this.version == other.version && this.confSpaceHash == other.confSpaceHash && this.posInterDistId == other.posInterDistId && this.erefHash == other.erefHash && this.minimize == other.minimize && this.includeStaticStatic == other.includeStaticStatic;
        }
    }

    public static class Builder {
        public final ConfEnergyCalculator confEcalc;
        private PosInterDist posInterDist = PosInterDist.DesmetEtAl1992;
        private SimpleReferenceEnergies eref = null;
        private boolean minimize = true;
        private boolean includeStaticStatic = true;
        private File cacheFile = null;

        public Builder(ConfEnergyCalculator confEcalc) {
            this.confEcalc = confEcalc;
        }

        public Builder setPosInterDist(PosInterDist val) {
            this.posInterDist = val;
            return this;
        }

        public Builder setReferenceEnergies(SimpleReferenceEnergies val) {
            this.eref = val;
            return this;
        }

        public Builder setMinimize(boolean val) {
            this.minimize = val;
            return this;
        }

        public Builder setIncludeStaticStatic(boolean val) {
            this.includeStaticStatic = val;
            return this;
        }

        public Builder setCacheFile(File val) {
            this.cacheFile = val;
            return this;
        }

        public EmatCalculator build() {
            return new EmatCalculator(this.confEcalc, new PosInterGen(this.posInterDist, this.eref), this.minimize, this.includeStaticStatic, this.cacheFile);
        }
    }
}

