/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.FragmentEnergies;
import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TupleMatrixDouble;
import edu.duke.cs.osprey.ematrix.ReferenceEnergies;
import edu.duke.cs.osprey.tools.ObjectIO;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class EnergyMatrix
extends TupleMatrixDouble
implements FragmentEnergies {
    private static final long serialVersionUID = 6503270845014990929L;
    private double constTerm = 0.0;
    private ReferenceEnergies eRefMat = null;

    public static EnergyMatrix read(File file) throws ObjectIO.BadFileException {
        return ObjectIO.read(file, EnergyMatrix.class);
    }

    public static void write(EnergyMatrix emat, File file) throws ObjectIO.CantWriteException {
        ObjectIO.write((Object)emat, file);
    }

    public EnergyMatrix(ConfSpace cSpace, double pruningInterval) {
        super(cSpace, pruningInterval, 0.0);
    }

    public EnergyMatrix(SimpleConfSpace confSpace) {
        super(confSpace, Double.POSITIVE_INFINITY, 0.0);
    }

    public EnergyMatrix(ConfSpaceIteration confSpace) {
        super(confSpace);
    }

    public EnergyMatrix(int numPos, int[] numRCsAtPos, double pruningInterval) {
        super(numPos, numRCsAtPos, pruningInterval, 0.0);
    }

    public EnergyMatrix(EnergyMatrix other) {
        super(other);
        this.constTerm = other.constTerm;
    }

    public double rcContribAtPos(int pos, int[] conf, int numResInHot) {
        RCTuple tup = new RCTuple(conf);
        double E = this.getInternalEnergyAtPos(pos, tup, numResInHot);
        return E;
    }

    public double getInternalEnergyAtPos(int pos, RCTuple tup, int numResInHot) {
        int numPosInTuple = tup.pos.size();
        double E = 0.0;
        int posNum = tup.pos.get(pos);
        int RCNum = tup.RCs.get(pos);
        double intraE = this.getOneBody(posNum, RCNum);
        E += intraE;
        for (int index = 0; index < numPosInTuple; ++index) {
            if (index == posNum) continue;
            int pos2 = tup.pos.get(index);
            int rc2 = tup.RCs.get(index);
            double pairwiseE = this.getPairwise(posNum, RCNum, pos2, rc2);
            E += 0.5 * pairwiseE;
            HigherTupleFinder<Double> htf = this.getHigherOrderTerms(posNum, RCNum, pos2, rc2);
            if (htf == null) continue;
            E += 1.0 / (double)numResInHot * this.internalEHigherOrder(tup, index, htf);
        }
        return E;
    }

    public double confE(int[] conf) {
        return this.getInternalEnergy(new RCTuple(conf)) + this.constTerm;
    }

    public double getInternalEnergy(RCTuple tup) {
        int RCNum;
        int posNum;
        int indexInTuple;
        boolean useHigherOrderTerms = this.hasHigherOrderTerms();
        ArrayList<Integer> tuppos = tup.pos;
        ArrayList<Integer> tupRCs = tup.RCs;
        int numPosInTuple = tup.pos.size();
        double energy = 0.0;
        for (indexInTuple = 0; indexInTuple < numPosInTuple; ++indexInTuple) {
            posNum = tuppos.get(indexInTuple);
            RCNum = tupRCs.get(indexInTuple);
            energy += this.getOneBody(posNum, RCNum).doubleValue();
        }
        for (indexInTuple = 0; indexInTuple < numPosInTuple; ++indexInTuple) {
            posNum = tuppos.get(indexInTuple);
            RCNum = tupRCs.get(indexInTuple);
            for (int index2 = 0; index2 < indexInTuple; ++index2) {
                HigherTupleFinder<Double> htf;
                int pos2 = tuppos.get(index2);
                int rc2 = tupRCs.get(index2);
                energy += this.getPairwise(posNum, RCNum, pos2, rc2).doubleValue();
                if (!useHigherOrderTerms || (htf = this.getHigherOrderTerms(posNum, RCNum, pos2, rc2)) == null) continue;
                energy += this.internalEHigherOrder(tup, index2, htf);
            }
        }
        return energy;
    }

    @Override
    public double getEnergy(int pos, int rc) {
        return this.getOneBody(pos, rc);
    }

    @Override
    public double getEnergy(int pos1, int rc1, int pos2, int rc2) {
        return this.getPairwise(pos1, rc1, pos2, rc2);
    }

    public double getHigherOrderEnergy(RCTuple tup, int i1, int i2) {
        int rc2;
        int res2;
        int rc1;
        int res1 = tup.pos.get(i1);
        HigherTupleFinder<Double> htf = this.getHigherOrderTerms(res1, rc1 = tup.pos.get(i1).intValue(), res2 = tup.pos.get(i2).intValue(), rc2 = tup.RCs.get(i2).intValue());
        if (htf != null) {
            return this.internalEHigherOrder(tup, i2, htf);
        }
        return 0.0;
    }

    double internalEHigherOrder(RCTuple tup, int curIndex, HigherTupleFinder<Double> htf) {
        double E = 0.0;
        for (int ipos : htf.getInteractingPos()) {
            int iposIndex = -1;
            for (int ind = 0; ind < curIndex; ++ind) {
                if (tup.pos.get(ind) != ipos) continue;
                iposIndex = ind;
                break;
            }
            if (iposIndex <= -1) continue;
            int iposRC = tup.RCs.get(iposIndex);
            E += htf.getInteraction(ipos, iposRC).doubleValue();
            HigherTupleFinder<Double> htf2 = htf.getHigherInteractions(ipos, iposRC);
            if (htf2 == null) continue;
            E += this.internalEHigherOrder(tup, iposIndex, htf2);
        }
        return E;
    }

    public double getConstTerm() {
        return this.constTerm;
    }

    public void setConstTerm(double constTerm) {
        this.constTerm = constTerm;
    }

    public double[][] topPairwiseInteractions() {
        int numPos = this.getNumPos();
        double[][] strongestPairE = new double[numPos][numPos];
        for (int pos = 0; pos < numPos; ++pos) {
            for (int pos2 = 0; pos2 < pos; ++pos2) {
                for (int rc = 0; rc < this.getNumConfAtPos(pos); ++rc) {
                    for (int rc2 = 0; rc2 < this.getNumConfAtPos(pos2); ++rc2) {
                        strongestPairE[pos][pos2] = Math.max(strongestPairE[pos][pos2], Math.abs(this.getPairwise(pos, rc, pos2, rc2)));
                        strongestPairE[pos2][pos] = strongestPairE[pos][pos2];
                    }
                }
            }
        }
        return strongestPairE;
    }

    public EnergyMatrix diff(EnergyMatrix other) {
        if (this.getNumPos() != other.getNumPos()) {
            System.err.println("Cannot compare energy matrices of different size");
            return null;
        }
        EnergyMatrix diff = new EnergyMatrix(this.getNumPos(), this.getNumConfAtPos(), this.getPruningInterval());
        int numPos = this.getNumPos();
        for (int pos = 0; pos < numPos; ++pos) {
            for (int rc = 0; rc < this.getNumConfAtPos(pos); ++rc) {
                double myOneBody = this.getOneBody(pos, rc);
                double otherOneBody = other.getOneBody(pos, rc);
                diff.setOneBody(pos, rc, myOneBody - otherOneBody);
                for (int pos2 = 0; pos2 < pos; ++pos2) {
                    for (int rc2 = 0; rc2 < this.getNumConfAtPos(pos2); ++rc2) {
                        double myPairEnergy = this.getPairwise(pos, rc, pos2, rc2);
                        double otherPairEnergy = other.getPairwise(pos, rc, pos2, rc2);
                        diff.setPairwise(pos, rc, pos2, rc2, myPairEnergy - otherPairEnergy);
                    }
                }
            }
        }
        return diff;
    }

    public ReferenceEnergies geteRefMat() {
        return this.eRefMat;
    }

    public void seteRefMat(ReferenceEnergies val) {
        if (this.eRefMat != null) {
            throw new IllegalStateException("setting multiple reference energies more than once is not supported, this is a bug");
        }
        this.eRefMat = val;
        this.eRefMat.correctEnergyMatrix(this);
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        this.constTerm = in.readDouble();
        super.read(in);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeDouble(this.constTerm);
        super.write(out);
    }
}

