/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper.perts;

import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.deeper.GenChi1Calc;
import edu.duke.cs.osprey.dof.deeper.ResBBState;
import edu.duke.cs.osprey.dof.deeper.SidechainIdealizer;
import edu.duke.cs.osprey.dof.deeper.perts.PerturbationBlock;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.RigidBodyMotion;
import java.util.ArrayList;

public abstract class Perturbation
extends DegreeOfFreedom {
    PerturbationBlock block = null;
    int indexInBlock = -1;
    double curParamVal = 0.0;
    ArrayList<Residue> resDirectlyAffected;

    public Perturbation(ArrayList<Residue> resDirectlyAffected) {
        this.resDirectlyAffected = resDirectlyAffected;
    }

    @Override
    public void apply(double paramVal) {
        if (paramVal == this.curParamVal) {
            return;
        }
        this.curParamVal = paramVal;
        ArrayList<Residue> dependentResidues = this.block.dependentResidues.get(this.indexInBlock);
        ArrayList<Double> dependentGenChi1 = new ArrayList<Double>();
        for (Residue res : dependentResidues) {
            dependentGenChi1.add(GenChi1Calc.getGenChi1(res));
            ResBBState prePertState = this.block.prePertBBStates.get(this.indexInBlock).get(res);
            prePertState.putInState(res);
        }
        this.doPerturbationMotion(paramVal);
        this.block.updateSuccessorPrePertStates(this.indexInBlock);
        for (Perturbation successor : this.block.successors.get(this.indexInBlock)) {
            successor.doPerturbationMotion(successor.curParamVal);
            this.block.updateSuccessorPrePertStates(successor.indexInBlock);
        }
        for (int resNum = 0; resNum < dependentResidues.size(); ++resNum) {
            Residue res;
            res = dependentResidues.get(resNum);
            SidechainIdealizer.idealizeSidechain(EnvironmentVars.resTemplates, res);
            GenChi1Calc.setGenChi1(res, (Double)dependentGenChi1.get(resNum));
        }
    }

    public abstract boolean doPerturbationMotion(double var1);

    void movePeptidePlane(RigidBodyMotion motion, int startingRes, boolean includeFinalSCH) {
        Residue firstRes = this.resDirectlyAffected.get(startingRes);
        for (String atomName : new String[]{"C", "O"}) {
            motion.transform(firstRes.coords, firstRes.getAtomIndexByName(atomName));
        }
        Residue secondRes = this.resDirectlyAffected.get(startingRes + 1);
        if (includeFinalSCH) {
            for (int atomIndex = 0; atomIndex < secondRes.atoms.size(); ++atomIndex) {
                String atomName = secondRes.atoms.get((int)atomIndex).name;
                if (atomName.equalsIgnoreCase("C") || atomName.equalsIgnoreCase("O") || atomName.equalsIgnoreCase("OXT")) continue;
                motion.transform(secondRes.coords, atomIndex);
            }
        } else {
            ArrayList<String> res2PepAtoms = new ArrayList<String>();
            res2PepAtoms.add("N");
            if (secondRes.template.name.equalsIgnoreCase("PRO")) {
                res2PepAtoms.add("CD");
            } else {
                res2PepAtoms.add("H");
            }
            for (String atomName : res2PepAtoms) {
                motion.transform(secondRes.coords, secondRes.getAtomIndexByName(atomName));
            }
        }
    }

    void applyBackrubLikeMotion(RigidBodyMotion[] pepRots) {
        this.movePeptidePlane(pepRots[0], 0, true);
        this.movePeptidePlane(pepRots[1], 1, false);
    }

    public abstract Perturbation copyForNewMolecule(Molecule var1, PerturbationBlock var2);

    @Override
    public DOFBlock getBlock() {
        return this.block;
    }

    @Override
    public String getName() {
        return "PERT" + this.block.allResidues.get(0).getPDBResNumber() + "." + this.indexInBlock;
    }
}

