/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper;

import edu.duke.cs.osprey.dof.DihedralRotation;
import edu.duke.cs.osprey.dof.ProlinePucker;
import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.Protractor;
import edu.duke.cs.osprey.tools.RigidBodyMotion;
import edu.duke.cs.osprey.tools.RotationMatrix;
import edu.duke.cs.osprey.tools.VectorAlgebra;

public class SidechainIdealizer {
    public static void idealizeSidechain(ResidueTemplateLibrary templateLib, Residue res) {
        double[] NCoord = res.getCoordsByAtomName("N");
        double[] CACoord = res.getCoordsByAtomName("CA");
        double[] CCoord = res.getCoordsByAtomName("C");
        if (res.template.name.equalsIgnoreCase("GLY")) {
            int HASystem = 0;
            int HANum = res.getAtomIndexByName("HA2");
            if (HANum == -1) {
                HANum = res.getAtomIndexByName("1HA");
                HASystem = 1;
            }
            if (HANum == -1) {
                HANum = res.getAtomIndexByName("2HA");
                HASystem = 2;
            }
            if (HANum == -1) {
                throw new Error("could not parse HA names for " + res.fullName);
            }
            double[] t1 = VectorAlgebra.get4thPoint(NCoord, CCoord, CACoord, 1.1f, 109.3f, -121.6f);
            double[] t2 = VectorAlgebra.get4thPoint(CCoord, NCoord, CACoord, 1.1f, 109.3f, 121.6f);
            double[] newHA = VectorAlgebra.subtract(VectorAlgebra.scale(VectorAlgebra.add(t1, t2), 0.5), CACoord);
            newHA = VectorAlgebra.add(VectorAlgebra.scale(newHA, (double)1.1f / VectorAlgebra.norm(newHA)), CACoord);
            System.arraycopy(newHA, 0, res.coords, HANum * 3, 3);
            HANum = HASystem == 0 ? res.getAtomIndexByName("HA3") : (HASystem == 1 ? res.getAtomIndexByName("2HA") : res.getAtomIndexByName("3HA"));
            if (HANum == -1) {
                throw new Error("could not parse HA names for " + res.fullName);
            }
            t1 = VectorAlgebra.get4thPoint(NCoord, CCoord, CACoord, 1.1f, 109.3f, 121.6f);
            t2 = VectorAlgebra.get4thPoint(CCoord, NCoord, CACoord, 1.1f, 109.3f, -121.6f);
            newHA = VectorAlgebra.subtract(VectorAlgebra.scale(VectorAlgebra.add(t1, t2), 0.5), CACoord);
            newHA = VectorAlgebra.add(VectorAlgebra.scale(newHA, (double)1.1f / VectorAlgebra.norm(newHA)), CACoord);
            System.arraycopy(newHA, 0, res.coords, HANum * 3, 3);
        } else {
            double[] t2;
            double[] t1;
            double[] CBCoord = res.getCoordsByAtomName("CB");
            if (res.template.name.equalsIgnoreCase("ALA")) {
                t1 = VectorAlgebra.get4thPoint(NCoord, CCoord, CACoord, 1.536f, 110.1f, 122.9f);
                t2 = VectorAlgebra.get4thPoint(CCoord, NCoord, CACoord, 1.536f, 110.6f, -122.6f);
            } else if (res.template.name.equalsIgnoreCase("PRO")) {
                t1 = VectorAlgebra.get4thPoint(NCoord, CCoord, CACoord, 1.53f, 112.2f, 115.1f);
                t2 = VectorAlgebra.get4thPoint(CCoord, NCoord, CACoord, 1.53f, 103.0, -120.7f);
            } else if (res.template.name.equalsIgnoreCase("VAL") || res.template.name.equalsIgnoreCase("THR") || res.template.name.equalsIgnoreCase("ILE")) {
                t1 = VectorAlgebra.get4thPoint(NCoord, CCoord, CACoord, 1.54f, 109.1f, 123.4f);
                t2 = VectorAlgebra.get4thPoint(CCoord, NCoord, CACoord, 1.54f, 111.5, -122.0);
            } else {
                t1 = VectorAlgebra.get4thPoint(NCoord, CCoord, CACoord, 1.53f, 110.1f, 122.8f);
                t2 = VectorAlgebra.get4thPoint(CCoord, NCoord, CACoord, 1.53f, 110.5, -122.6f);
            }
            double[] idealCB = VectorAlgebra.scale(VectorAlgebra.add(t1, t2), 0.5);
            double[] ABOld = VectorAlgebra.subtract(CBCoord, CACoord);
            double[] ABNew = VectorAlgebra.subtract(idealCB, CACoord);
            double theta = Protractor.getAngleRadians(ABOld, ABNew);
            double[] rotax = VectorAlgebra.cross(ABOld, ABNew);
            if (VectorAlgebra.norm(rotax) != 0.0) {
                RotationMatrix SC_mtx = new RotationMatrix(rotax[0], rotax[1], rotax[2], theta, true);
                RigidBodyMotion SC_motion = new RigidBodyMotion(CACoord, SC_mtx, CACoord);
                SidechainIdealizer.moveSidechain(res, SC_motion);
            }
            t1 = VectorAlgebra.get4thPoint(NCoord, CCoord, CACoord, 1.1f, 107.9f, -118.3f);
            t2 = VectorAlgebra.get4thPoint(CCoord, NCoord, CACoord, 1.1f, 108.1f, 118.2f);
            double[] newHA = VectorAlgebra.subtract(VectorAlgebra.scale(VectorAlgebra.add(t1, t2), 0.5), CACoord);
            newHA = VectorAlgebra.add(VectorAlgebra.scale(newHA, (double)1.1f / VectorAlgebra.norm(newHA)), CACoord);
            int HANum = res.getAtomIndexByName("HA");
            System.arraycopy(newHA, 0, res.coords, HANum * 3, 3);
        }
        if (res.template.name.equalsIgnoreCase("PRO")) {
            SidechainIdealizer.idealizeProRing(templateLib, res);
        }
    }

    public static void moveSidechain(Residue res, RigidBodyMotion motion) {
        int numAtoms = res.atoms.size();
        for (int atomNum = 0; atomNum < numAtoms; ++atomNum) {
            String atomName = res.atoms.get((int)atomNum).name;
            if (!SidechainIdealizer.isSidechainAtom(atomName, res)) continue;
            motion.transform(res.coords, atomNum);
        }
    }

    static boolean isSidechainAtom(String atomName, Residue res) {
        if (atomName.startsWith("HA")) {
            return false;
        }
        if (res.template.name.equalsIgnoreCase("PRO") && atomName.startsWith("CD")) {
            return false;
        }
        for (String name2 : HardCodedResidueInfo.possibleBBAtoms) {
            if (!name2.equalsIgnoreCase(atomName)) continue;
            return false;
        }
        return true;
    }

    public static boolean idealizeProRing(ResidueTemplateLibrary templateLib, Residue res) {
        if (!res.template.name.equalsIgnoreCase("PRO")) {
            throw new Error("trying to idealize the proline ring on a non-proline");
        }
        double CANCD_ideal = 1.9460421159736774;
        double CACBCG_ideal = 1.8133970928221086;
        Residue idealPro = templateLib.getTemplateForMutation((String)"PRO", (Residue)res).templateRes;
        double[] NCoord = res.getCoordsByAtomName("N");
        double[] CACoord = res.getCoordsByAtomName("CA");
        double[] CBCoord = res.getCoordsByAtomName("CB");
        double[] CGCoord = res.getCoordsByAtomName("CG");
        double[] CDCoord = res.getCoordsByAtomName("CD");
        double[] ncd = VectorAlgebra.subtract(CDCoord, NCoord);
        double[] canhat = VectorAlgebra.subtract(NCoord, CACoord);
        double[] vhat = VectorAlgebra.perpendicularComponent(ncd, canhat);
        canhat = VectorAlgebra.scale(canhat, 1.0 / VectorAlgebra.norm(canhat));
        vhat = VectorAlgebra.scale(vhat, 1.0 / VectorAlgebra.norm(vhat));
        ncd = VectorAlgebra.scale(VectorAlgebra.add(VectorAlgebra.scale(canhat, -Math.cos(CANCD_ideal)), VectorAlgebra.scale(vhat, Math.sin(CANCD_ideal))), VectorAlgebra.norm(ncd));
        CDCoord = VectorAlgebra.add(ncd, NCoord);
        int CDNum = res.getAtomIndexByName("CD");
        System.arraycopy(CDCoord, 0, res.coords, 3 * CDNum, 3);
        double[] cbcg = VectorAlgebra.subtract(CGCoord, CBCoord);
        double[] cacbhat = VectorAlgebra.subtract(CBCoord, CACoord);
        double[] what = VectorAlgebra.perpendicularComponent(cbcg, cacbhat);
        cacbhat = VectorAlgebra.scale(cacbhat, 1.0 / VectorAlgebra.norm(cacbhat));
        what = VectorAlgebra.scale(what, 1.0 / VectorAlgebra.norm(what));
        cbcg = VectorAlgebra.scale(VectorAlgebra.add(VectorAlgebra.scale(cacbhat, -Math.cos(CACBCG_ideal)), VectorAlgebra.scale(what, Math.sin(CACBCG_ideal))), VectorAlgebra.norm(cbcg));
        CGCoord = VectorAlgebra.add(cbcg, CBCoord);
        int CGNum = res.getAtomIndexByName("CG");
        System.arraycopy(CGCoord, 0, res.coords, 3 * CGNum, 3);
        double[] dir2 = VectorAlgebra.perpendicularComponent(canhat, cacbhat);
        dir2 = VectorAlgebra.scale(dir2, 1.0 / VectorAlgebra.norm(dir2));
        double[] dir3 = VectorAlgebra.cross(cacbhat, dir2);
        double dBG = VectorAlgebra.norm(cbcg);
        double sina = Math.sin(CACBCG_ideal);
        double cosa = Math.cos(CACBCG_ideal);
        double CGCD = VectorAlgebra.norm(VectorAlgebra.subtract(idealPro.getCoordsByAtomName("CD"), idealPro.getCoordsByAtomName("CG")));
        double[] cbcd = VectorAlgebra.subtract(CDCoord, CBCoord);
        double r1 = VectorAlgebra.dot(cbcd, cacbhat);
        double r2 = VectorAlgebra.dot(cbcd, dir2);
        double r3 = VectorAlgebra.dot(cbcd, dir3);
        double A = ((r1 + cosa * dBG) * (r1 + cosa * dBG) + r2 * r2 + r3 * r3 + dBG * dBG * sina * sina - CGCD * CGCD) / (2.0 * dBG * sina);
        double R = Math.sqrt(r2 * r2 + r3 * r3);
        if (Math.abs(A / R) > 1.0) {
            res.pucker.setRingCloseable(false);
            return false;
        }
        res.pucker.setRingCloseable(true);
        double beta = Math.atan2(r2, r3);
        double asr = Math.asin(A / R);
        double newChi1 = res.pucker.getCurPucker() == ProlinePucker.Direction.UP ? asr - beta : Math.PI - beta - asr;
        newChi1 = 180.0 * newChi1 / Math.PI;
        double[][] dihCoords = new double[][]{NCoord, CACoord, CBCoord, CGCoord};
        double curChi1 = Protractor.measureDihedral(dihCoords);
        DihedralRotation dihRot = new DihedralRotation(CACoord, CBCoord, newChi1 - curChi1);
        dihRot.transform(res.coords, CGNum);
        SidechainIdealizer.idealizeRingHydrogens(res, idealPro);
        return true;
    }

    public static void idealizeRingHydrogens(Residue res, Residue idealPro) {
        double HBAngle = 1.8985691390141428;
        double HGAngle = 1.8931586609435378;
        double HDAngle = 1.8929840907340831;
        double HBDist = VectorAlgebra.norm(VectorAlgebra.subtract(idealPro.getCoordsByAtomName("HB2"), idealPro.getCoordsByAtomName("CB")));
        double HGDist = VectorAlgebra.norm(VectorAlgebra.subtract(idealPro.getCoordsByAtomName("HG2"), idealPro.getCoordsByAtomName("CG")));
        double HDDist = VectorAlgebra.norm(VectorAlgebra.subtract(idealPro.getCoordsByAtomName("HD2"), idealPro.getCoordsByAtomName("CD")));
        double[] CACoord = res.getCoordsByAtomName("CA");
        double[] CBCoord = res.getCoordsByAtomName("CB");
        double[] CGCoord = res.getCoordsByAtomName("CG");
        double[] CDCoord = res.getCoordsByAtomName("CD");
        double[] NCoord = res.getCoordsByAtomName("N");
        double[] CACB = VectorAlgebra.subtract(CBCoord, CACoord);
        double[] CBCG = VectorAlgebra.subtract(CGCoord, CBCoord);
        double[] CGCD = VectorAlgebra.subtract(CDCoord, CGCoord);
        double[] CDN = VectorAlgebra.subtract(NCoord, CDCoord);
        double[] BBisector = VectorAlgebra.average(CACB, VectorAlgebra.scale(CBCG, -1.0));
        double[] BPerpendicular = VectorAlgebra.cross(CACB, CBCG);
        double[] GBisector = VectorAlgebra.average(CBCG, VectorAlgebra.scale(CGCD, -1.0));
        double[] GPerpendicular = VectorAlgebra.cross(CBCG, CGCD);
        double[] DBisector = VectorAlgebra.average(CGCD, VectorAlgebra.scale(CDN, -1.0));
        double[] DPerpendicular = VectorAlgebra.cross(CGCD, CDN);
        BBisector = VectorAlgebra.scale(BBisector, HBDist * Math.cos(HBAngle / 2.0) / VectorAlgebra.norm(BBisector));
        GBisector = VectorAlgebra.scale(GBisector, HGDist * Math.cos(HGAngle / 2.0) / VectorAlgebra.norm(GBisector));
        DBisector = VectorAlgebra.scale(DBisector, HDDist * Math.cos(HDAngle / 2.0) / VectorAlgebra.norm(DBisector));
        BPerpendicular = VectorAlgebra.scale(BPerpendicular, HBDist * Math.sin(HBAngle / 2.0) / VectorAlgebra.norm(BPerpendicular));
        GPerpendicular = VectorAlgebra.scale(GPerpendicular, HGDist * Math.sin(HGAngle / 2.0) / VectorAlgebra.norm(GPerpendicular));
        DPerpendicular = VectorAlgebra.scale(DPerpendicular, HDDist * Math.sin(HDAngle / 2.0) / VectorAlgebra.norm(DPerpendicular));
        double[] HB1Coord = VectorAlgebra.add(CBCoord, VectorAlgebra.add(BBisector, BPerpendicular));
        double[] HB2Coord = VectorAlgebra.add(CBCoord, VectorAlgebra.subtract(BBisector, BPerpendicular));
        double[] HG1Coord = VectorAlgebra.add(CGCoord, VectorAlgebra.add(GBisector, GPerpendicular));
        double[] HG2Coord = VectorAlgebra.add(CGCoord, VectorAlgebra.subtract(GBisector, GPerpendicular));
        double[] HD1Coord = VectorAlgebra.add(CDCoord, VectorAlgebra.subtract(DBisector, DPerpendicular));
        double[] HD2Coord = VectorAlgebra.add(CDCoord, VectorAlgebra.add(DBisector, DPerpendicular));
        if (res.getAtomIndexByName("HB1") != -1) {
            System.arraycopy(HB1Coord, 0, res.coords, 3 * res.getAtomIndexByName("HB1"), 3);
            System.arraycopy(HB2Coord, 0, res.coords, 3 * res.getAtomIndexByName("HB2"), 3);
            System.arraycopy(HG1Coord, 0, res.coords, 3 * res.getAtomIndexByName("HG1"), 3);
            System.arraycopy(HG2Coord, 0, res.coords, 3 * res.getAtomIndexByName("HG2"), 3);
            System.arraycopy(HD1Coord, 0, res.coords, 3 * res.getAtomIndexByName("HD1"), 3);
            System.arraycopy(HD2Coord, 0, res.coords, 3 * res.getAtomIndexByName("HD2"), 3);
        } else if (res.getAtomIndexByName("HB2") != -1) {
            System.arraycopy(HB1Coord, 0, res.coords, 3 * res.getAtomIndexByName("HB2"), 3);
            System.arraycopy(HB2Coord, 0, res.coords, 3 * res.getAtomIndexByName("HB3"), 3);
            System.arraycopy(HG1Coord, 0, res.coords, 3 * res.getAtomIndexByName("HG2"), 3);
            System.arraycopy(HG2Coord, 0, res.coords, 3 * res.getAtomIndexByName("HG3"), 3);
            System.arraycopy(HD1Coord, 0, res.coords, 3 * res.getAtomIndexByName("HD2"), 3);
            System.arraycopy(HD2Coord, 0, res.coords, 3 * res.getAtomIndexByName("HD3"), 3);
        } else if (res.getAtomIndexByName("2HB") != -1) {
            System.arraycopy(HB1Coord, 0, res.coords, 3 * res.getAtomIndexByName("2HB"), 3);
            System.arraycopy(HB2Coord, 0, res.coords, 3 * res.getAtomIndexByName("3HB"), 3);
            System.arraycopy(HG1Coord, 0, res.coords, 3 * res.getAtomIndexByName("2HG"), 3);
            System.arraycopy(HG2Coord, 0, res.coords, 3 * res.getAtomIndexByName("3HG"), 3);
            System.arraycopy(HD1Coord, 0, res.coords, 3 * res.getAtomIndexByName("2HD"), 3);
            System.arraycopy(HD2Coord, 0, res.coords, 3 * res.getAtomIndexByName("3HD"), 3);
        } else {
            throw new Error("Can't parse atom names for " + res.fullName);
        }
    }
}

