/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.io;

import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.kstar.ConfSpaceInfo;
import edu.duke.cs.osprey.kstar.NewKStar;
import edu.duke.cs.osprey.kstar.ScoredSequence;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;

public class ScoredSequencePFuncStatsWriter
implements NewKStar.SequenceComputedListener {
    private final String outputDir;

    public ScoredSequencePFuncStatsWriter(String outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void onSequence(NewKStar kstar, ScoredSequence seq) {
        for (Map.Entry<String, ConfSpaceInfo> entry : Map.of("complex.csv", kstar.complex, "design.csv", kstar.ligand, "protein.csv", kstar.protein).entrySet()) {
            String csvFile = entry.getKey();
            ConfSpaceInfo info2 = entry.getValue();
            String seqStr = seq.sequence().toString(Sequence.Renderer.AssignmentMutations);
            String safeSeqStr = seqStr.replace(' ', '-');
            File outputFile = new File(this.outputDir, String.format("seq.%s.%s", safeSeqStr, csvFile));
            try (PrintWriter pw = new PrintWriter(outputFile);
                 ConfDB confDb = new ConfDB(info2.confSpace, info2.confDBFile);){
                String headings = String.join((CharSequence)",", "score", "energy", "assignments");
                pw.println(headings);
                Sequence localSeq = seq.sequence().filter(info2.confSpace.seqSpace());
                for (ConfSearch.EnergiedConf conf : confDb.getSequence(localSeq).energiedConfs(ConfDB.SortOrder.Energy)) {
                    double energy = conf.getEnergy();
                    double score = conf.getScore();
                    String asgStr = String.join((CharSequence)":", Arrays.stream(conf.getAssignments()).mapToObj(Integer::toString).toList());
                    pw.println(String.format("%.6f,%.6f,%s", score, energy, asgStr));
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

