/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.design.analysis.CommandAnalysis;
import edu.duke.cs.osprey.design.analysis.EnergyAnalysisConfListener;
import edu.duke.cs.osprey.design.analysis.ThermodynamicsConfListener;
import edu.duke.cs.osprey.design.commands.DelegatingCommand;
import edu.duke.cs.osprey.design.models.MoleculeDesign;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimplerEnergyMatrixCalculator;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.kstar.pfunc.GradientDescentPfunc;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.BigMath;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Parameters(commandDescription="Estimate the partition function value(s) of different conformations")
public class CommandPartitionFunction
extends DelegatingCommand {
    public static final String CommandName = "stability";
    static final String CommandDescription = "Estimate the partition function value(s) of different conformations";
    private final List<CommandAnalysis> confListeners = new LinkedList<CommandAnalysis>();
    @Parameter(names={"--thermodynamics"}, description="Calculate the enthalpy and entropy of ensembles.")
    private boolean captureThermodynamics;
    @Parameter(names={"--energy"}, description="Analyze the energy of conformation(s).")
    private List<Integer> captureEnergies = new ArrayList<Integer>();
    @Parameter(names={"--max-num-confs"}, description="Sets an upper bound on the number of conformations evaluated.")
    private int maxNumberConfs = -1;
    @Parameter(names={"--design-info"}, description="Print information about the design and exit")
    private boolean printDesignInfo;
    private ConfEnergyCalculator confEnergyCalc;
    private PartitionFunction pFunc;
    private RCs rcs;

    @Override
    public int run(JCommander commander, String[] args) {
        Optional<Integer> retVal = this.processHelpAndNoArgs(commander, args);
        if (retVal.isPresent()) {
            return retVal.get();
        }
        Optional<MoleculeDesign> designOpt = this.parseDesignSpec(MoleculeDesign.class);
        if (designOpt.isEmpty()) {
            return 1;
        }
        if (this.printDesignInfo) {
            return this.printDesignDebugInfo(designOpt.get());
        }
        return this.runStabilityDesign(designOpt.get());
    }

    @Override
    public String getCommandName() {
        return CommandName;
    }

    @Override
    public String getCommandDescription() {
        return CommandDescription;
    }

    private int printDesignDebugInfo(MoleculeDesign design) {
        SimpleConfSpace confSpace = this.delegate.createConfSpace(design.molecule, new ForcefieldParams());
        BigInteger numConfs = confSpace.getNumConformations();
        System.out.printf("Design: %s%n", design.designName);
        System.out.printf("Epsilon: %f%n", this.delegate.epsilon);
        System.out.printf("Number of conformations in design:\t%s%n", numConfs.toString());
        return 0;
    }

    private int runStabilityDesign(MoleculeDesign design) {
        ForcefieldParams ffParams = new ForcefieldParams();
        SimpleConfSpace confSpace = this.delegate.createConfSpace(design.molecule, ffParams);
        if (this.delegate.verifyInput) {
            return 0;
        }
        Parallelism parallelism = this.delegate.getParallelism();
        try (EnergyCalculator energyCalculator = new EnergyCalculator.Builder(confSpace, ffParams).setParallelism(parallelism).build();){
            this.confEnergyCalc = new ConfEnergyCalculator.Builder(confSpace, energyCalculator).build();
            this.rcs = new RCs(confSpace);
            double epsilon = this.delegate.epsilon > 0.0 ? this.delegate.epsilon : 0.63;
            EnergyMatrix energyMatrix = new SimplerEnergyMatrixCalculator.Builder(this.confEnergyCalc).build().calcEnergyMatrix();
            ConfAStarTree lowerAStarTree = new ConfAStarTree.Builder(energyMatrix, this.rcs).setMPLP().build();
            ConfAStarTree upperAStarTree = new ConfAStarTree.Builder(energyMatrix, this.rcs).setMPLP().build();
            try (TaskExecutor.ContextGroup ctx = energyCalculator.tasks.contextGroup();){
                this.pFunc = new GradientDescentPfunc(this.confEnergyCalc, lowerAStarTree, upperAStarTree, this.rcs.getNumConformations());
                this.pFunc.init(epsilon);
                this.pFunc.setInstanceId(0);
                this.pFunc.putTaskContexts(ctx);
                this.addListeners();
                this.pFunc.compute(this.maxNumberConfs > 0 ? this.maxNumberConfs : Integer.MAX_VALUE);
            }
            this.printResults();
            int n = 0;
            return n;
        }
    }

    private void printResults() {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        String percentEvaluated = numberFormat.format(new BigMath(PartitionFunction.decimalPrecision).set(this.pFunc.getNumConfsEvaluated()).div(this.rcs.getNumConformations().doubleValue()).get());
        System.out.println(String.format("Evaluated %s of conf space (%d / %s)", percentEvaluated, this.pFunc.getNumConfsEvaluated(), this.rcs.getNumConformations().toString()));
        System.out.println(this.pFunc.makeResult());
        for (CommandAnalysis listener : this.confListeners) {
            listener.printResults();
        }
    }

    private void addListeners() {
        if (!this.captureEnergies.isEmpty()) {
            List<Integer> oneIndexed = this.captureEnergies.stream().map(x -> x - 1).collect(Collectors.toList());
            EnergyAnalysisConfListener listener = new EnergyAnalysisConfListener(this.confEnergyCalc, oneIndexed);
            this.confListeners.add(listener);
            this.pFunc.setConfListener(listener);
        }
        if (this.captureThermodynamics) {
            ThermodynamicsConfListener listener = new ThermodynamicsConfListener();
            this.confListeners.add(listener);
            this.pFunc.setConfListener(listener);
        }
    }
}

